/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import java.util.Iterator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;

class FlattenTranslatorBatch<T>
extends TransformTranslator<PCollectionList<T>, PCollection<T>, Flatten.PCollections<T>> {
    FlattenTranslatorBatch() {
    }

    @Override
    public void translate(Flatten.PCollections<T> transform, TransformTranslator.Context cxt) {
        Dataset result;
        Collection<PCollection<?>> pCollections = cxt.getInputs().values();
        Coder outputCoder = ((PCollection)cxt.getOutput()).getCoder();
        Encoder outputEnc = cxt.windowedEncoder(outputCoder, this.windowCoder((PCollection)cxt.getOutput()));
        Iterator<PCollection<?>> pcIt = pCollections.iterator();
        if (pcIt.hasNext()) {
            result = this.getDataset(pcIt.next(), outputCoder, outputEnc, cxt);
            while (pcIt.hasNext()) {
                result = result.union(this.getDataset(pcIt.next(), outputCoder, outputEnc, cxt));
            }
        } else {
            result = cxt.createDataset(ImmutableList.of(), outputEnc);
        }
        cxt.putDataset((PCollection)cxt.getOutput(), result);
    }

    private Dataset<WindowedValue<T>> getDataset(PCollection<T> pc, Coder<T> coder, Encoder<WindowedValue<T>> enc, TransformTranslator.Context cxt) {
        Dataset current = cxt.getDataset(pc);
        return pc.getCoder().equals(coder) ? current : current.map(ScalaInterop.fun1(v -> v), enc);
    }
}

