/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCPreparedStatementImpl;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class AS400JDBCCallableStatement
extends AS400JDBCPreparedStatementImpl
implements CallableStatement {
    static final int NO_VALIDATION_ = -9999;
    private int[] registeredTypes_ = new int[this.parameterCount_];
    private boolean[] registered_ = new boolean[this.parameterCount_];
    private boolean returnValueParameterRegistered_;
    private boolean wasNull_;
    private boolean wasDataMappingError_;
    private int maxToLog_ = 10000;
    private Object byteArrayClass_;

    AS400JDBCCallableStatement(AS400JDBCConnection connection, int id, JDTransactionManager transactionManager, JDPackageManager packageManager, String blockCriteria, int blockSize, JDSQLStatement sqlStatement, String packageCriteria, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int generatedKeysRequested) throws SQLException {
        super(connection, id, transactionManager, packageManager, blockCriteria, blockSize, false, sqlStatement, true, packageCriteria, resultSetType, resultSetConcurrency, resultSetHoldability, generatedKeysRequested);
        for (int i = 0; i < this.parameterCount_; ++i) {
            this.registered_[i] = false;
        }
        this.returnValueParameterRegistered_ = false;
        this.wasNull_ = false;
        this.wasDataMappingError_ = false;
    }

    @Override
    void commonExecuteBefore(JDSQLStatement sqlStatement, DBSQLRequestDS request) throws SQLException {
        for (int i = 0; i < this.parameterCount_; ++i) {
            if (this.registered_[i] || !this.parameterRow_.isOutput(i + 1)) continue;
            JDError.throwSQLException((Object)this, "07001");
        }
        super.commonExecuteBefore(sqlStatement, request);
    }

    void validateParameterIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            JDError.throwSQLException((Object)this, "07009", parameterIndex + "<1");
        }
        if (parameterIndex > this.parameterCount_) {
            JDError.throwSQLException((Object)this, "07009", parameterIndex + ">" + this.parameterCount_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case 2000: 
                    case 2003: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Array value = data == null ? null : data.getArray();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (this.registeredTypes_[parameterIndex - 1] == -1) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            BigDecimal value = data == null ? null : data.getBigDecimal(-1);
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (scale < 0) {
            JDError.throwSQLException((Object)this, "HY094", "" + scale);
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            BigDecimal value = data == null ? null : data.getBigDecimal(scale);
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case 2000: 
                    case 2004: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Blob value = data == null ? null : data.getBlob();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            boolean value = data == null ? false : data.getBoolean();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            byte value = data == null ? (byte)0 : data.getByte();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            byte[] value = data == null ? null : data.getBytes();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case 2000: 
                    case 2005: 
                    case 2011: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Clob value = data == null ? null : data.getClob();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameterIndex(parameterName));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int parameterIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Date value = data == null ? null : data.getDate(calendar);
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(parameterName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            double value = data == null ? 0.0 : data.getDouble();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            float value = data == null ? 0.0f : data.getFloat();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            int value = data == null ? 0 : data.getInt();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            long value = data == null ? 0L : data.getLong();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            if (data == null) {
                return null;
            }
            Object value = data == null ? null : data.getObject();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    public Object getObject(int parameterIndex, Map typeMap) throws SQLException {
        if (typeMap == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return this.getObject(parameterIndex);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName));
    }

    public Object getObject(String parameterName, Map typeMap) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName));
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
        return null;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                this.validateNumericRegisteredType(this.registeredTypes_[parameterIndex - 1], parameterIndex);
                data = this.getValue(parameterIndex);
            }
            short value = data == null ? (short)0 : data.getShort();
            this.testDataTruncation(parameterIndex, data, true);
            return value;
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            String value = data == null ? null : data.getString();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameterIndex(parameterName));
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int parameterIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Time value = data == null ? null : data.getTime(calendar);
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(parameterName), calendar);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, AS400Calendar.getGregorianInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            Timestamp value = data == null ? null : data.getTimestamp(calendar);
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(parameterName), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case 1: 
                    case 12: 
                    case 70: 
                    case 2000: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            String value = data == null ? null : data.getString();
            this.testDataTruncation(parameterIndex, data, false);
            if (value != null) {
                try {
                    return new URL(value);
                }
                catch (MalformedURLException e) {
                    JDError.throwSQLException((Object)this, "07006", e);
                    return null;
                }
            }
            return null;
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameterIndex(parameterName));
    }

    private SQLData getValue(int parameterIndex) throws SQLException {
        if (!this.executed_) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        SQLData data = this.parameterRow_.getSQLData(parameterIndex);
        this.wasNull_ = this.parameterRow_.isNull(parameterIndex);
        this.wasDataMappingError_ = this.parameterRow_.isDataMappingError(parameterIndex);
        return this.wasNull_ ? null : data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (parameterIndex == 1) {
                    if (sqlType != 4) {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                    this.returnValueParameterRegistered_ = true;
                    return;
                }
                --parameterIndex;
            }
            this.validateParameterIndex(parameterIndex);
            if (scale < 0) {
                JDError.throwSQLException((Object)this, "HY094");
            }
            if (!this.parameterRow_.isOutput(parameterIndex)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            this.registeredTypes_[parameterIndex - 1] = sqlType;
            this.registered_[parameterIndex - 1] = true;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType, 0);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(parameterName), sqlType, 0);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setAsciiStream(this.findParameterIndex(parameterName), parameterValue, length);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBigDecimal()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setBigDecimal(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setBinaryStream(this.findParameterIndex(parameterName), parameterValue, length);
    }

    @Override
    public void setBoolean(String parameterName, boolean parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBoolean()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setBoolean(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setByte(String parameterName, byte parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setByte()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setByte(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setBytes(String parameterName, byte[] parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBytes()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                StringBuffer parameterStringBuffer = new StringBuffer();
                Trace.printByteArray(parameterStringBuffer, parameterValue);
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterStringBuffer.toString());
            }
        }
        this.setBytes(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader parameterValue, int length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setCharacterStream(this.findParameterIndex(parameterName), parameterValue, length);
    }

    @Override
    public void setDate(String parameterName, Date parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setDate(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setDate(String parameterName, Date parameterValue, Calendar cal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setDate(this.findParameterIndex(parameterName), parameterValue, cal);
    }

    @Override
    public void setDouble(String parameterName, double parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDouble()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setDouble(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setFloat(String parameterName, float parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFloat()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setFloat(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setInt(String parameterName, int parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setInt()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setInt(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setLong(String parameterName, long parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setLong()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setLong(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
        }
        this.setNull(this.findParameterIndex(parameterName), sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
        }
        this.setNull(this.findParameterIndex(parameterName), sqlType, typeName);
    }

    @Override
    public void setObject(String parameterName, Object parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " type: " + parameterValue.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setObject(String parameterName, Object parameterValue, int targetSqlType) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " type: " + parameterValue.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(parameterName), parameterValue, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object parameterValue, int targetSqlType, int scale) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " type: " + parameterValue.getClass().getName());
            }
        }
        this.setObject(this.findParameterIndex(parameterName), parameterValue, targetSqlType, scale);
    }

    @Override
    public void setShort(String parameterName, short parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setShort()");
            JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
        }
        this.setShort(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setString(String parameterName, String parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setString()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else if (parameterValue.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + parameterValue.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue);
            }
        }
        this.setString(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setTime(String parameterName, Time parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setTime(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setTime(String parameterName, Time parameterValue, Calendar cal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setTime(this.findParameterIndex(parameterName), parameterValue, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setTimestamp(this.findParameterIndex(parameterName), parameterValue);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp parameterValue, Calendar cal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setTimestamp(this.findParameterIndex(parameterName), parameterValue, cal);
    }

    @Override
    public void setURL(String parameterName, URL parameterValue) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setURL()");
            if (parameterValue == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + parameterValue.toString());
            }
        }
        this.setURL(this.findParameterIndex(parameterName), parameterValue);
    }

    private void testDataTruncation(int parameterIndex, SQLData data, boolean exceptionOnTrunc) throws SQLException {
        int truncated;
        if (this.wasDataMappingError_) {
            this.postDataTruncationWarning(parameterIndex, true, true, -1, -1);
        }
        if (data != null && (truncated = data.getTruncated()) > 0) {
            if (exceptionOnTrunc && data.getOutOfBounds()) {
                JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
            }
            int actualSize = data.getActualSize();
            this.postDataTruncationWarning(parameterIndex, true, true, actualSize, actualSize - truncated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return this.wasNull_;
        }
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCCallableStatement", "java.sql.CallableStatement"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            Reader value = data == null ? null : data.getCharacterStream();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            Reader value = data == null ? null : data.getNCharacterStream();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                switch (this.registeredTypes_[parameterIndex - 1]) {
                    case 2000: 
                    case 2005: 
                    case 2011: {
                        break;
                    }
                    default: {
                        JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
                    }
                }
                data = this.getValue(parameterIndex);
            }
            NClob value = data == null ? null : data.getNClob();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            String value = data == null ? null : data.getNString();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            RowId value = data == null ? null : data.getRowId();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.findParameterIndex(parameterName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            SQLData data = null;
            if (this.useReturnValueParameter_ && parameterIndex == 1) {
                if (!this.returnValueParameterRegistered_) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.returnValueParameter_;
            } else {
                if (this.useReturnValueParameter_) {
                    --parameterIndex;
                }
                this.validateParameterIndex(parameterIndex);
                if (!this.parameterRow_.isOutput(parameterIndex)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.registered_[parameterIndex - 1]) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                data = this.getValue(parameterIndex);
            }
            SQLXML value = data == null ? null : data.getSQLXML();
            this.testDataTruncation(parameterIndex, data, false);
            return value;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(parameterName));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setAsciiStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setBinaryStream(this.findParameterIndex(parameterName), x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + x.length());
            }
        }
        this.setBlob(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setBlob(this.findParameterIndex(parameterName), inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setCharacterStream(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + x.length());
            }
        }
        this.setClob(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setClob(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setNCharacterStream(this.findParameterIndex(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + value.length());
            }
        }
        this.setNClob(this.findParameterIndex(parameterName), value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + length);
            }
        }
        this.setNClob(this.findParameterIndex(parameterName), reader, length);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNString()");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else if (value.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + value.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + value);
            }
        }
        this.setNString(this.findParameterIndex(parameterName), value);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setRowId()");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: " + x.toString());
            }
        }
        this.setRowId(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (xmlObject == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " length: " + xmlObject.toString().length());
            }
        }
        this.setSQLXML(this.findParameterIndex(parameterName), xmlObject);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream(String, InputStream)");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setAsciiStream(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream(String, InputStream)");
            if (x == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setBinaryStream(this.findParameterIndex(parameterName), x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob(String, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setBlob(this.findParameterIndex(parameterName), inputStream);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setCharacterStream(this.findParameterIndex(parameterName), reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setClob(this.findParameterIndex(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream(String, Reader)");
            if (value == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setNCharacterStream(this.findParameterIndex(parameterName), value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob(String, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + this.findParameterIndex(parameterName) + " value: NULL");
            }
        }
        this.setNClob(this.findParameterIndex(parameterName), reader);
    }

    public Object getObject(int parameterIndex, Class type) throws SQLException {
        if (type == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byteArray = new byte[1];
            this.byteArrayClass_ = byteArray.getClass();
        }
        if (type == String.class) {
            return this.getString(parameterIndex);
        }
        if (type == Byte.class) {
            byte b = this.getByte(parameterIndex);
            if (b == 0 && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Short.class) {
            short s = this.getShort(parameterIndex);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        if (type == Integer.class) {
            int i = this.getInt(parameterIndex);
            if (i == 0 && this.wasNull()) {
                return null;
            }
            return i;
        }
        if (type == Long.class) {
            long l = this.getLong(parameterIndex);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return l;
        }
        if (type == Float.class) {
            float f = this.getFloat(parameterIndex);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return Float.valueOf(f);
        }
        if (type == Double.class) {
            double d = this.getDouble(parameterIndex);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return d;
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(parameterIndex);
        }
        if (type == Boolean.class) {
            boolean b = this.getBoolean(parameterIndex);
            if (!b && this.wasNull()) {
                return null;
            }
            return b;
        }
        if (type == Date.class) {
            return this.getDate(parameterIndex);
        }
        if (type == Time.class) {
            return this.getTime(parameterIndex);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(parameterIndex);
        }
        if (type == this.byteArrayClass_) {
            return this.getBytes(parameterIndex);
        }
        if (type == InputStream.class) {
            Blob b = this.getBlob(parameterIndex);
            if (b == null) {
                return b;
            }
            return b.getBinaryStream();
        }
        if (type == Reader.class) {
            return this.getCharacterStream(parameterIndex);
        }
        if (type == Clob.class) {
            return this.getClob(parameterIndex);
        }
        if (type == Blob.class) {
            return this.getBlob(parameterIndex);
        }
        if (type == Array.class) {
            return this.getArray(parameterIndex);
        }
        if (type == Ref.class) {
            return this.getRef(parameterIndex);
        }
        if (type == URL.class) {
            return this.getURL(parameterIndex);
        }
        if (type == NClob.class) {
            return this.getNClob(parameterIndex);
        }
        if (type == RowId.class) {
            return this.getRowId(parameterIndex);
        }
        if (type == SQLXML.class) {
            return this.getSQLXML(parameterIndex);
        }
        if (type == Object.class) {
            return this.getObject(parameterIndex);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String parameterName, Class type) throws SQLException {
        return this.getObject(this.findParameterIndex(parameterName), type);
    }

    private void validateNumericRegisteredType(int registeredType, int parameterIndex) throws SQLException {
        switch (registeredType) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                JDError.throwSQLException((Object)this, "07006", "P#=" + parameterIndex);
            }
        }
    }

    static int mapSQLTypeCS(Object targetSqlType) throws SQLException {
        return 0;
    }

    public void setObject(String parameterName, Object x, Object targetSqlType, int scaleOrLength) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(targetSqlType);
        this.setObject(parameterName, x, intType, scaleOrLength);
    }

    public void setObject(String parameterName, Object x, Object targetSqlType) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(targetSqlType);
        this.setObject(parameterName, x, intType);
    }

    public void registerOutParameter(int parameterIndex, Object sqlType) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterIndex, intType);
    }

    public void registerOutParameter(int parameterIndex, Object sqlType, int scale) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterIndex, intType, scale);
    }

    public void registerOutParameter(int parameterIndex, Object sqlType, String typeName) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterIndex, intType, typeName);
    }

    public void registerOutParameter(String parameterName, Object sqlType) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterName, intType);
    }

    public void registerOutParameter(String parameterName, Object sqlType, int scale) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterName, intType, scale);
    }

    public void registerOutParameter(String parameterName, Object sqlType, String typeName) throws SQLException {
        int intType = AS400JDBCCallableStatement.mapSQLTypeCS(sqlType);
        this.registerOutParameter(parameterName, intType, typeName);
    }
}

