/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTableCaption;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTable
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4552974069573452181L;
    private Vector rows_ = new Vector();
    private HTMLTableCaption caption_;
    private Vector headerTag_;
    private String alignment_;
    private int borderWidth_ = 0;
    private int cellPadding_ = -1;
    private int cellSpacing_ = -1;
    private int width_ = 0;
    private boolean headerInUse_ = true;
    private boolean widthPercent_ = false;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private transient Vector rowListeners_;
    private transient VetoableChangeSupport vetos_;

    public HTMLTable() {
    }

    public HTMLTable(HTMLTableRow[] rows) {
        this();
        if (rows == null) {
            throw new NullPointerException("rows");
        }
        for (int i = 0; i < rows.length; ++i) {
            this.addRow(rows[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(HTMLTableCell[] column) {
        if (column == null) {
            throw new NullPointerException("column");
        }
        int size = this.rows_.size();
        Vector vector = this.rows_;
        synchronized (vector) {
            if (size == 0) {
                for (int i = 0; i < column.length; ++i) {
                    HTMLTableRow row = new HTMLTableRow();
                    row.addColumn(column[i]);
                    this.rows_.addElement(row);
                }
            } else {
                if (column.length != size) {
                    throw new ExtendedIllegalArgumentException("column", 1);
                }
                for (int i = 0; i < size; ++i) {
                    HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
                    row.addColumn(column[i]);
                }
            }
        }
    }

    public void addColumnHeader(String header) {
        this.addColumnHeader(new HTMLTableHeader(new HTMLText(header)));
    }

    public void addColumnHeader(HTMLTableHeader header) {
        if (header == null) {
            throw new NullPointerException("header");
        }
        if (header.getElement() == null) {
            Trace.log(2, "The HTMLTableHeader's element attribute is invalid.");
            throw new ExtendedIllegalArgumentException("header", 2);
        }
        if (this.headerTag_ == null) {
            this.headerTag_ = new Vector();
        }
        this.headerTag_.addElement(header);
    }

    public void addRow(HTMLTableRow row) {
        if (row == null) {
            throw new NullPointerException("row");
        }
        this.rows_.addElement(row);
        this.fireAdded();
    }

    public void addRowListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowListeners_ == null) {
            this.rowListeners_ = new Vector();
        }
        this.rowListeners_.addElement(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireAdded() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.rowListeners_.clone();
        ElementEvent event = new ElementEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementAdded(event);
        }
    }

    private void fireChanged() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.rowListeners_.clone();
        ElementEvent event = new ElementEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementChanged(event);
        }
    }

    private void fireRemoved() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.rowListeners_.clone();
        ElementEvent event = new ElementEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementRemoved(event);
        }
    }

    public String getAlignment() {
        return this.alignment_;
    }

    public int getBorderWidth() {
        return this.borderWidth_;
    }

    public HTMLTableCaption getCaption() {
        return this.caption_;
    }

    public int getCellPadding() {
        return this.cellPadding_;
    }

    public int getCellSpacing() {
        return this.cellSpacing_;
    }

    public HTMLTableCell[] getColumn(int columnIndex) {
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to get a column before adding a row to the table.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        HTMLTableCell[] list = new HTMLTableCell[this.rows_.size()];
        int size = this.rows_.size();
        for (int i = 0; i < size; ++i) {
            HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
            list[i] = row.getColumn(columnIndex);
        }
        return list;
    }

    public HTMLTableHeader getColumnHeader(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return (HTMLTableHeader)this.headerTag_.elementAt(columnIndex);
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    private String getEndTableTag() {
        if (!this.useFO_) {
            return "</table>\n";
        }
        return "</fo:table>\n</fo:block>";
    }

    public HTMLTableHeader[] getHeader() {
        if (this.headerTag_ == null) {
            return null;
        }
        Object[] list = new HTMLTableHeader[this.headerTag_.size()];
        this.headerTag_.copyInto(list);
        return list;
    }

    public String getHeaderTag() {
        int i;
        if (this.headerTag_ == null) {
            return "";
        }
        StringBuffer tag = new StringBuffer();
        if (!this.useFO_) {
            tag.append("<tr>\n");
        } else {
            int size = this.headerTag_.size();
            int column_width = 100 / size;
            for (i = 0; i < size; ++i) {
                tag.append("<fo:table-column column-width='");
                tag.append(column_width);
                tag.append("pt'/>\n");
            }
            tag.append("<fo:table-header>\n");
            tag.append("<fo:table-row>\n");
        }
        int size = this.headerTag_.size();
        for (i = 0; i < size; ++i) {
            HTMLTableHeader colHeader = (HTMLTableHeader)this.headerTag_.elementAt(i);
            if (!this.useFO_) {
                tag.append(colHeader.getTag());
                continue;
            }
            colHeader.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                colHeader.setCellPadding(this.cellPadding_);
            }
            tag.append(colHeader.getFOTag());
        }
        if (!this.useFO_) {
            tag.append("</tr>\n");
        } else {
            tag.append("</fo:table-row>\n");
            tag.append("</fo:table-header>\n");
        }
        return tag.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public int getRowCount() {
        return this.rows_.size();
    }

    public HTMLTableRow getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        return (HTMLTableRow)this.rows_.elementAt(rowIndex);
    }

    private String getStartTableTag() {
        StringBuffer tag = new StringBuffer("");
        if (!this.useFO_) {
            tag.append("<table");
            if (this.alignment_ != null) {
                tag.append(" align=\"");
                tag.append(this.alignment_);
                tag.append("\"");
            }
            if (this.borderWidth_ > 0) {
                tag.append(" border=\"");
                tag.append(this.borderWidth_);
                tag.append("\"");
            }
            if (this.cellPadding_ >= 0) {
                tag.append(" cellpadding=\"");
                tag.append(this.cellPadding_);
                tag.append("\"");
            }
            if (this.cellSpacing_ >= 0) {
                tag.append(" cellspacing=\"");
                tag.append(this.cellSpacing_);
                tag.append("\"");
            }
            if (this.width_ > 0) {
                tag.append(" width=\"");
                tag.append(this.width_);
                if (this.widthPercent_) {
                    tag.append("%");
                }
                tag.append("\"");
            }
            tag.append(this.getLanguageAttributeTag());
            tag.append(this.getDirectionAttributeTag());
            tag.append(this.getAttributeString());
            tag.append(">\n");
            if (this.caption_ != null) {
                tag.append(this.caption_.getTag());
            }
        } else {
            tag.append("<fo:block");
            if (this.alignment_ != null) {
                if (this.alignment_.equals("left")) {
                    tag.append(" text-align='start'");
                } else if (this.alignment_.equals("right")) {
                    tag.append(" text-align='end'");
                } else if (this.alignment_.equals("center")) {
                    tag.append(" text-align='center'");
                }
            }
            tag.append(">\n");
            if (this.caption_ != null) {
                tag.append(this.caption_.getFOTag());
            }
            tag.append("<fo:table");
            tag.append(this.getDirectionAttributeTag());
            tag.append(">\n");
        }
        return tag.toString();
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        StringBuffer tag = new StringBuffer(this.getStartTableTag());
        if (this.headerInUse_) {
            if (this.rows_.size() > 0) {
                if (this.headerTag_ == null) {
                    Trace.log(2, "Attempting to get the table tag before setting the table header.");
                    throw new ExtendedIllegalStateException("header", 4);
                }
                int hdrSize = this.headerTag_.size();
                for (int i = 0; i < this.rows_.size(); ++i) {
                    if (hdrSize >= ((HTMLTableRow)this.rows_.elementAt(i)).getColumnCount()) continue;
                    Trace.log(2, "Attempting to get the table tag when the length of the table header is invalid.");
                    throw new ExtendedIllegalArgumentException("header or row " + i, 1);
                }
            }
            tag.append(this.getHeaderTag());
        }
        int size = this.rows_.size();
        for (int i = 0; i < size; ++i) {
            HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
            tag.append(row.getTag());
        }
        tag.append(this.getEndTableTag());
        return tag.toString();
    }

    @Override
    public String getFOTag() {
        int size;
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        StringBuffer tag = new StringBuffer(this.getStartTableTag());
        if (this.headerInUse_) {
            if (this.rows_.size() > 0) {
                if (this.headerTag_ == null) {
                    Trace.log(2, "Attempting to get the XSL-FO table tag before setting the table header.");
                    throw new ExtendedIllegalStateException("header", 4);
                }
                int hdrSize = this.headerTag_.size();
                size = this.rows_.size();
                for (int i = 0; i < size; ++i) {
                    if (hdrSize >= ((HTMLTableRow)this.rows_.elementAt(i)).getColumnCount()) continue;
                    Trace.log(2, "Attempting to get the table tag when the length of the table header is invalid.");
                    throw new ExtendedIllegalArgumentException("header or row " + i, 1);
                }
            }
            tag.append(this.getHeaderTag());
        }
        try {
            HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(0);
            size = row.getColumnCount();
        }
        catch (Exception e) {
            size = 0;
        }
        if (!this.headerInUse_) {
            int column_width = 100 / size;
            for (int i = 0; i < size; ++i) {
                tag.append("<fo:table-column column-width='");
                tag.append(column_width);
                tag.append("pt'/>\n");
            }
        }
        tag.append("<fo:table-body>\n");
        size = this.rows_.size();
        for (int i = 0; i < size; ++i) {
            HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
            row.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                row.setCellPadding(this.cellPadding_);
            }
            tag.append(row.getFOTag());
        }
        tag.append("</fo:table-body>\n");
        tag.append(this.getEndTableTag());
        this.setUseFO(useFO);
        return tag.toString();
    }

    public int getWidth() {
        return this.width_;
    }

    public boolean isHeaderInUse() {
        return this.headerInUse_;
    }

    public boolean isWidthInPercent() {
        return this.widthPercent_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeAllRows() {
        this.rows_.removeAllElements();
        this.fireRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(int columnIndex) {
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to remove a column before adding a row to the table.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        Vector vector = this.rows_;
        synchronized (vector) {
            int size = this.rows_.size();
            for (int i = 0; i < size; ++i) {
                HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
                row.removeColumn(row.getColumn(columnIndex));
            }
            if (this.headerTag_ != null && columnIndex < this.headerTag_.size()) {
                this.removeColumnHeader(columnIndex);
            }
        }
    }

    public void removeColumnHeader(int columnIndex) {
        if (this.headerTag_ == null) {
            Trace.log(2, "Attempting to remove a column header before adding the header list to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (columnIndex < 0 || columnIndex >= this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.headerTag_.removeElementAt(columnIndex);
    }

    public void removeColumnHeader(HTMLTableHeader header) {
        if (this.headerTag_ == null) {
            Trace.log(2, "Attempting to remove a column header before adding the header list to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (header == null) {
            throw new NullPointerException("header");
        }
        if (!this.headerTag_.removeElement(header)) {
            throw new ExtendedIllegalArgumentException("header", 2);
        }
    }

    public void removeRow(HTMLTableRow row) {
        if (row == null) {
            throw new NullPointerException("row");
        }
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to remove a row when the table is empty.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        if (this.rows_.removeElement(row)) {
            this.fireRemoved();
        }
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(rowIndex);
        this.fireRemoved();
    }

    public void removeRowListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowListeners_ != null) {
            this.rowListeners_.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("left") || alignment.equalsIgnoreCase("center") || alignment.equalsIgnoreCase("right")) {
            String old = this.alignment_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.alignment_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setBorderWidth(int borderWidth) throws PropertyVetoException {
        if (borderWidth < 0) {
            throw new ExtendedIllegalArgumentException("borderWidth", 4);
        }
        int oldWidth = this.borderWidth_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("borderWidth", (Object)oldWidth, (Object)borderWidth);
        }
        this.borderWidth_ = borderWidth;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", (Object)oldWidth, (Object)borderWidth);
        }
    }

    public void setCaption(String caption) throws PropertyVetoException {
        this.setCaption(new HTMLTableCaption(new HTMLText(caption)));
    }

    public void setCaption(HTMLTableCaption caption) throws PropertyVetoException {
        if (caption == null) {
            throw new NullPointerException("caption");
        }
        HTMLTableCaption old = this.caption_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("caption", old, caption);
        }
        this.caption_ = caption;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("caption", old, caption);
        }
    }

    public void setCellPadding(int cellPadding) throws PropertyVetoException {
        if (cellPadding < -1) {
            throw new ExtendedIllegalArgumentException("cellPadding", 4);
        }
        int oldPadding = this.cellPadding_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cellPadding", (Object)oldPadding, (Object)cellPadding);
        }
        this.cellPadding_ = cellPadding;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", (Object)oldPadding, (Object)cellPadding);
        }
    }

    public void setCellSpacing(int cellSpacing) throws PropertyVetoException {
        if (cellSpacing < -1) {
            throw new ExtendedIllegalArgumentException("cellSpacing", 4);
        }
        int oldSpacing = this.cellSpacing_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cellSpacing", (Object)oldSpacing, (Object)cellSpacing);
        }
        this.cellSpacing_ = cellSpacing;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellSpacing", (Object)oldSpacing, (Object)cellSpacing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumn(HTMLTableCell[] column, int columnIndex) {
        if (column == null) {
            throw new NullPointerException("column");
        }
        int size = this.rows_.size();
        if (size == 0) {
            this.addColumn(column);
            return;
        }
        if (column.length != size) {
            throw new ExtendedIllegalArgumentException("column", 1);
        }
        if (columnIndex < 0 || columnIndex > ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        Vector vector = this.rows_;
        synchronized (vector) {
            for (int i = 0; i < size; ++i) {
                HTMLTableRow row = (HTMLTableRow)this.rows_.elementAt(i);
                row.setColumn(column[i], columnIndex);
            }
        }
    }

    public void setColumnHeader(String header, int columnIndex) throws PropertyVetoException {
        this.setColumnHeader(new HTMLTableHeader(new HTMLText(header)), columnIndex);
    }

    public void setColumnHeader(HTMLTableHeader header, int columnIndex) throws PropertyVetoException {
        if (header == null) {
            throw new NullPointerException("header");
        }
        if (this.headerTag_ == null) {
            if (columnIndex == 0) {
                this.addColumnHeader(header);
                return;
            }
            Trace.log(2, "Attempting to change a column header before adding a column header to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (header.getElement() == null) {
            Trace.log(2, "The HTMLTableHeader's element attribute is invalid.");
            throw new ExtendedIllegalArgumentException("header", 2);
        }
        if (columnIndex < 0 || columnIndex > this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        if (columnIndex == this.headerTag_.size()) {
            this.addColumnHeader(header);
            return;
        }
        Vector old = this.headerTag_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("header", old, this.headerTag_);
        }
        this.headerTag_.setElementAt(header, columnIndex);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("header", old, this.headerTag_);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setHeader(HTMLTableHeader[] header) throws PropertyVetoException {
        if (header == null) {
            throw new NullPointerException("header");
        }
        if (!this.rows_.isEmpty() && header.length != ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
            throw new ExtendedIllegalArgumentException("header", 1);
        }
        Vector old = this.headerTag_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("header", old, header);
        }
        this.headerTag_ = new Vector();
        for (int i = 0; i < header.length; ++i) {
            this.headerTag_.addElement(header[i]);
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("header", old, header);
        }
    }

    public void setHeader(String[] header) throws PropertyVetoException {
        if (header == null) {
            throw new NullPointerException("header");
        }
        HTMLTableHeader[] tableHeader = new HTMLTableHeader[header.length];
        for (int column = 0; column < header.length; ++column) {
            tableHeader[column] = new HTMLTableHeader(new HTMLText(header[column]));
        }
        this.setHeader(tableHeader);
    }

    public void setHeaderInUse(boolean headerInUse) throws PropertyVetoException {
        boolean oldUse = this.headerInUse_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("useHeader", (Object)oldUse, (Object)headerInUse);
        }
        this.headerInUse_ = headerInUse;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useHeader", (Object)oldUse, (Object)headerInUse);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setRow(HTMLTableRow row, int rowIndex) {
        if (row == null) {
            throw new NullPointerException("row");
        }
        if (rowIndex < 0 || rowIndex > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        if (rowIndex == this.rows_.size()) {
            this.addRow(row);
        } else {
            if (row.getColumnCount() != ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
                throw new ExtendedIllegalArgumentException("row", 1);
            }
            this.rows_.setElementAt(row, rowIndex);
            this.fireChanged();
        }
    }

    public void setWidth(int width) throws PropertyVetoException {
        if (width < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int oldWidth = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", (Object)oldWidth, (Object)width);
        }
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", (Object)oldWidth, (Object)width);
        }
    }

    public void setWidth(int width, boolean widthInPercent) throws PropertyVetoException {
        int oldWidth = this.width_;
        this.setWidth(width);
        try {
            this.setWidthInPercent(widthInPercent);
        }
        catch (PropertyVetoException e) {
            this.width_ = oldWidth;
            throw new PropertyVetoException("widthInPercent", e.getPropertyChangeEvent());
        }
    }

    public void setWidthInPercent(boolean widthInPercent) throws PropertyVetoException {
        boolean oldValue = this.widthPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("widthInPercent", (Object)oldValue, (Object)widthInPercent);
        }
        this.widthPercent_ = widthInPercent;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("widthInPercent", (Object)oldValue, (Object)widthInPercent);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

