/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class TextAreaFormElement
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -1548160614340950478L;
    private String name_;
    private int rows_;
    private int cols_;
    private String text_;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;

    public TextAreaFormElement() {
        this.rows_ = 0;
        this.cols_ = 0;
    }

    public TextAreaFormElement(String name) {
        this();
        try {
            this.setName(name);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public TextAreaFormElement(String name, int rows, int cols) {
        try {
            this.setName(name);
            this.setRows(rows);
            this.setColumns(cols);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public int getColumns() {
        return this.cols_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public String getName() {
        return this.name_;
    }

    public int getRows() {
        return this.rows_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A TextAreaFormElement was here -->";
    }

    @Override
    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("<textarea");
        s.append(" name=\"");
        s.append(this.name_);
        s.append("\"");
        s.append(" rows=\"");
        s.append(this.rows_);
        s.append("\"");
        s.append(" cols=\"");
        s.append(this.cols_);
        s.append("\"");
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">\n");
        if (this.text_ != null) {
            s.append(this.text_);
        }
        s.append("</textarea>");
        return s.toString();
    }

    public String getText() {
        return this.text_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setColumns(int cols) throws PropertyVetoException {
        if (cols < 0) {
            throw new ExtendedIllegalArgumentException("cols", 4);
        }
        int old = this.cols_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cols", (Object)old, (Object)cols);
        }
        this.cols_ = cols;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cols", (Object)old, (Object)cols);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name);
        }
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setRows(int rows) throws PropertyVetoException {
        if (rows < 0) {
            throw new ExtendedIllegalArgumentException("rows", 4);
        }
        int old = this.rows_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("rows", (Object)old, (Object)rows);
        }
        this.rows_ = rows;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("rows", (Object)old, (Object)rows);
        }
    }

    public void setText(String text) throws PropertyVetoException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        String old = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", old, text);
        }
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

