/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterConditionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.core.widget.TextVarButton;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class TableView
extends Composite {
    private static final Class<?> PKG = TableView.class;
    public static final String ID_TOOLBAR = "TableView-Toolbar";
    public static final String ID_TOOLBAR_INSERT_ROW_BEFORE = "tableview-toolbar-10000-insert-row-before";
    public static final String ID_TOOLBAR_INSERT_ROW_AFTER = "tableview-toolbar-10010-insert-row-after";
    public static final String ID_TOOLBAR_MOVE_ROWS_UP = "tableview-toolbar-10100-move-rows-up";
    public static final String ID_TOOLBAR_MOVE_ROWS_DOWN = "tableview-toolbar-10110-move-rows-down";
    public static final String ID_TOOLBAR_CLEAR_ALL = "tableview-toolbar-10200-clear-all";
    public static final String ID_TOOLBAR_SELECT_ALL_ROWS = "tableview-toolbar-10300-select-all-rows";
    public static final String ID_TOOLBAR_CLEAR_SELECTION = "tableview-toolbar-10310-clear-selection";
    public static final String ID_TOOLBAR_FILTERED_SELECTION = "tableview-toolbar-10320-filtered-selection";
    public static final String ID_TOOLBAR_COPY_SELECTED = "tableview-toolbar-10400-copy-selected";
    public static final String ID_TOOLBAR_PASTE_TO_TABLE = "tableview-toolbar-10410-paste-to-table";
    public static final String ID_TOOLBAR_CUT_SELECTED = "tableview-toolbar-10420-cut-selected";
    public static final String ID_TOOLBAR_DELETE_SELECTED = "tableview-toolbar-10430-delete-selected";
    public static final String ID_TOOLBAR_KEEP_SELECTED = "tableview-toolbar-10440-keep-selected";
    public static final String ID_TOOLBAR_COPY_TO_ALL_ROWS = "tableview-toolbar-10500-copy-to-all-rows";
    public static final String ID_TOOLBAR_UNDO = "tableview-toolbar-10600-undo";
    public static final String ID_TOOLBAR_REDO = "tableview-toolbar-10610-redo";
    private static final String CANCEL_KEYS = "org.eclipse.rap.rwt.cancelKeys";
    private final Composite parent;
    private final ColumnInfo[] columns;
    private boolean readonly;
    private int buttonRowNr;
    private int buttonColNr;
    private String buttonContent;
    private boolean previousShift;
    private int selectionStart;
    public final Table table;
    private TableEditor editor;
    private final TableColumn[] tableColumn;
    private final PropsUi props;
    private final boolean toolbarEnabled;
    private ToolBar toolbar;
    private GuiToolbarWidgets toolbarWidgets;
    private Control text;
    private Combo combo;
    private ComboVar comboVar;
    private Button button;
    private TableItem activeTableItem;
    private int activeTableColumn;
    private int activeTableRow;
    private final KeyListener lsKeyText;
    private final KeyListener lsKeyCombo;
    private final FocusListener lsFocusText;
    private final FocusListener lsFocusCombo;
    private final ModifyListener lsModCombo;
    private final TraverseListener lsTraverse;
    private final Listener lsFocusInTabItem;
    private final Listener lsKeyUp;
    private int sortField;
    private int sortFieldLast;
    private boolean sortingDescending;
    private Boolean sortingDescendingLast;
    private boolean sortable;
    private int lastRowCount;
    private boolean fieldChanged;
    private boolean undoEnabled;
    private ModifyListener lsMod;
    private final ModifyListener lsUndo;
    private ModifyListener lsContent;
    private Clipboard clipboard;
    private ArrayList<ChangeAction> undo;
    private int undoPosition;
    private String[] beforeEdit;
    private MenuItem miEditUndo;
    private MenuItem miEditRedo;
    private static final String CLIPBOARD_DELIMITER = "\t";
    private Condition condition;
    private final Color defaultBackgroundColor;
    private final Map<String, Color> usedColors;
    private ColumnInfo numberColumn;
    protected int textWidgetCaretPosition;
    private final IVariables variables;
    private boolean showingBlueNullValues;
    private boolean showingConversionErrorsInline;
    private boolean isTextButton = false;
    private boolean addIndexColumn = true;
    private final Color nullTextColor;
    private List<Integer> nonEmptyIndexes;
    private ITableViewModifyListener tableViewModifyListener = new ITableViewModifyListener(){

        @Override
        public void moveRow(int position1, int position2) {
        }

        @Override
        public void insertRow(int rowIndex) {
        }

        @Override
        public void cellFocusLost(int rowIndex) {
        }

        @Override
        public void delete(int[] items) {
        }
    };

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, ModifyListener lsm, PropsUi pr) {
        this(variables, parent, style, columnInfo, nrRows, false, lsm, pr);
    }

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUi pr) {
        this(variables, parent, style, columnInfo, nrRows, readOnly, lsm, pr, true);
    }

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUi pr, boolean addIndexColumn) {
        this(variables, parent, style, columnInfo, nrRows, readOnly, lsm, pr, addIndexColumn, null);
    }

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUi pr, boolean addIndexColumn, Listener listener) {
        this(variables, parent, style, columnInfo, nrRows, readOnly, lsm, pr, addIndexColumn, listener, true);
    }

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUi pr, boolean addIndexColumn, Listener listener, boolean undoEnabled) {
        this(variables, parent, style, columnInfo, nrRows, readOnly, lsm, pr, addIndexColumn, listener, undoEnabled, true);
    }

    public TableView(IVariables variables, Composite parent, int style, ColumnInfo[] columnInfo, int nrRows, boolean readOnly, ModifyListener lsm, PropsUi pr, boolean addIndexColumn, Listener listener, boolean undoEnabled, boolean toolbarEnabled) {
        super(parent, 0x6C0000);
        this.parent = parent;
        this.columns = columnInfo;
        this.props = pr;
        this.readonly = readOnly;
        this.clipboard = null;
        this.variables = variables;
        this.addIndexColumn = addIndexColumn;
        this.lsFocusInTabItem = listener;
        this.undoEnabled = undoEnabled;
        this.toolbarEnabled = toolbarEnabled;
        this.sortField = 0;
        this.sortFieldLast = -1;
        this.sortingDescending = false;
        this.sortingDescendingLast = null;
        this.nullTextColor = GuiResource.getInstance().getColorBlue();
        this.sortable = true;
        this.selectionStart = -1;
        this.previousShift = false;
        this.usedColors = new Hashtable<String, Color>();
        this.condition = null;
        this.lsMod = lsm;
        this.clearUndo();
        this.numberColumn = new ColumnInfo("#", 1, true, true);
        ValueMetaInteger numberColumnValueMeta = new ValueMetaInteger("#");
        numberColumnValueMeta.setConversionMask("####0.###");
        this.numberColumn.setValueMeta((IValueMeta)numberColumnValueMeta);
        this.lsUndo = arg0 -> {
            this.fieldChanged = true;
        };
        FormLayout controlLayout = new FormLayout();
        controlLayout.marginLeft = 0;
        controlLayout.marginRight = 0;
        controlLayout.marginTop = 0;
        controlLayout.marginBottom = 0;
        this.setLayout((Layout)controlLayout);
        this.addToolbar();
        this.table = new Table((Composite)this, style | 2);
        PropsUi.setLook((Widget)this.table);
        this.table.setLinesVisible(true);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.top = this.props.isShowTableViewToolbar() ? new FormAttachment((Control)this.toolbar, 0) : new FormAttachment(0, 0);
        fdTable.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)fdTable);
        this.tableColumn = new TableColumn[this.columns.length + 1];
        this.tableColumn[0] = new TableColumn(this.table, 131072);
        this.tableColumn[0].setResizable(true);
        this.tableColumn[0].setText("#");
        this.tableColumn[0].setWidth(addIndexColumn ? 25 : 0);
        this.tableColumn[0].setAlignment(131072);
        for (int i = 0; i < this.columns.length; ++i) {
            IValueMeta valueMeta;
            int allignment = this.columns[i].getAlignment();
            this.tableColumn[i + 1] = new TableColumn(this.table, allignment);
            this.tableColumn[i + 1].setResizable(true);
            String columnName = this.columns[i].getName();
            if (columnName != null) {
                if (Const.isWindows() || Const.isLinux()) {
                    columnName = columnName.replaceAll("\\&", "&&");
                }
                this.tableColumn[i + 1].setText(columnName);
            }
            if (this.columns[i].getToolTip() != null) {
                this.tableColumn[i + 1].setToolTipText(this.columns[i].getToolTip());
            }
            if ((valueMeta = this.columns[i].getValueMeta()) != null && valueMeta.isNumeric()) {
                this.tableColumn[i + 1].setAlignment(131072);
            }
            this.tableColumn[i + 1].pack();
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        if (nrRows > 0) {
            this.table.setItemCount(nrRows);
        } else {
            this.table.setItemCount(1);
        }
        this.defaultBackgroundColor = this.table.getItem(0).getBackground();
        this.setRowNums();
        this.table.setSortColumn(this.table.getColumn(this.sortField));
        this.table.setSortDirection(this.sortingDescending ? 1024 : 128);
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.addRightClickMenu(undoEnabled);
        this.lsFocusText = this.createTextFocusListener();
        this.lsFocusCombo = this.createComboFocusListener();
        this.lsModCombo = this.createComboModifyListener();
        this.lsKeyText = this.createTextKeyListener();
        this.lsKeyCombo = this.createComboKeyListener();
        this.table.addKeyListener(this.createTableKeyListener());
        this.lsKeyUp = this.createKeyUpListener();
        this.table.addMouseListener(this.createTableMouseListener());
        int nrcols = this.tableColumn.length;
        for (int i = 0; i < nrcols; ++i) {
            int colNr = i;
            this.tableColumn[i].addListener(13, e -> {
                this.clearUndo();
                this.sortTable(colNr);
            });
        }
        this.lsTraverse = e -> {
            e.doit = false;
        };
        this.table.addTraverseListener(this.lsTraverse);
        this.table.setData(CANCEL_KEYS, (Object)new String[]{"TAB", "SHIFT+TAB"});
        this.table.addListener(13, e -> this.enableToolbarButtons());
        this.addDisposeListener(e -> {
            if (this.clipboard != null) {
                this.clipboard.dispose();
                this.clipboard = null;
            }
        });
        this.addDragAndDropSupport();
        this.table.layout();
        this.table.pack();
        this.optWidth(true);
        this.enableToolbarButtons(nrRows);
        this.layout();
        this.pack();
    }

    private void enableToolbarButtons() {
        this.enableToolbarButtons(this.nrNonEmpty());
    }

    private void enableToolbarButtons(int nrRows) {
        if (this.toolbar == null) {
            return;
        }
        boolean linesSelected = this.table.getSelectionCount() > 0;
        boolean hasRows = nrRows > 0;
        boolean activeCell = this.activeTableItem != null && this.activeTableColumn > 0;
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_CLEAR_ALL, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_INSERT_ROW_AFTER, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_INSERT_ROW_BEFORE, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_COPY_SELECTED, linesSelected);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_KEEP_SELECTED, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_PASTE_TO_TABLE, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_DELETE_SELECTED, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_CUT_SELECTED, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_MOVE_ROWS_DOWN, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_MOVE_ROWS_UP, linesSelected && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_COPY_TO_ALL_ROWS, activeCell && !this.readonly);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_SELECT_ALL_ROWS, hasRows);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_CLEAR_SELECTION, hasRows);
        this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_FILTERED_SELECTION, hasRows);
    }

    private void addDragAndDropSupport() {
        Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource ddSource = new DragSource((Control)this.table, 3);
        ddSource.setTransfer(ttypes);
        ddSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = "TableView" + Const.CR + TableView.this.getSelectedText();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private MouseListener createTableMouseListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                boolean rightClick;
                if (TableView.this.activeTableItem != null && !TableView.this.activeTableItem.isDisposed() && TableView.this.editor != null && TableView.this.editor.getEditor() != null && !TableView.this.editor.getEditor().isDisposed() && TableView.this.activeTableColumn > 0) {
                    switch (TableView.this.columns[TableView.this.activeTableColumn - 1].getType()) {
                        case 1: {
                            TableView.this.applyTextChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                            break;
                        }
                        case 2: {
                            TableView.this.applyComboChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                        }
                    }
                }
                boolean bl = rightClick = event.button == 3;
                if (event.button == 1 || rightClick) {
                    boolean control;
                    boolean shift = (event.stateMask & 0x20000) != 0;
                    boolean bl2 = control = (event.stateMask & SWT.MOD1) != 0;
                    if (!shift && !control) {
                        Rectangle clientArea = TableView.this.table.getClientArea();
                        Point pt = new Point(event.x, event.y);
                        for (int index = TableView.this.table.getTopIndex(); index < TableView.this.table.getItemCount(); ++index) {
                            boolean visible = false;
                            TableItem item = TableView.this.table.getItem(index);
                            for (int i = 0; i < TableView.this.table.getColumnCount(); ++i) {
                                Rectangle rect = item.getBounds(i);
                                if (rect.contains(pt)) {
                                    TableView.this.activeTableItem = item;
                                    TableView.this.activeTableColumn = i;
                                    TableView.this.activeTableRow = index;
                                    if (!rightClick) {
                                        TableView.this.editSelected();
                                    }
                                    return;
                                }
                                if (i == TableView.this.table.getColumnCount() - 1 && pt.x > rect.x + rect.width && pt.y >= rect.y && pt.y <= rect.y + rect.height) {
                                    return;
                                }
                                if (visible || !rect.intersects(clientArea)) continue;
                                visible = true;
                            }
                            if (visible) continue;
                            return;
                        }
                        if (rightClick) {
                            return;
                        }
                        TableView.this.setPosition(TableView.this.table.getItemCount() - 1, 1);
                        TableView.this.insertRowAfter();
                    }
                }
            }
        };
    }

    private Listener createKeyUpListener() {
        return event -> {
            if (this.table.isDisposed()) {
                return;
            }
            TableItem row = this.activeTableItem;
            if (row == null) {
                return;
            }
            int rowNr = this.table.indexOf(row);
            int colNr = this.activeTableColumn;
            String value = this.getTextWidgetValue(colNr);
            String[] fBeforeEdit = this.beforeEdit;
            String[] afterEdit = this.getItemText(row);
            this.checkChanged(new String[][]{fBeforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
            row.setText(colNr, value);
        };
    }

    private KeyListener createTableKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean ctrl;
                boolean shift;
                if (TableView.this.activeTableItem == null) {
                    return;
                }
                int maxcols = TableView.this.table.getColumnCount();
                int maxrows = TableView.this.table.getItemCount();
                boolean bl = shift = (e.stateMask & 0x20000) != 0;
                if (!TableView.this.previousShift && shift || TableView.this.selectionStart < 0) {
                    TableView.this.selectionStart = TableView.this.activeTableRow;
                }
                TableView.this.previousShift = shift;
                boolean bl2 = ctrl = (e.stateMask & SWT.MOD1) != 0;
                if (!TableView.this.readonly && e.keyCode == 0x1000002 && ctrl) {
                    TableView.this.moveRowsDown();
                    e.doit = false;
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 0x1000001 && ctrl) {
                    TableView.this.moveRowsUp();
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000002 && shift) {
                    ++TableView.this.activeTableRow;
                    if (TableView.this.activeTableRow >= maxrows) {
                        TableView.this.activeTableRow = maxrows - 1;
                    }
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000001 && shift) {
                    --TableView.this.activeTableRow;
                    if (TableView.this.activeTableRow < 0) {
                        TableView.this.activeTableRow = 0;
                    }
                    TableView.this.selectRows(TableView.this.activeTableRow, TableView.this.selectionStart);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000007 && shift) {
                    TableView.this.activeTableRow = 0;
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.activeTableItem);
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000008 && shift) {
                    TableView.this.activeTableRow = maxrows;
                    TableView.this.selectRows(TableView.this.selectionStart, TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.activeTableItem);
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 0x1000002 && !shift || e.keyCode == 0x1000001 && !shift || e.keyCode == 0x1000007 && !shift || e.keyCode == 0x1000008 && !shift) {
                    switch (e.keyCode) {
                        case 0x1000002: {
                            ++TableView.this.activeTableRow;
                            if (TableView.this.activeTableRow < maxrows) break;
                            if (!TableView.this.readonly) {
                                TableView.this.insertRowAfter();
                                break;
                            }
                            TableView.this.activeTableRow = maxrows - 1;
                            break;
                        }
                        case 0x1000001: {
                            --TableView.this.activeTableRow;
                            if (TableView.this.activeTableRow >= 0) break;
                            TableView.this.activeTableRow = 0;
                            break;
                        }
                        case 0x1000007: {
                            TableView.this.activeTableRow = 0;
                            break;
                        }
                        case 0x1000008: {
                            TableView.this.activeTableRow = maxrows - 1;
                            break;
                        }
                    }
                    TableView.this.setPosition(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    TableView.this.table.deselectAll();
                    TableView.this.table.select(TableView.this.activeTableRow);
                    TableView.this.table.showItem(TableView.this.table.getItem(TableView.this.activeTableRow));
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 97 && ctrl) {
                    e.doit = false;
                    TableView.this.selectAll();
                    return;
                }
                if (e.keyCode == 27) {
                    e.doit = false;
                    TableView.this.unselectAll();
                    TableView.this.selectRows(TableView.this.activeTableRow, TableView.this.activeTableRow);
                    TableView.this.setFocus();
                    return;
                }
                if (e.keyCode == 99 && ctrl) {
                    e.doit = false;
                    TableView.this.clipSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 107 && ctrl) {
                    e.doit = false;
                    TableView.this.keepSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 120 && ctrl) {
                    e.doit = false;
                    TableView.this.cutSelected();
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 118 && ctrl) {
                    e.doit = false;
                    TableView.this.pasteSelected();
                    return;
                }
                if (e.keyCode == 0x100000C) {
                    e.doit = false;
                    TableView.this.optWidth(true);
                    return;
                }
                if (!TableView.this.readonly && e.keyCode == 127) {
                    e.doit = false;
                    TableView.this.delSelected();
                    return;
                }
                if (e.keyCode == 0x100000D) {
                    e.doit = false;
                    TableView.this.optWidth(false);
                    return;
                }
                if (TableView.this.undoEnabled) {
                    if (e.keyCode == 121 && ctrl) {
                        e.doit = false;
                        TableView.this.redoAction();
                        return;
                    }
                    if (e.keyCode == 122 && ctrl) {
                        e.doit = false;
                        TableView.this.undoAction();
                        return;
                    }
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000004 || e.keyCode == 9) {
                    TableView.this.activeTableColumn = 1;
                    TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    e.doit = false;
                    return;
                }
                if (TableView.this.activeTableColumn > 0) {
                    boolean textChar;
                    boolean bl3 = textChar = e.character >= 'a' && e.character <= 'z' || e.character >= 'A' && e.character <= 'Z' || e.character >= '0' && e.character <= '9' || e.character == ' ' || e.character == '_' || e.character == ',' || e.character == '.' || e.character == '+' || e.character == '-' || e.character == '*' || e.character == '/' || e.character == ';';
                    if (e.character == '\r' || e.keyCode == 0x100000B || textChar) {
                        boolean selectText = true;
                        char extraChar = '\u0000';
                        if (textChar) {
                            extraChar = e.character;
                            selectText = false;
                        }
                        e.doit = false;
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn, selectText, extraChar);
                    }
                    if (e.character == '\t') {
                        if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0) {
                            ++TableView.this.activeTableColumn;
                        }
                        if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0) {
                            --TableView.this.activeTableColumn;
                        }
                        if (TableView.this.activeTableColumn < 1) {
                            TableView.this.activeTableColumn = maxcols - 1;
                            if (TableView.this.activeTableRow > 0) {
                                --TableView.this.activeTableRow;
                            }
                        }
                        if (TableView.this.activeTableColumn >= maxcols) {
                            TableView.this.activeTableColumn = 1;
                            ++TableView.this.activeTableRow;
                        }
                        if (TableView.this.activeTableRow >= maxrows) {
                            TableItem item = new TableItem(TableView.this.table, 0, TableView.this.activeTableRow);
                            item.setText(1, "");
                            TableView.this.setRowNums();
                        }
                        e.doit = false;
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    }
                }
                TableView.this.setFocus();
                TableView.this.table.setFocus();
            }
        };
    }

    private KeyListener createComboKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableView.this.comboKeyPressed(e);
            }
        };
    }

    private KeyListener createTextKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean right = false;
                boolean left = false;
                if (e.character == '\r' || e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 9 || left || right) {
                    if (TableView.this.activeTableItem == null) {
                        return;
                    }
                    TableView.this.applyTextChange(TableView.this.activeTableItem, TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    int maxCols = TableView.this.table.getColumnCount();
                    int maxRows = TableView.this.table.getItemCount();
                    boolean editNextCell = false;
                    if (e.keyCode == 0x1000002 && TableView.this.activeTableRow < maxRows - 1) {
                        ++TableView.this.activeTableRow;
                        editNextCell = true;
                    }
                    if (e.keyCode == 0x1000001 && TableView.this.activeTableRow > 0) {
                        --TableView.this.activeTableRow;
                        editNextCell = true;
                    }
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0 || right) {
                        ++TableView.this.activeTableColumn;
                        editNextCell = true;
                    }
                    if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0 || left) {
                        --TableView.this.activeTableColumn;
                        editNextCell = true;
                    }
                    if (TableView.this.activeTableColumn < 1) {
                        TableView.this.activeTableColumn = maxCols - 1;
                        if (TableView.this.activeTableRow > 0) {
                            --TableView.this.activeTableRow;
                        }
                    }
                    if (TableView.this.activeTableColumn >= maxCols) {
                        TableView.this.activeTableColumn = 1;
                        ++TableView.this.activeTableRow;
                    }
                    if (TableView.this.activeTableRow >= maxRows) {
                        TableItem item = new TableItem(TableView.this.table, 0, TableView.this.activeTableRow);
                        item.setText(1, "");
                        TableView.this.setRowNums();
                    }
                    TableView.this.activeTableItem = TableView.this.table.getItem(TableView.this.activeTableRow);
                    if (editNextCell) {
                        TableView.this.edit(TableView.this.activeTableRow, TableView.this.activeTableColumn);
                    } else if (e.keyCode == 0x1000002 && TableView.this.activeTableRow == maxRows - 1) {
                        TableView.this.insertRowAfter();
                    }
                } else if (e.keyCode == 27) {
                    TableView.this.text.dispose();
                    TableView.this.table.setFocus();
                }
            }
        };
    }

    private ModifyListener createComboModifyListener() {
        return e -> {
            TableItem row = this.activeTableItem;
            if (row == null) {
                return;
            }
            int colNr = this.activeTableColumn;
            int rowNr = this.table.indexOf(row);
            boolean usingVariables = this.columns[colNr - 1].isUsingVariables();
            if (usingVariables) {
                row.setText(colNr, this.comboVar.getText());
            } else {
                row.setText(colNr, this.combo.getText());
            }
            String[] afterEdit = this.getItemText(row);
            this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
        };
    }

    private FocusAdapter createComboFocusListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableItem row = TableView.this.activeTableItem;
                if (row == null) {
                    return;
                }
                int colNr = TableView.this.activeTableColumn;
                int rowNr = TableView.this.table.indexOf(row);
                if (colNr > 0) {
                    try {
                        boolean usingVariables = TableView.this.columns[colNr - 1].isUsingVariables();
                        if (usingVariables) {
                            row.setText(colNr, TableView.this.comboVar.getText());
                        } else {
                            row.setText(colNr, TableView.this.combo.getText());
                        }
                    }
                    catch (Exception usingVariables) {
                        // empty catch block
                    }
                    String[] afterEdit = TableView.this.getItemText(row);
                    if (afterEdit != null) {
                        TableView.this.checkChanged(new String[][]{TableView.this.beforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
                    }
                }
                TableView.this.tableViewModifyListener.cellFocusLost(rowNr);
            }
        };
    }

    protected FocusListener createTextFocusListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (this.isWrongLostFocusEvent()) {
                    return;
                }
                Display d = Display.getCurrent();
                if (TableView.this.table.isDisposed()) {
                    return;
                }
                TableItem row = TableView.this.activeTableItem;
                if (row == null) {
                    return;
                }
                int colNr = TableView.this.activeTableColumn;
                int rowNr = TableView.this.table.indexOf(row);
                Control ftext = TableView.this.text;
                String[] fBeforeEdit = TableView.this.beforeEdit;
                TableView.this.textWidgetCaretPosition = TableView.this.getTextWidgetCaretPosition(colNr);
                String value = TableView.this.getTextWidgetValue(colNr);
                Runnable worker = () -> {
                    try {
                        if (row.isDisposed()) {
                            return;
                        }
                        row.setText(colNr, value);
                        ftext.dispose();
                        String[] afterEdit = TableView.this.getItemText(row);
                        TableView.this.checkChanged(new String[][]{fBeforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                if (!row.isDisposed()) {
                    row.setText(colNr, value);
                }
                if (TableView.this.columns[colNr - 1].getType() == 6) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Runnable r = () -> d.asyncExec(worker);
                    Thread t = new Thread(r);
                    t.start();
                } else {
                    worker.run();
                }
                TableView.this.tableViewModifyListener.cellFocusLost(rowNr);
            }

            private boolean isWrongLostFocusEvent() {
                Control controlGotFocus = Display.getCurrent().getCursorControl();
                return Const.isLinux() && (controlGotFocus == null || TableView.this.text.equals(controlGotFocus));
            }
        };
    }

    private void addRightClickMenu(boolean undoEnabled) {
        Menu mRow = new Menu((Control)this.table);
        MenuItem miRowInsBef = new MenuItem(mRow, 0);
        miRowInsBef.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.InsertBeforeRow", (String[])new String[0])));
        MenuItem miRowInsAft = new MenuItem(mRow, 0);
        miRowInsAft.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.InsertAfterRow", (String[])new String[0])));
        new MenuItem(mRow, 2);
        MenuItem miRowUp = new MenuItem(mRow, 0);
        miRowUp.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.MoveUp", (String[])new String[0])));
        MenuItem miRowDown = new MenuItem(mRow, 0);
        miRowDown.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.MoveDown", (String[])new String[0])));
        MenuItem miCol1 = new MenuItem(mRow, 0);
        miCol1.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.OptimalSizeWithHeader", (String[])new String[0])));
        MenuItem miCol2 = new MenuItem(mRow, 0);
        miCol2.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.OptimalSizeWithoutHeader", (String[])new String[0])));
        new MenuItem(mRow, 2);
        MenuItem miClear = new MenuItem(mRow, 0);
        miClear.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.ClearAll", (String[])new String[0])));
        new MenuItem(mRow, 2);
        MenuItem miSelAll = new MenuItem(mRow, 0);
        miSelAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.SelectAll", (String[])new String[0])));
        MenuItem miUnselAll = new MenuItem(mRow, 0);
        miUnselAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.ClearSelection", (String[])new String[0])));
        MenuItem miFilter = new MenuItem(mRow, 0);
        miFilter.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.FilteredSelection", (String[])new String[0])));
        new MenuItem(mRow, 2);
        MenuItem miClipAll = new MenuItem(mRow, 0);
        miClipAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CopyToClipboard", (String[])new String[0])));
        MenuItem miPasteAll = new MenuItem(mRow, 0);
        miPasteAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.PasteFromClipboard", (String[])new String[0])));
        MenuItem miCutAll = new MenuItem(mRow, 0);
        miCutAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CutSelected", (String[])new String[0])));
        MenuItem miDelAll = new MenuItem(mRow, 0);
        miDelAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.DeleteSelected", (String[])new String[0])));
        MenuItem miKeep = new MenuItem(mRow, 0);
        miKeep.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.KeepSelected", (String[])new String[0])));
        new MenuItem(mRow, 2);
        MenuItem miCopyToAll = new MenuItem(mRow, 0);
        miCopyToAll.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.CopyFieldToAllRows", (String[])new String[0])));
        if (undoEnabled) {
            new MenuItem(mRow, 2);
            this.miEditUndo = new MenuItem(mRow, 0);
            this.miEditRedo = new MenuItem(mRow, 0);
            this.setUndoMenu();
        }
        if (this.readonly) {
            miRowInsBef.setEnabled(false);
            miRowInsAft.setEnabled(false);
            miRowUp.setEnabled(false);
            miRowDown.setEnabled(false);
            miClear.setEnabled(false);
            miCopyToAll.setEnabled(false);
            miPasteAll.setEnabled(false);
            miDelAll.setEnabled(false);
            miCutAll.setEnabled(false);
            miKeep.setEnabled(false);
        }
        SelectionAdapter lsRowInsBef = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.insertRowBefore();
            }
        };
        SelectionAdapter lsRowInsAft = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.insertRowAfter();
            }
        };
        SelectionAdapter lsCol1 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.optWidth(true);
            }
        };
        SelectionAdapter lsCol2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.optWidth(false);
            }
        };
        SelectionAdapter lsRowUp = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.moveRowsUp();
            }
        };
        SelectionAdapter lsRowDown = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.moveRowsDown();
            }
        };
        SelectionAdapter lsClear = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.clearAll(true);
            }
        };
        SelectionAdapter lsClipAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.clipSelected();
            }
        };
        SelectionAdapter lsCopyToAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.copyToAll();
            }
        };
        SelectionAdapter lsSelAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.selectAll();
            }
        };
        SelectionAdapter lsUnselAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.unselectAll();
            }
        };
        SelectionAdapter lsPasteAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.pasteSelected();
            }
        };
        SelectionAdapter lsCutAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.cutSelected();
            }
        };
        SelectionAdapter lsDelAll = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.delSelected();
            }
        };
        SelectionAdapter lsKeep = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.keepSelected();
            }
        };
        SelectionAdapter lsFilter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableView.this.setFilter();
            }
        };
        if (undoEnabled) {
            SelectionAdapter lsEditUndo = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableView.this.undoAction();
                }
            };
            this.miEditUndo.addSelectionListener((SelectionListener)lsEditUndo);
            SelectionAdapter lsEditRedo = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableView.this.redoAction();
                }
            };
            this.miEditRedo.addSelectionListener((SelectionListener)lsEditRedo);
        }
        miRowInsBef.addSelectionListener((SelectionListener)lsRowInsBef);
        miRowInsAft.addSelectionListener((SelectionListener)lsRowInsAft);
        miCol1.addSelectionListener((SelectionListener)lsCol1);
        miCol2.addSelectionListener((SelectionListener)lsCol2);
        miRowUp.addSelectionListener((SelectionListener)lsRowUp);
        miRowDown.addSelectionListener((SelectionListener)lsRowDown);
        miClear.addSelectionListener((SelectionListener)lsClear);
        miClipAll.addSelectionListener((SelectionListener)lsClipAll);
        miCopyToAll.addSelectionListener((SelectionListener)lsCopyToAll);
        miSelAll.addSelectionListener((SelectionListener)lsSelAll);
        miUnselAll.addSelectionListener((SelectionListener)lsUnselAll);
        miPasteAll.addSelectionListener((SelectionListener)lsPasteAll);
        miCutAll.addSelectionListener((SelectionListener)lsCutAll);
        miDelAll.addSelectionListener((SelectionListener)lsDelAll);
        miKeep.addSelectionListener((SelectionListener)lsKeep);
        miFilter.addSelectionListener((SelectionListener)lsFilter);
        this.table.setMenu(mRow);
    }

    protected void addToolbar() {
        this.toolbarWidgets = new GuiToolbarWidgets();
        this.toolbarWidgets.registerGuiPluginObject((Object)this);
        if (this.toolbarEnabled && this.props.isShowTableViewToolbar()) {
            this.toolbar = new ToolBar((Composite)this, 16704);
            FormData fdToolBar = new FormData();
            fdToolBar.left = new FormAttachment(0, 0);
            fdToolBar.top = new FormAttachment(0, 0);
            fdToolBar.right = new FormAttachment(100, 0);
            this.toolbar.setLayoutData((Object)fdToolBar);
            PropsUi.setLook((Widget)this.toolbar, 5);
            this.toolbarWidgets.createToolbarWidgets((Composite)this.toolbar, ID_TOOLBAR);
            this.toolbar.pack();
        }
    }

    private void comboKeyPressed(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 9) {
            if (this.activeTableItem == null) {
                return;
            }
            this.applyComboChange(this.activeTableItem, this.activeTableRow, this.activeTableColumn);
            String[] afterEdit = this.getItemText(this.activeTableItem);
            this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{this.activeTableRow});
            int maxCols = this.table.getColumnCount();
            int maxRows = this.table.getItemCount();
            boolean sel = false;
            if (e.keyCode == 9 && (e.stateMask & 0x20000) == 0) {
                ++this.activeTableColumn;
                sel = true;
            }
            if (e.keyCode == 9 && (e.stateMask & 0x20000) != 0) {
                --this.activeTableColumn;
                sel = true;
            }
            if (this.activeTableColumn < 1) {
                this.activeTableColumn = maxCols - 1;
                if (this.activeTableRow > 0) {
                    --this.activeTableRow;
                }
            }
            if (this.activeTableColumn >= maxCols) {
                this.activeTableColumn = 1;
                ++this.activeTableRow;
            }
            if (this.activeTableRow >= maxRows) {
                TableItem item = new TableItem(this.table, 0, this.activeTableRow);
                item.setText(1, "");
                this.setRowNums();
            }
            if (sel) {
                this.edit(this.activeTableRow, this.activeTableColumn);
            }
            this.table.setFocus();
        }
        if (e.keyCode == 27) {
            ColumnInfo columnInfo;
            if (this.activeTableItem != null) {
                this.activeTableItem.setText(this.activeTableColumn, this.beforeEdit[this.activeTableColumn - 1]);
            }
            if ((columnInfo = this.columns[this.activeTableColumn - 1]).isUsingVariables()) {
                this.comboVar.setVisible(false);
            } else {
                this.combo.setVisible(false);
            }
            this.table.setFocus();
            e.doit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyDisposeControl(Control combo) {
        if (combo == null) {
            return;
        }
        Control control = combo;
        synchronized (control) {
            if (combo.isDisposed()) {
                return;
            }
            combo.dispose();
        }
    }

    protected String getTextWidgetValue(int colNr) {
        boolean b = this.columns[colNr - 1].isUsingVariables();
        if (b) {
            return ((TextVar)this.text).getText();
        }
        return ((Text)this.text).getText();
    }

    protected int getTextWidgetCaretPosition(int colNr) {
        if (colNr >= 0) {
            boolean b = this.columns[colNr - 1].isUsingVariables();
            if (b) {
                return ((TextVar)this.text).getTextWidget().getCaretPosition();
            }
            return ((Text)this.text).getCaretPosition();
        }
        return -1;
    }

    public void sortTable(int colNr) {
        if (!this.sortable) {
            return;
        }
        if (this.sortField == colNr) {
            this.sortingDescending = !this.sortingDescending;
        } else {
            this.sortField = colNr;
            this.sortingDescending = false;
        }
        this.sortTable(this.sortField, this.sortingDescending);
    }

    public void setSelection(int[] selectedItems) {
        this.table.select(selectedItems);
    }

    public void sortTable(int sortField, boolean sortingDescending) {
        boolean shouldRefresh = false;
        if (this.sortFieldLast == -1 && this.sortingDescendingLast == null) {
            shouldRefresh = true;
            this.sortFieldLast = this.sortField;
            this.sortingDescendingLast = this.sortingDescending;
            this.sortField = sortField;
            this.sortingDescending = sortingDescending;
        }
        if (this.sortFieldLast != this.sortField) {
            this.sortFieldLast = this.sortField;
            this.sortField = sortField;
            shouldRefresh = true;
        }
        if (this.sortingDescendingLast != this.sortingDescending) {
            this.sortingDescendingLast = this.sortingDescending;
            this.sortingDescending = sortingDescending;
            shouldRefresh = true;
        }
        if (!shouldRefresh && this.table.getItemCount() == this.lastRowCount) {
            return;
        }
        this.removeEmptyRows();
        try {
            Object[] r;
            int i;
            TableItem[] items = this.table.getItems();
            ArrayList<Object[]> v = new ArrayList<Object[]>();
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString("colorname"));
            rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("color"));
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                ColumnInfo colInfo = j > 0 ? this.columns[j - 1] : this.numberColumn;
                IValueMeta valueMeta = colInfo.getValueMeta();
                if (j == sortField) {
                    valueMeta.setSortedDescending(sortingDescending);
                }
                rowMeta.addValueMeta(valueMeta);
            }
            IRowMeta sourceRowMeta = rowMeta.cloneToType(2);
            IRowMeta conversionRowMeta = rowMeta.clone();
            for (i = 0; i < sourceRowMeta.size(); ++i) {
                IValueMeta sourceValueMeta = sourceRowMeta.getValueMeta(i);
                sourceValueMeta.setStorageType(0);
                IValueMeta conversionMetaData = conversionRowMeta.getValueMeta(i);
                conversionMetaData.setStorageType(0);
                sourceRowMeta.getValueMeta(i).setConversionMetadata(conversionMetaData);
            }
            for (i = 0; i < items.length; ++i) {
                TableItem item = items[i];
                r = new Object[this.table.getColumnCount() + 2];
                Color bg = item.getBackground();
                if (!bg.equals((Object)this.defaultBackgroundColor)) {
                    String colorName = "bg " + bg.toString();
                    r[0] = colorName;
                    r[1] = (long)((bg.getRed() << 16) + (bg.getGreen() << 8) + bg.getBlue());
                    this.usedColors.put(colorName, bg);
                }
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    String data = item.getText(j);
                    if (GuiResource.getInstance().getColorBlue().equals((Object)item.getForeground(j))) {
                        data = null;
                    }
                    IValueMeta sourceValueMeta = sourceRowMeta.getValueMeta(j + 2);
                    try {
                        r[j + 2] = sourceValueMeta.convertDataUsingConversionMetaData((Object)data);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.isShowingConversionErrorsInline()) {
                            r[j + 2] = Const.getStackTracker((Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                }
                v.add(r);
            }
            int[] sortIndex = new int[]{sortField + 2};
            Collections.sort(v, (r1, r2) -> {
                try {
                    return conversionRowMeta.compare(r1, r2, sortIndex);
                }
                catch (HopValueException e) {
                    throw new RuntimeException("Error comparing rows", e);
                }
            });
            this.table.removeAll();
            for (int i2 = 0; i2 < v.size(); ++i2) {
                Color bg;
                r = (Object[])v.get(i2);
                TableItem item = new TableItem(this.table, 0);
                String colorName = (String)r[0];
                Long colorValue = (Long)r[1];
                if (colorValue != null && (bg = this.usedColors.get(colorName)) != null) {
                    item.setBackground(bg);
                }
                for (int j = 2; j < r.length; ++j) {
                    String string = conversionRowMeta.getString(r, j);
                    if (this.showingBlueNullValues && string == null) {
                        string = "<null>";
                        item.setForeground(j - 2, this.nullTextColor);
                    } else {
                        item.setForeground(j - 2, GuiResource.getInstance().getColorBlack());
                    }
                    if (string == null) continue;
                    item.setText(j - 2, string);
                }
            }
            this.table.setSortColumn(this.table.getColumn(this.sortField));
            this.table.setSortDirection(sortingDescending ? 1024 : 128);
            this.lastRowCount = this.table.getItemCount();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"TableView.ErrorDialog.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableView.ErrorDialog.description", (String[])new String[0]), e);
        }
    }

    private void selectRows(int from, int to) {
        this.table.deselectAll();
        if (from == to) {
            this.table.select(from);
        } else if (from > to) {
            this.table.select(to, from);
        } else {
            this.table.select(from, to);
        }
    }

    private void applyTextChange(TableItem row, int rowNr, int colNr) {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        String textData = this.getTextWidgetValue(colNr);
        row.setText(colNr, textData);
        this.text.dispose();
        this.table.setFocus();
        this.tableViewModifyListener.cellFocusLost(rowNr);
        String[] afterEdit = this.getItemText(row);
        this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
        this.selectionStart = -1;
        this.fireContentChangedListener(rowNr, colNr, textData);
    }

    private void fireContentChangedListener(int rowNr, int colNr, String textData) {
        if (this.lsContent != null) {
            Event event = new Event();
            event.data = textData;
            event.widget = this.table;
            event.x = rowNr;
            event.y = colNr;
            this.lsContent.modifyText(new ModifyEvent(event));
        }
    }

    private void applyComboChange(TableItem row, int rowNr, int colNr) {
        String textData;
        boolean usingVariables = this.columns[colNr - 1].isUsingVariables();
        if (usingVariables) {
            if (this.comboVar == null) {
                return;
            }
            textData = this.comboVar.getText();
        } else {
            if (this.combo == null) {
                return;
            }
            textData = this.combo.getText();
        }
        row.setText(colNr, textData);
        if (usingVariables) {
            this.comboVar.setVisible(false);
        } else {
            this.combo.setVisible(false);
        }
        String[] afterEdit = this.getItemText(row);
        this.checkChanged(new String[][]{this.beforeEdit}, new String[][]{afterEdit}, new int[]{rowNr});
        this.selectionStart = -1;
        this.fireContentChangedListener(rowNr, colNr, textData);
    }

    public void addModifyListener(ModifyListener ls) {
        this.lsMod = ls;
    }

    public void setColumnInfo(int idx, ColumnInfo col) {
        this.columns[idx] = col;
    }

    public void setColumnText(int idx, String text) {
        TableColumn col = this.table.getColumn(idx);
        col.setText(text);
    }

    public void setColumnToolTip(int idx, String text) {
        this.columns[idx].setToolTip(text);
    }

    private void editSelected() {
        if (this.activeTableItem == null) {
            return;
        }
        if (this.activeTableColumn > 0) {
            this.edit(this.activeTableRow, this.activeTableColumn);
        } else {
            this.selectRows(this.activeTableRow, this.activeTableRow);
        }
    }

    private void checkChanged(String[][] before, String[][] after, int[] index) {
        if (this.fieldChanged) {
            ChangeAction ta = new ChangeAction();
            ta.setChanged((Object[])before, (Object[])after, index);
            this.addUndo(ta);
        }
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10000-insert-row-before", image="ui/images/add-item-above.svg", toolTip="i18n::TableView.ToolBarWidget.InsertRowBefore.ToolTip")
    public void insertRowBefore() {
        if (this.readonly) {
            return;
        }
        TableItem row = this.activeTableItem;
        if (row == null) {
            return;
        }
        int rowNr = this.table.indexOf(row);
        this.insertRow(rowNr);
    }

    private void setModified() {
        if (this.lsMod != null) {
            Event e = new Event();
            e.widget = this;
            this.lsMod.modifyText(new ModifyEvent(e));
        }
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10010-insert-row-after", image="ui/images/add-item-below.svg", toolTip="i18n::TableView.ToolBarWidget.InsertRowAfter.ToolTip")
    public void insertRowAfter() {
        if (this.readonly) {
            return;
        }
        TableItem tableItem = this.activeTableItem;
        if (tableItem == null) {
            return;
        }
        int rowNr = this.table.indexOf(tableItem);
        this.insertRow(rowNr + 1);
    }

    private void insertRow(int rowNr) {
        TableItem tableItem = new TableItem(this.table, 0, rowNr);
        tableItem.setText(1, "");
        ChangeAction ta = new ChangeAction();
        String[] str = this.getItemText(tableItem);
        ta.setNew((Object[])new String[][]{str}, new int[]{rowNr});
        this.addUndo(ta);
        this.setRowNums();
        this.edit(rowNr, 1);
        this.tableViewModifyListener.insertRow(rowNr);
        this.setModified();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10200-clear-all", image="ui/images/delete.svg", toolTip="i18n::TableView.ToolBarWidget.ClearAllRows.ToolTip", separator=true)
    public void clearAllRows() {
        this.clearAll(true);
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clearAll(boolean ask) {
        int id = 64;
        if (ask) {
            MessageBox mb = new MessageBox(this.parent.getShell(), 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableView.MessageBox.ClearTable.message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableView.MessageBox.ClearTable.title", (String[])new String[0]));
            id = mb.open();
        }
        if (id == 64) {
            this.table.removeAll();
            new TableItem(this.table, 0);
            if (!this.readonly) {
                this.parent.getDisplay().asyncExec(() -> this.edit(0, 1));
            }
            this.setModified();
        }
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10100-move-rows-up", image="ui/images/arrow-up.svg", toolTip="i18n::TableView.ToolBarWidget.MoveRowsUp.ToolTip", separator=true)
    public void moveRowsUp() {
        this.moveRows(-1);
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10110-move-rows-down", image="ui/images/arrow-down.svg", toolTip="i18n::TableView.ToolBarWidget.MoveRowsDown.ToolTip")
    public void moveRowsDown() {
        this.moveRows(1);
    }

    private void moveRows(int offset) {
        if (offset != 1 && offset != -1) {
            return;
        }
        int[] selectionIndicies = this.table.getSelectionIndices();
        int selectedIndex = this.table.getSelectionIndex();
        Arrays.sort(selectionIndicies);
        if (offset == 1) {
            if (selectionIndicies[selectionIndicies.length - 1] >= this.table.getItemCount() - 1) {
                return;
            }
            selectionIndicies = this.moveRowsDown(selectionIndicies);
        } else {
            if (selectionIndicies[0] == 0) {
                return;
            }
            selectionIndicies = this.moveRowsUp(selectionIndicies);
        }
        this.activeTableRow = selectedIndex + offset;
        this.table.setSelection(this.activeTableRow);
        this.table.setSelection(selectionIndicies);
        this.activeTableItem = this.table.getItem(this.activeTableRow);
        this.setModified();
    }

    private int[] moveRowsDown(int[] selectionIndicies) {
        for (int i = selectionIndicies.length - 1; i >= 0; --i) {
            int row = selectionIndicies[i];
            int newRow = row + 1;
            this.moveRow(row, newRow);
            ChangeAction ta = new ChangeAction();
            ta.setItemMove(new int[]{row}, new int[]{newRow});
            this.addUndo(ta);
            selectionIndicies[i] = newRow;
        }
        return selectionIndicies;
    }

    private int[] moveRowsUp(int[] selectionIndicies) {
        for (int i = 0; i < selectionIndicies.length; ++i) {
            int row = selectionIndicies[i];
            int newRow = row - 1;
            this.moveRow(row, newRow);
            ChangeAction ta = new ChangeAction();
            ta.setItemMove(new int[]{row}, new int[]{newRow});
            this.addUndo(ta);
            selectionIndicies[i] = newRow;
        }
        return selectionIndicies;
    }

    private void moveRow(int from, int to) {
        TableItem rowfrom = this.table.getItem(from);
        TableItem rowto = this.table.getItem(to);
        String[] strfrom = this.getItemText(rowfrom);
        String[] strto = this.getItemText(rowto);
        for (int i = 0; i < strfrom.length; ++i) {
            rowfrom.setText(i + 1, strto[i]);
            rowto.setText(i + 1, strfrom[i]);
        }
        this.tableViewModifyListener.moveRow(from, to);
        this.setModified();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10500-copy-to-all-rows", image="ui/images/duplicate.svg", toolTip="i18n::TableView.ToolBarWidget.CopyToAllRows.ToolTip")
    public void copyToAll() {
        TableItem row = this.activeTableItem;
        if (row == null || row.isDisposed()) {
            return;
        }
        int colNr = this.activeTableColumn;
        if (colNr == 0) {
            return;
        }
        String str = row.getText(colNr);
        int size = this.table.getItemCount();
        String[][] before = new String[size][];
        String[][] after = new String[size][];
        int[] index = new int[size];
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            index[i] = i;
            before[i] = this.getItemText(item);
            item.setText(colNr, str);
            after[i] = this.getItemText(item);
        }
        ChangeAction ta = new ChangeAction();
        ta.setChanged((Object[])before, (Object[])after, index);
        this.addUndo(ta);
        this.setModified();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10300-select-all-rows", image="ui/images/select-all.svg", toolTip="i18n::TableView.ToolBarWidget.SelectAll.ToolTip", separator=true)
    public void selectAll() {
        this.table.selectAll();
        this.enableToolbarButtons();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10310-clear-selection", image="ui/images/unselect-all.svg", toolTip="i18n::TableView.ToolBarWidget.ClearSelection.ToolTip")
    public void unselectAll() {
        this.table.deselectAll();
        this.enableToolbarButtons();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10400-copy-selected", image="ui/images/copy.svg", toolTip="i18n::TableView.ToolBarWidget.CopySelected.ToolTip", separator=true)
    public void clipSelected() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.clipboard = new Clipboard(this.getDisplay());
        TextTransfer tran = TextTransfer.getInstance();
        String clip = this.getSelectedText();
        if (clip == null) {
            return;
        }
        this.clipboard.setContents((Object[])new String[]{clip}, new Transfer[]{tran});
    }

    private String getSelectedText() {
        Object selection = "";
        for (int c = 1; c < this.table.getColumnCount(); ++c) {
            TableColumn tc = this.table.getColumn(c);
            if (c > 1) {
                selection = (String)selection + CLIPBOARD_DELIMITER;
            }
            selection = (String)selection + tc.getText();
        }
        selection = (String)selection + Const.CR;
        Object[] items = this.table.getSelection();
        if (items.length == 0) {
            return null;
        }
        if (EnvironmentUtils.getInstance().isWeb()) {
            ArrayUtils.reverse((Object[])items);
        }
        for (int r = 0; r < items.length; ++r) {
            Object ti = items[r];
            for (int c = 1; c < this.table.getColumnCount(); ++c) {
                Color textColor;
                String value;
                if (c > 1) {
                    selection = (String)selection + CLIPBOARD_DELIMITER;
                }
                if (!StringUtils.isNotEmpty((String)(value = ti.getText(c))) || this.nullTextColor.equals((Object)(textColor = ti.getForeground(c))) && "<null>".equals(value)) continue;
                selection = (String)selection + ti.getText(c);
            }
            selection = (String)selection + Const.CR;
        }
        return selection;
    }

    private int getCurrentRownr() {
        if (this.table.getItemCount() <= 1) {
            return 0;
        }
        TableItem row = this.activeTableItem;
        if (row == null) {
            return 0;
        }
        int rowNr = this.table.indexOf(row);
        if (rowNr < 0) {
            rowNr = 0;
        }
        return rowNr;
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10410-paste-to-table", image="ui/images/paste.svg", toolTip="i18n::TableView.ToolBarWidget.PasteSelected.ToolTip")
    public void pasteSelected() {
        int rowNr = this.getCurrentRownr();
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.clipboard = new Clipboard(this.getDisplay());
        TextTransfer tran = TextTransfer.getInstance();
        String text = (String)this.clipboard.getContents((Transfer)tran);
        if (text != null) {
            String[] lines = text.split(Const.CR);
            if (lines.length > 1) {
                String[][] grid = new String[lines.length - 1][];
                int[] idx = new int[lines.length - 1];
                for (int i = 1; i < lines.length; ++i) {
                    grid[i - 1] = lines[i].split(CLIPBOARD_DELIMITER);
                    idx[i - 1] = rowNr + i;
                    this.addItem(idx[i - 1], grid[i - 1]);
                }
                ChangeAction ta = new ChangeAction();
                ta.setNew((Object[])grid, idx);
                this.addUndo(ta);
            }
            if (rowNr == 0 && this.table.getItemCount() > rowNr + 1 && this.isEmpty(rowNr, -1)) {
                this.table.remove(rowNr);
            }
            this.setRowNums();
            this.unEdit();
            this.setModified();
        }
    }

    private void addItem(int pos, String[] str) {
        TableItem item = new TableItem(this.table, 0, pos);
        for (int i = 0; i < str.length; ++i) {
            item.setText(i + 1, str[i]);
        }
        this.setModified();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10420-cut-selected", image="ui/images/cut.svg", toolTip="i18n::TableView.ToolBarWidget.CutSelected.ToolTip")
    public void cutSelected() {
        this.clipSelected();
        this.delSelected();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10430-delete-selected", image="ui/images/delete.svg", toolTip="i18n::TableView.ToolBarWidget.DeleteSelected.ToolTip")
    public void delSelected() {
        if (this.nrNonEmpty() == 0) {
            return;
        }
        int[] items = this.table.getSelectionIndices();
        if (items.length == 0) {
            return;
        }
        String[][] before = new String[items.length][];
        for (int i = 0; i < items.length; ++i) {
            TableItem ti = this.table.getItem(items[i]);
            before[i] = this.getItemText(ti);
        }
        ChangeAction ta = new ChangeAction();
        ta.setDelete((Object[])before, items);
        this.addUndo(ta);
        TableItem row = this.activeTableItem;
        if (row == null) {
            return;
        }
        int rowbefore = this.table.indexOf(row);
        this.table.remove(items);
        if (this.table.getItemCount() == 0) {
            TableItem item = new TableItem(this.table, 0);
            String[] stritem = this.getItemText(item);
            ta = new ChangeAction();
            ta.setNew((Object[])new String[][]{stritem}, new int[]{0});
            this.addUndo(ta);
        }
        if (rowbefore >= this.table.getItemCount()) {
            rowbefore = this.table.getItemCount() - 1;
        }
        if (rowbefore < this.table.getItemCount() && this.table.getItemCount() > 0) {
            this.setPosition(rowbefore, 1);
            this.table.setSelection(rowbefore);
            this.activeTableRow = rowbefore;
        }
        this.tableViewModifyListener.delete(items);
        this.setRowNums();
        this.setModified();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10440-keep-selected", image="ui/images/minimize-panel.svg", toolTip="i18n::TableView.ToolBarWidget.KeepSelected.ToolTip")
    public void keepSelected() {
        int[] selectionIndices = this.table.getSelectionIndices();
        int size = this.table.getItemCount();
        int[] itemsToDelete = new int[size - selectionIndices.length];
        if (itemsToDelete.length == 0) {
            return;
        }
        int nr = 0;
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            boolean selected = false;
            for (int j = 0; j < selectionIndices.length && !selected; ++j) {
                if (selectionIndices[j] != i) continue;
                selected = true;
            }
            if (selected) continue;
            itemsToDelete[nr] = i;
            ++nr;
        }
        String[][] before = new String[itemsToDelete.length][];
        for (int i = 0; i < itemsToDelete.length; ++i) {
            TableItem ti = this.table.getItem(itemsToDelete[i]);
            before[i] = this.getItemText(ti);
        }
        ChangeAction ta = new ChangeAction();
        ta.setDelete((Object[])before, itemsToDelete);
        this.addUndo(ta);
        this.table.remove(itemsToDelete);
        if (this.table.getItemCount() == 0) {
            TableItem item = new TableItem(this.table, 0);
            String[] strItem = this.getItemText(item);
            ta = new ChangeAction();
            ta.setNew((Object[])new String[][]{strItem}, new int[]{0});
            this.addUndo(ta);
        }
        this.setRowNums();
        this.activeTableItem = this.table.getItem(0);
        this.activeTableRow = 0;
        this.setModified();
    }

    private void setPosition(int rowNr, int colNr) {
        this.activeTableColumn = colNr;
        this.activeTableRow = rowNr;
        if (rowNr >= 0) {
            this.activeTableItem = this.table.getItem(rowNr);
        }
    }

    public void edit(int rowNr, int colNr) {
        this.setPosition(rowNr, colNr);
        this.edit(rowNr, colNr, true, '\u0000');
    }

    private void edit(int rowNr, int colNr, boolean selectText, char extra) {
        this.selectionStart = -1;
        TableItem row = this.table.getItem(rowNr);
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            try {
                oldEditor.dispose();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        this.activeTableItem = this.table.getItem(this.activeTableRow);
        this.table.showItem(row);
        this.table.setSelection(new TableItem[]{row});
        if (this.columns.length == 0) {
            return;
        }
        switch (this.columns[colNr - 1].getType()) {
            case 1: {
                this.isTextButton = false;
                this.editText(row, rowNr, colNr, selectText, extra, this.columns[colNr - 1]);
                break;
            }
            case 2: 
            case 5: {
                this.editCombo(row, rowNr, colNr);
                break;
            }
            case 3: {
                this.editButton(row, rowNr, colNr);
                break;
            }
            case 6: {
                this.isTextButton = this.columns[colNr - 1].shouldRenderTextVarButton();
                this.editText(row, rowNr, colNr, selectText, extra, this.columns[colNr - 1]);
                break;
            }
        }
        this.enableToolbarButtons();
    }

    private String[] getItemText(TableItem row) {
        if (row.isDisposed()) {
            return null;
        }
        String[] retval = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = row.getText(i + 1);
        }
        return retval;
    }

    private void editText(TableItem row, int rowNr, int colNr, boolean selectText, char extra, ColumnInfo columnInfo) {
        boolean disabled;
        this.beforeEdit = this.getItemText(row);
        this.fieldChanged = false;
        ColumnInfo colinfo = this.columns[colNr - 1];
        if (colinfo.isReadOnly()) {
            return;
        }
        if (colinfo.getDisabledListener() != null && (disabled = colinfo.getDisabledListener().isFieldDisabled(rowNr))) {
            return;
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
        if (colinfo.getSelectionAdapter() != null) {
            Event e = new Event();
            e.widget = this;
            e.x = colNr;
            e.y = rowNr;
            this.columns[colNr - 1].getSelectionAdapter().widgetSelected(new SelectionEvent(e));
            return;
        }
        String content = row.getText(colNr) + (String)(extra != '\u0000' ? "" + extra : "");
        String tooltip = this.columns[colNr - 1].getToolTip();
        boolean useVariables = this.columns[colNr - 1].isUsingVariables();
        boolean passwordField = this.columns[colNr - 1].isPasswordField();
        ModifyListener modifyListener = me -> this.setColumnWidthBasedOnTextField(colNr, useVariables);
        if (useVariables) {
            IGetCaretPosition getCaretPositionInterface = () -> ((TextVar)this.text).getTextWidget().getCaretPosition();
            IInsertText insertTextInterface = (string, position) -> {
                StringBuilder buffer = new StringBuilder(this.table.getItem(rowNr).getText(colNr));
                buffer.insert(position, string);
                this.table.getItem(rowNr).setText(colNr, buffer.toString());
                int newPosition = position + string.length();
                this.edit(rowNr, colNr);
                ((TextVar)this.text).setSelection(newPosition);
                if (!EnvironmentUtils.getInstance().isWeb()) {
                    ((TextVar)this.text).showSelection();
                }
                this.setColumnWidthBasedOnTextField(colNr, useVariables);
            };
            TextVar textWidget = passwordField ? new PasswordTextVar(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface) : (this.isTextButton ? new TextVarButton(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface, columnInfo.getTextVarButtonSelectionListener()) : new TextVar(this.variables, (Composite)this.table, 0, getCaretPositionInterface, insertTextInterface));
            this.text = textWidget;
            textWidget.setText(content);
            if (this.lsMod != null) {
                textWidget.addModifyListener(this.lsMod);
            }
            textWidget.addModifyListener(this.lsUndo);
            textWidget.setSelection(content.length());
            textWidget.addKeyListener(this.lsKeyText);
            textWidget.addModifyListener(modifyListener);
            if (selectText) {
                textWidget.selectAll();
            }
            if (tooltip != null) {
                textWidget.setToolTipText(tooltip);
            } else {
                textWidget.setToolTipText("");
            }
            textWidget.addTraverseListener(this.lsTraverse);
            textWidget.setData(CANCEL_KEYS, new String[]{"TAB", "SHIFT+TAB"});
            textWidget.addFocusListener(this.lsFocusText);
            if (OsHelper.isMac()) {
                textWidget.addListener(2, this.lsKeyUp);
            }
        } else {
            Text textWidget = new Text((Composite)this.table, 0);
            this.text = textWidget;
            textWidget.setText(content);
            if (this.lsMod != null) {
                textWidget.addModifyListener(this.lsMod);
            }
            textWidget.addModifyListener(this.lsUndo);
            textWidget.setSelection(content.length());
            textWidget.addKeyListener(this.lsKeyText);
            textWidget.addModifyListener(modifyListener);
            if (selectText) {
                textWidget.selectAll();
            }
            if (tooltip != null) {
                textWidget.setToolTipText(tooltip);
            } else {
                textWidget.setToolTipText("");
            }
            textWidget.addTraverseListener(this.lsTraverse);
            textWidget.setData(CANCEL_KEYS, (Object)new String[]{"TAB", "SHIFT+TAB"});
            textWidget.addFocusListener(this.lsFocusText);
            if (OsHelper.isMac()) {
                textWidget.addListener(2, this.lsKeyUp);
            }
        }
        PropsUi.setLook((Widget)this.text);
        this.fixWebLook(this.text);
        int width = this.tableColumn[colNr].getWidth();
        int height = 30;
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.setEditor(this.text, row, colNr);
        this.text.setFocus();
        this.text.setSize(width, height);
        this.editor.layout();
    }

    private void fixWebLook(Control control) {
        if (EnvironmentUtils.getInstance().isWeb()) {
            String hopWebTheme = EnvironmentUtils.getInstance().getHopWebTheme();
            if ("dark".equalsIgnoreCase(hopWebTheme)) {
                control.setForeground(GuiResource.getInstance().getColorWhite());
                control.setBackground(GuiResource.getInstance().getColorBlack());
            } else {
                control.setForeground(GuiResource.getInstance().getColorBlack());
                control.setBackground(GuiResource.getInstance().getColorWhite());
            }
        }
    }

    private void setColumnWidthBasedOnTextField(int colNr, boolean useVariables) {
        if (!this.columns[colNr - 1].isAutoResize()) {
            return;
        }
        String str = this.getTextWidgetValue(colNr);
        int strmax = TextSizeUtilFacade.textExtent((String)str).x + 20;
        int colmax = this.tableColumn[colNr].getWidth();
        if (strmax > colmax) {
            if (!EnvironmentUtils.getInstance().isWeb() && (Const.isOSX() || Const.isLinux())) {
                strmax = (int)((double)strmax * 1.4);
            }
            this.tableColumn[colNr].setWidth(strmax + 30);
            if (useVariables) {
                TextVar widget = (TextVar)this.text;
                int idx = widget.getTextWidget().getCaretPosition();
                widget.selectAll();
                widget.showSelection();
                widget.setSelection(0);
                widget.showSelection();
                widget.setSelection(idx);
            } else {
                Text widget = (Text)this.text;
                int idx = widget.getCaretPosition();
                widget.selectAll();
                if (!EnvironmentUtils.getInstance().isWeb()) {
                    widget.showSelection();
                }
                widget.setSelection(0);
                if (!EnvironmentUtils.getInstance().isWeb()) {
                    widget.showSelection();
                }
                widget.setSelection(idx);
            }
        }
    }

    private String[] getComboValues(TableItem row, ColumnInfo colinfo) {
        if (colinfo.getType() == 5) {
            int type = ValueMetaFactory.getIdForValueMeta((String)row.getText(colinfo.getFieldTypeColumn()));
            switch (type) {
                case 3: {
                    return Const.getDateFormats();
                }
                case 1: 
                case 5: 
                case 6: {
                    return Const.getNumberFormats();
                }
                case 2: {
                    return Const.getConversionFormats();
                }
            }
            return new String[0];
        }
        return colinfo.getComboValues();
    }

    private void editCombo(TableItem item, int rowNr, int colNr) {
        boolean useVariables;
        boolean disabled;
        this.beforeEdit = this.getItemText(item);
        this.fieldChanged = false;
        ColumnInfo columnInfo = this.columns[colNr - 1];
        if (columnInfo.isReadOnly() && columnInfo.getSelectionAdapter() != null) {
            return;
        }
        if (columnInfo.getDisabledListener() != null && (disabled = columnInfo.getDisabledListener().isFieldDisabled(rowNr))) {
            return;
        }
        String[] opt = this.getComboValues(item, columnInfo);
        if (columnInfo.getComboValuesSelectionListener() != null) {
            opt = columnInfo.getComboValuesSelectionListener().getComboValues(item, rowNr, colNr);
        }
        if (useVariables = columnInfo.isUsingVariables()) {
            IGetCaretPosition getCaretPositionInterface = () -> 0;
            IInsertText insertTextInterface = (string, position) -> {
                StringBuilder buffer = new StringBuilder(this.table.getItem(rowNr).getText(colNr));
                buffer.insert(position, string);
                this.table.getItem(rowNr).setText(colNr, buffer.toString());
                this.edit(rowNr, colNr);
                this.setModified();
            };
            this.safelyDisposeControl((Control)this.comboVar);
            this.comboVar = new ComboVar(this.variables, (Composite)this.table, 16388, getCaretPositionInterface, insertTextInterface);
            if (this.lsFocusInTabItem != null) {
                this.comboVar.getCComboWidget().addListener(15, this.lsFocusInTabItem);
            } else {
                this.comboVar.setItems(opt);
            }
            PropsUi.setLook((Widget)this.comboVar);
            this.fixWebLook((Control)this.comboVar.getCComboWidget());
            this.comboVar.addTraverseListener(this.lsTraverse);
            this.comboVar.setData(CANCEL_KEYS, new String[]{"TAB", "SHIFT+TAB"});
            this.comboVar.addModifyListener(this.lsModCombo);
            this.comboVar.addFocusListener(this.lsFocusCombo);
            this.comboVar.setText(item.getText(colNr));
            this.comboVar.getCComboWidget().setVisibleItemCount(Math.min(opt.length, 15));
            if (this.lsMod != null) {
                this.comboVar.addModifyListener(this.lsMod);
            }
            this.comboVar.addModifyListener(this.lsUndo);
            this.comboVar.setToolTipText(columnInfo.getToolTip() == null ? "" : columnInfo.getToolTip());
            this.comboVar.setVisible(true);
            this.comboVar.addKeyListener(this.lsKeyCombo);
            ((FormData)this.comboVar.getCComboWidget().getLayoutData()).bottom = new FormAttachment(100, 0);
            this.editor.horizontalAlignment = 16384;
            this.editor.layout();
            this.editor.setEditor((Control)this.comboVar, item, colNr);
            this.comboVar.setFocus();
            this.comboVar.layout();
        } else {
            this.safelyDisposeControl((Control)this.combo);
            String cellValue = item.getText(colNr);
            this.combo = new Combo((Composite)this.table, columnInfo.isReadOnly() ? 8 : 0);
            PropsUi.setLook((Widget)this.combo);
            this.fixWebLook((Control)this.combo);
            this.combo.addTraverseListener(this.lsTraverse);
            this.combo.setData(CANCEL_KEYS, (Object)new String[]{"TAB", "SHIFT+TAB"});
            this.combo.addModifyListener(this.lsModCombo);
            this.combo.addFocusListener(this.lsFocusCombo);
            this.combo.setItems(opt);
            this.combo.setVisibleItemCount(Math.min(opt.length, 15));
            this.combo.setText(cellValue);
            if (this.lsMod != null) {
                this.combo.addModifyListener(this.lsMod);
            }
            this.combo.addModifyListener(this.lsUndo);
            this.combo.setToolTipText(columnInfo.getToolTip() == null ? "" : columnInfo.getToolTip());
            this.combo.setVisible(true);
            this.combo.addKeyListener(this.lsKeyCombo);
            if (columnInfo.getSelectionAdapter() != null) {
                this.combo.addSelectionListener(this.columns[colNr - 1].getSelectionAdapter());
            }
            this.editor.horizontalAlignment = 16384;
            this.editor.layout();
            this.editor.setEditor((Control)this.combo, item, colNr);
            this.combo.setFocus();
            this.combo.layout();
        }
    }

    private void editButton(TableItem row, int rowNr, int colNr) {
        boolean disabled;
        this.beforeEdit = this.getItemText(row);
        this.fieldChanged = false;
        ColumnInfo columnInfo = this.columns[colNr - 1];
        if (columnInfo.isReadOnly()) {
            return;
        }
        if (columnInfo.getDisabledListener() != null && (disabled = columnInfo.getDisabledListener().isFieldDisabled(rowNr))) {
            return;
        }
        this.button = new Button((Composite)this.table, 8);
        PropsUi.setLook((Widget)this.button);
        String buttonText = this.columns[colNr - 1].getButtonText();
        if (buttonText != null) {
            this.button.setText(buttonText);
        }
        this.button.setImage(GuiResource.getInstance().getImage("ui/images/edit.svg"));
        SelectionListener selAdpt = columnInfo.getSelectionAdapter();
        if (selAdpt != null) {
            this.button.addSelectionListener(selAdpt);
        }
        this.buttonRowNr = rowNr;
        this.buttonColNr = colNr;
        this.buttonContent = row.getText(colNr);
        String tooltip = this.columns[colNr - 1].getToolTip();
        if (tooltip != null) {
            this.button.setToolTipText(tooltip);
        } else {
            this.button.setToolTipText("");
        }
        this.button.addTraverseListener(this.lsTraverse);
        this.button.setData(CANCEL_KEYS, (Object)new String[]{"TAB", "SHIFT+TAB"});
        this.button.addTraverseListener(arg0 -> this.closeActiveButton());
        this.editor.horizontalAlignment = 16384;
        this.editor.verticalAlignment = 128;
        this.editor.grabHorizontal = false;
        this.editor.grabVertical = false;
        Point size = this.button.computeSize(-1, -1);
        this.editor.minimumWidth = size.x;
        this.editor.minimumHeight = size.y - 2;
        this.editor.layout();
        this.editor.setEditor((Control)this.button);
        this.button.setFocus();
    }

    public void setRowNums() {
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            if (item == null) continue;
            String num = "" + (i + 1);
            if (item.getText(0).equals(num)) continue;
            item.setText(0, num);
        }
    }

    public void optWidth(boolean header) {
        this.optWidth(header, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void optWidth(boolean header, int nrLines) {
        extraForMargin = Const.isWindows() != false ? (int)(PropsUi.getNativeZoomFactor() * 8.0) : (int)(PropsUi.getNativeZoomFactor() * 5.0);
        for (c = 0; c < this.table.getColumnCount(); ++c) {
            block26: {
                block25: {
                    tc = this.table.getColumn(c);
                    max = 0;
                    if (header) {
                        max = TextSizeUtilFacade.textExtent((String)tc.getText()).x;
                        if (c == this.sortField && this.sortable) {
                            max += extraForMargin;
                        }
                    }
                    columnStrings = new HashSet<String>();
                    haveToGetTexts = false;
                    if (c <= 0) break block25;
                    column = this.columns[c - 1];
                    if (column == null) break block26;
                    switch (column.getType()) {
                        case 1: 
                        case 6: {
                            haveToGetTexts = true;
                            ** break;
                        }
                        case 2: 
                        case 5: {
                            haveToGetTexts = true;
                            if (column.getComboValues() == null) ** break;
                            for (String comboValue : this.columns[c - 1].getComboValues()) {
                                columnStrings.add(comboValue);
                            }
                            break block26;
                        }
                        case 3: {
                            columnStrings.add(column.getButtonText());
                            ** break;
                        }
                    }
lbl31:
                    // 4 sources

                    break block26;
                }
                haveToGetTexts = true;
            }
            if (haveToGetTexts) {
                for (r = 0; r < this.table.getItemCount() && (r < nrLines || nrLines <= 0); ++r) {
                    ti = this.table.getItem(r);
                    if (ti == null) continue;
                    columnStrings.add(ti.getText(c));
                }
            }
            r = columnStrings.iterator();
            while (r.hasNext()) {
                len = TextSizeUtilFacade.textExtent((String)((str = (String)r.next()) == null ? "" : str)).x;
                if (len <= max) continue;
                max = len;
            }
            try {
                max += extraForMargin;
                if (c > 0) {
                    max += extraForMargin;
                }
                if (Const.isWindows() || Const.isLinux()) {
                    max += extraForMargin;
                }
                if (c == 0) {
                    if (tc.getWidth() != max) {
                        tc.setWidth(max);
                    }
                } else {
                    desiredWidth = this.columns[c - 1].getWidth();
                    if (desiredWidth > 0) {
                        if (tc.getWidth() != desiredWidth) {
                            tc.setWidth(desiredWidth);
                        }
                    } else if (tc.getWidth() != max) {
                        tc.setWidth(max);
                    }
                }
                if (tc.getWidth() == max) continue;
                if (c > 0 && this.columns[c - 1].getWidth() > 0) {
                    tc.setWidth(this.columns[c - 1].getWidth());
                    continue;
                }
                tc.setWidth(max);
                continue;
            }
            catch (Exception e) {
                LogChannel.UI.logError("error in TableView", (Throwable)e);
            }
        }
        if (this.table.isListening(11)) {
            resizeEvent = new Event();
            resizeEvent.widget = this.table;
            resizeEvent.type = 11;
            resizeEvent.display = this.getDisplay();
            resizeEvent.setBounds(this.table.getBounds());
            this.table.notifyListeners(11, resizeEvent);
        }
        this.unEdit();
    }

    public void optimizeTableView() {
        this.removeEmptyRows();
        this.setRowNums();
        this.optWidth(true);
    }

    public void removeEmptyRows() {
        this.removeEmptyRows(-1);
    }

    private boolean isEmpty(int rowNr, int colNr) {
        boolean empty = false;
        TableItem item = this.table.getItem(rowNr);
        if (item != null) {
            if (colNr >= 0) {
                String str = item.getText(colNr);
                if (str == null || str.length() == 0) {
                    empty = true;
                }
            } else {
                empty = true;
                for (int j = 1; j < this.table.getColumnCount(); ++j) {
                    String str = item.getText(j);
                    if (str == null || str.length() <= 0) continue;
                    empty = false;
                }
            }
        }
        return empty;
    }

    public void removeEmptyRows(int column) {
        for (int i = this.table.getItemCount() - 1; i >= 0; --i) {
            if (!this.isEmpty(i, column)) continue;
            this.table.remove(i);
        }
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public List<Integer> getNonEmptyIndexes() {
        return this.nonEmptyIndexes;
    }

    public int nrNonEmpty() {
        this.nonEmptyIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            if (this.isEmpty(i, -1)) continue;
            this.nonEmptyIndexes.add(i);
        }
        return this.nonEmptyIndexes.size();
    }

    public TableItem getNonEmpty(int index) {
        int nonEmptyIndex = this.nonEmptyIndexes.get(index);
        return this.table.getItem(nonEmptyIndex);
    }

    public List<TableItem> getNonEmptyItems() {
        ArrayList<TableItem> list = new ArrayList<TableItem>();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            if (this.isEmpty(i, -1)) continue;
            list.add(this.table.getItem(i));
        }
        return list;
    }

    public int indexOfString(String str, int column) {
        int nrNonEmptyFields = this.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            String cmp = this.getNonEmpty(i).getText(column);
            if (!str.equalsIgnoreCase(cmp)) continue;
            return i;
        }
        return -1;
    }

    public ScrollBar getHorizontalBar() {
        return this.table.getHorizontalBar();
    }

    public ScrollBar getVerticalBar() {
        return this.table.getVerticalBar();
    }

    private void addUndo(ChangeAction ta) {
        while (this.undo.size() > this.undoPosition + 1 && !this.undo.isEmpty()) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        this.undo.add(ta);
        ++this.undoPosition;
        while (this.undo.size() > this.props.getMaxUndo()) {
            this.undo.remove(0);
            --this.undoPosition;
        }
        this.setUndoMenu();
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10600-undo", image="ui/images/undo.svg", toolTip="i18n::TableView.ToolBarWidget.UndoAction.ToolTip", separator=true)
    public void undoAction() {
        ChangeAction ta = this.previousUndo();
        if (ta == null) {
            return;
        }
        int rowNr = this.getCurrentRownr();
        this.setUndoMenu();
        switch (ta.getType()) {
            case NewTableRow: {
                int[] idx = ta.getCurrentIndex();
                this.table.remove(idx);
                for (int i = 0; i < idx.length; ++i) {
                    if (idx[i] >= rowNr) continue;
                    --rowNr;
                }
                if (this.table.getItemCount() == 0) {
                    this.undoAction();
                }
                this.setRowNums();
                break;
            }
            case DeleteTableRow: {
                int[] idx = ta.getCurrentIndex();
                String[][] str = (String[][])ta.getCurrent();
                for (int i = 0; i < idx.length; ++i) {
                    this.addItem(idx[i], str[i]);
                    if (idx[i] > rowNr) continue;
                    ++rowNr;
                }
                this.setRowNums();
                break;
            }
            case ChangeTableRow: {
                int[] idx = ta.getCurrentIndex();
                String[][] prev = (String[][])ta.getPrevious();
                for (int x = 0; x < idx.length; ++x) {
                    TableItem item = this.table.getItem(idx[x]);
                    for (int i = 0; i < prev[x].length; ++i) {
                        item.setText(i + 1, prev[x][i]);
                    }
                }
                break;
            }
            case PositionTableRow: {
                int[] curr = ta.getCurrentIndex();
                int[] prevIdx = ta.getPreviousIndex();
                for (int i = 0; i < curr.length; ++i) {
                    this.moveRow(prevIdx[i], curr[i]);
                }
                this.setRowNums();
                break;
            }
        }
        if (rowNr >= this.table.getItemCount()) {
            rowNr = this.table.getItemCount() - 1;
        }
        if (rowNr < 0) {
            rowNr = 0;
        }
        this.selectRows(rowNr, rowNr);
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10610-redo", image="ui/images/redo.svg", toolTip="i18n::TableView.ToolBarWidget.RedoAction.ToolTip")
    public void redoAction() {
        ChangeAction ta = this.nextUndo();
        if (ta == null) {
            return;
        }
        int rowNr = this.getCurrentRownr();
        this.setUndoMenu();
        switch (ta.getType()) {
            case NewTableRow: {
                int[] idx = ta.getCurrentIndex();
                String[][] str = (String[][])ta.getCurrent();
                for (int i = 0; i < idx.length; ++i) {
                    this.addItem(idx[i], str[i]);
                    if (idx[i] > rowNr) continue;
                    ++rowNr;
                }
                this.setRowNums();
                break;
            }
            case DeleteTableRow: {
                int[] idx = ta.getCurrentIndex();
                this.table.remove(idx);
                for (int i = 0; i < idx.length; ++i) {
                    if (idx[i] >= rowNr) continue;
                    --rowNr;
                }
                if (this.table.getItemCount() == 0) {
                    this.undoAction();
                }
                this.setRowNums();
                break;
            }
            case ChangeTableRow: {
                int[] idx = ta.getCurrentIndex();
                String[][] curr = (String[][])ta.getCurrent();
                for (int x = 0; x < idx.length; ++x) {
                    TableItem item = this.table.getItem(idx[x]);
                    for (int i = 0; i < curr[x].length; ++i) {
                        item.setText(i + 1, curr[x][i]);
                    }
                }
                break;
            }
            case PositionTableRow: {
                int[] currIdx = ta.getCurrentIndex();
                int[] prev = ta.getPreviousIndex();
                for (int i = 0; i < currIdx.length; ++i) {
                    this.moveRow(currIdx[i], prev[i]);
                }
                this.setRowNums();
                break;
            }
        }
        if (rowNr >= this.table.getItemCount()) {
            rowNr = this.table.getItemCount() - 1;
        }
        if (rowNr < 0) {
            rowNr = 0;
        }
        this.selectRows(rowNr, rowNr);
    }

    private void setUndoMenu() {
        if (!this.undoEnabled) {
            return;
        }
        ChangeAction prev = this.viewPreviousUndo();
        ChangeAction next = this.viewNextUndo();
        if (this.miEditUndo.isDisposed() || this.miEditRedo.isDisposed()) {
            return;
        }
        if (prev != null) {
            this.miEditUndo.setEnabled(true);
            this.miEditUndo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.Undo", (String[])new String[]{prev.toString()})));
        } else {
            this.miEditUndo.setEnabled(false);
            this.miEditUndo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.UndoNotAvailable", (String[])new String[0])));
        }
        if (next != null) {
            this.miEditRedo.setEnabled(true);
            this.miEditRedo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.Redo", (String[])new String[]{next.toString()})));
        } else {
            this.miEditRedo.setEnabled(false);
            this.miEditRedo.setText(OsHelper.customizeMenuitemText(BaseMessages.getString(PKG, (String)"TableView.menu.RedoNotAvailable", (String[])new String[0])));
        }
        if (this.props.isShowTableViewToolbar()) {
            this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_UNDO, prev != null);
            this.toolbarWidgets.enableToolbarItem(ID_TOOLBAR_REDO, next != null);
        }
    }

    private ChangeAction previousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        ChangeAction retval = this.undo.get(this.undoPosition);
        --this.undoPosition;
        return retval;
    }

    private ChangeAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undoPosition < 0) {
            return null;
        }
        return this.undo.get(this.undoPosition);
    }

    private ChangeAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        ++this.undoPosition;
        return this.undo.get(this.undoPosition);
    }

    private ChangeAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undoPosition >= size - 1) {
            return null;
        }
        return this.undo.get(this.undoPosition + 1);
    }

    public void clearUndo() {
        this.undo = new ArrayList();
        this.undoPosition = -1;
    }

    private Point getButtonPosition() {
        return new Point(this.buttonColNr, this.buttonRowNr);
    }

    public String getButtonString() {
        return this.buttonContent;
    }

    public void setButtonString(String str) {
        Point p = this.getButtonPosition();
        TableItem item = this.table.getItem(p.y);
        item.setText(p.x, str);
    }

    public void closeActiveButton() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.dispose();
        }
    }

    public void unEdit() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
            this.text = null;
        }
        if (this.comboVar != null && !this.comboVar.isDisposed()) {
            this.comboVar.dispose();
            this.comboVar = null;
        }
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
            this.combo = null;
        }
    }

    @GuiToolbarElement(root="TableView-Toolbar", id="tableview-toolbar-10320-filtered-selection", image="ui/images/filter.svg", toolTip="i18n::TableView.ToolBarWidget.SetFilter.ToolTip")
    public void setFilter() {
        if (this.condition == null) {
            this.condition = new Condition();
        }
        IRowMeta f = this.getRowWithoutValues();
        EnterConditionDialog ecd = new EnterConditionDialog(this.parent.getShell(), 0, f, this.condition);
        Condition cond = ecd.open();
        if (cond != null) {
            ArrayList<Integer> tokeep = new ArrayList<Integer>();
            int nr = this.table.getItemCount();
            for (int i = nr - 1; i >= 0; --i) {
                RowMetaAndData r = this.getRow(i);
                boolean keep = cond.evaluate(r.getRowMeta(), r.getData());
                if (!keep) continue;
                tokeep.add(i);
            }
            int[] sels = new int[tokeep.size()];
            for (int i = 0; i < sels.length; ++i) {
                sels[i] = (Integer)tokeep.get(i);
            }
            this.table.setSelection(sels);
        }
    }

    public IRowMeta getRowWithoutValues() {
        RowMeta f = new RowMeta();
        f.addValueMeta((IValueMeta)new ValueMetaInteger("#"));
        for (int i = 0; i < this.columns.length; ++i) {
            f.addValueMeta((IValueMeta)new ValueMetaString(this.columns[i].getName()));
        }
        return f;
    }

    public RowMetaAndData getRow(int nr) {
        TableItem ti = this.table.getItem(nr);
        IRowMeta rowMeta = this.getRowWithoutValues();
        Object[] rowData = new Object[rowMeta.size()];
        rowData[0] = (long)nr;
        for (int i = 1; i < rowMeta.size(); ++i) {
            rowData[i] = ti.getText(i);
        }
        return new RowMetaAndData(rowMeta, rowData);
    }

    public int[] getSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.table.getSelectionIndex();
    }

    public void remove(int index) {
        this.table.remove(index);
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public void remove(int[] index) {
        this.table.remove(index);
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public String getItem(int rowNr, int colNr) {
        TableItem item = this.table.getItem(rowNr);
        if (item != null) {
            return item.getText(colNr);
        }
        return null;
    }

    public TableItem add(String ... string) {
        TableItem item = new TableItem(this.table, 0);
        for (int i = 0; i < string.length && i + 1 < this.table.getColumnCount(); ++i) {
            if (string[i] == null) continue;
            item.setText(i + 1, string[i]);
        }
        return item;
    }

    public String[] getItem(int rowNr) {
        TableItem item = this.table.getItem(rowNr);
        if (item != null) {
            return this.getItemText(item);
        }
        return null;
    }

    public String[] getItems(int colNr) {
        String[] retval = new String[this.table.getItemCount()];
        for (int i = 0; i < retval.length; ++i) {
            TableItem item = this.table.getItem(i);
            retval[i] = item.getText(colNr + 1);
        }
        return retval;
    }

    public void removeAll() {
        this.table.removeAll();
        if (this.table.getItemCount() == 0) {
            new TableItem(this.table, 0);
        }
    }

    public int getItemCount() {
        return this.table.getItemCount();
    }

    public void setText(String text, int colNr, int rowNr) {
        TableItem item = this.table.getItem(rowNr);
        item.setText(colNr, text);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
        if (!sortable) {
            this.table.setSortColumn(null);
        } else {
            this.table.setSortColumn(this.table.getColumn(this.sortField));
        }
    }

    public void setFocusOnFirstEditableField() {
        int rowNr = 0;
        boolean gotOne = false;
        for (int colNr = 0; colNr < this.columns.length && !gotOne; ++colNr) {
            if (this.columns[colNr].isReadOnly()) continue;
            gotOne = true;
            this.activeTableItem = this.table.getItem(rowNr);
            this.activeTableColumn = colNr + 1;
            this.edit(rowNr, colNr + 1);
        }
    }

    public void dispose() {
        this.safelyDisposeControl(this.text);
        this.safelyDisposeControl((Control)this.comboVar);
        this.safelyDisposeControl((Control)this.combo);
        super.dispose();
    }

    public int getSortField() {
        return this.sortField;
    }

    public boolean isSortingDescending() {
        return this.sortingDescending;
    }

    public void setSortingDescending(boolean sortingDescending) {
        this.sortingDescending = sortingDescending;
    }

    public Table getTable() {
        return this.table;
    }

    public ColumnInfo getNumberColumn() {
        return this.numberColumn;
    }

    public void setNumberColumn(ColumnInfo numberColumn) {
        this.numberColumn = numberColumn;
    }

    public TableEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TableEditor editor) {
        this.editor = editor;
    }

    public void applyOSXChanges() {
        if (this.text != null && !this.text.isDisposed() && this.lsFocusText != null) {
            this.lsFocusText.focusLost(null);
        }
    }

    public boolean isShowingBlueNullValues() {
        return this.showingBlueNullValues;
    }

    public void setShowingBlueNullValues(boolean showingBlueNullValues) {
        this.showingBlueNullValues = showingBlueNullValues;
    }

    public ModifyListener getContentListener() {
        return this.lsContent;
    }

    public void setContentListener(ModifyListener lsContent) {
        this.lsContent = lsContent;
    }

    public boolean isShowingConversionErrorsInline() {
        return this.showingConversionErrorsInline;
    }

    public void setShowingConversionErrorsInline(boolean showingConversionErrorsInline) {
        this.showingConversionErrorsInline = showingConversionErrorsInline;
    }

    public ColumnInfo[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public TableItem getActiveTableItem() {
        return this.activeTableItem;
    }

    public int getActiveTableColumn() {
        return this.activeTableColumn;
    }

    public void setTableViewModifyListener(ITableViewModifyListener tableViewModifyListener) {
        this.tableViewModifyListener = tableViewModifyListener;
    }

    public boolean hasIndexColumn() {
        return this.addIndexColumn;
    }

    public boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    public void setUndoEnabled(boolean undoEnabled) {
        this.undoEnabled = undoEnabled;
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    public GuiToolbarWidgets getToolbarWidgets() {
        return this.toolbarWidgets;
    }

    public void setToolbarWidgets(GuiToolbarWidgets toolbarWidgets) {
        this.toolbarWidgets = toolbarWidgets;
    }

    public boolean isToolbarEnabled() {
        return this.toolbarEnabled;
    }

    public static interface ITableViewModifyListener {
        public void moveRow(int var1, int var2);

        public void insertRow(int var1);

        public void cellFocusLost(int var1);

        public void delete(int[] var1);
    }
}

