/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopGuiPipelineClipboardDelegate {
    private static final Class<?> PKG = HopGui.class;
    private static final String XML_TAG_PIPELINE_TRANSFORMS = "pipeline-transforms";
    private static final String XML_TAG_TRANSFORMS = "transforms";
    private HopGui hopGui;
    private HopGuiPipelineGraph pipelineGraph;
    private ILogChannel log;

    public HopGuiPipelineClipboardDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
        this.log = hopGui.getLog();
    }

    public void toClipboard(String clipText) {
        try {
            GuiResource.getInstance().toClipboard(clipText);
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Message", (String[])new String[0]), e);
        }
    }

    public String fromClipboard() {
        try {
            return GuiResource.getInstance().fromClipboard();
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Message", (String[])new String[0]), e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pasteXml(PipelineMeta pipelineMeta, String clipboardContent, Point location) {
        try {
            void var20_38;
            Document doc = XmlHandler.loadXmlString((String)clipboardContent);
            Node pipelineNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG_PIPELINE_TRANSFORMS);
            pipelineMeta.unselectAll();
            Node transformsNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_TRANSFORMS);
            int nr = XmlHandler.countNodes((Node)transformsNode, (String)"transform");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundTransforms", (String[])new String[]{"" + nr}) + location);
            }
            Object[] transforms = new TransformMeta[nr];
            ArrayList<String> transformOldNames = new ArrayList<String>(nr);
            Point min = new Point(99999999, 99999999);
            for (int i = 0; i < nr; ++i) {
                Node transformNode = XmlHandler.getSubNodeByNr((Node)transformsNode, (String)"transform", (int)i);
                transforms[i] = new TransformMeta(transformNode, (IHopMetadataProvider)this.hopGui.getMetadataProvider());
                if (location == null) continue;
                Point p = transforms[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node notesNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"notepads");
            nr = XmlHandler.countNodes((Node)notesNode, (String)"notepad");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundNotepads", (String[])new String[]{"" + nr}));
            }
            Object[] notes = new NotePadMeta[nr];
            for (int i = 0; i < nr; ++i) {
                Node noteNode = XmlHandler.getSubNodeByNr((Node)notesNode, (String)"notepad", (int)i);
                notes[i] = new NotePadMeta(noteNode);
                if (location == null) continue;
                Point p = notes[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node hopsNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"order");
            nr = XmlHandler.countNodes((Node)hopsNode, (String)"hop");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundHops", (String[])new String[]{"" + nr}));
            }
            Object[] hops = new PipelineHopMeta[nr];
            for (int i = 0; i < nr; ++i) {
                Node hopNode = XmlHandler.getSubNodeByNr((Node)hopsNode, (String)"hop", (int)i);
                hops[i] = new PipelineHopMeta(hopNode, Arrays.asList(transforms));
            }
            Point offset = new Point(location.x - min.x, location.y - min.y);
            int[] position = new int[transforms.length];
            for (int i = 0; i < transforms.length; ++i) {
                Point p = transforms[i].getLocation();
                String name = transforms[i].getName();
                PropsUi.setLocation((IGuiPosition)transforms[i], p.x + offset.x, p.y + offset.y);
                transformOldNames.add(name);
                transforms[i].setName(pipelineMeta.getAlternativeTransformName(name));
                pipelineMeta.addTransform(transforms[i]);
                position[i] = pipelineMeta.indexOfTransform(transforms[i]);
                transforms[i].setSelected(true);
            }
            for (PipelineHopMeta pipelineHopMeta : hops) {
                pipelineMeta.addPipelineHop(pipelineHopMeta);
            }
            for (PipelineHopMeta pipelineHopMeta : notes) {
                Point p = pipelineHopMeta.getLocation();
                PropsUi.setLocation((IGuiPosition)pipelineHopMeta, p.x + offset.x, p.y + offset.y);
                pipelineMeta.addNote((NotePadMeta)pipelineHopMeta);
                pipelineHopMeta.setSelected(true);
            }
            for (PipelineHopMeta pipelineHopMeta : transforms) {
                ITransformMeta smi = pipelineHopMeta.getTransform();
                smi.searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
            }
            Node errorHandlingNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"transform_error_handling");
            int nrErrorHandlers = XmlHandler.countNodes((Node)errorHandlingNode, (String)"error");
            for (int i = 0; i < nrErrorHandlers; ++i) {
                TransformMeta sourceTransform;
                Node node = XmlHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i);
                TransformErrorMeta transformErrorMeta = new TransformErrorMeta(node, pipelineMeta.getTransforms());
                int srcTransformPos = transformOldNames.indexOf(transformErrorMeta.getSourceTransform().getName());
                int tgtTransformPos = -1;
                if (transformErrorMeta.getTargetTransform() != null) {
                    tgtTransformPos = transformOldNames.indexOf(transformErrorMeta.getTargetTransform().getName());
                }
                if ((sourceTransform = pipelineMeta.findTransform(transforms[srcTransformPos].getName())) != null) {
                    sourceTransform.setTransformErrorMeta(transformErrorMeta);
                }
                sourceTransform.setTransformErrorMeta(null);
                if (tgtTransformPos < 0) continue;
                sourceTransform.setTransformErrorMeta(transformErrorMeta);
                TransformMeta targetTransform = pipelineMeta.findTransform(transforms[tgtTransformPos].getName());
                transformErrorMeta.setSourceTransform(sourceTransform);
                transformErrorMeta.setTargetTransform(targetTransform);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, transforms, position, false);
            int[] hopPos = new int[hops.length];
            boolean bl = false;
            while (var20_38 < hops.length) {
                hopPos[var20_38] = pipelineMeta.indexOfPipelineHop(hops[var20_38]);
                ++var20_38;
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, hops, hopPos, true);
            int[] nArray = new int[notes.length];
            for (int i = 0; i < notes.length; ++i) {
                nArray[i] = pipelineMeta.indexOfNote(notes[i]);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, notes, nArray, true);
        }
        catch (HopException e) {
            this.pasteNoXmlContent(pipelineMeta, clipboardContent, location);
        }
        this.pipelineGraph.redraw();
    }

    private void pasteNoXmlContent(PipelineMeta pipelineMeta, String clipboardContent, Point location) {
        try {
            NotePadMeta notePadMeta = new NotePadMeta(clipboardContent, location.x, location.y, 20, 20);
            pipelineMeta.addNote(notePadMeta);
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, new NotePadMeta[]{notePadMeta}, new int[]{pipelineMeta.indexOfNote(notePadMeta)});
            this.shiftLocation(location);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteTransforms.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteTransforms.Message", (String[])new String[0]), e);
        }
    }

    public void shiftLocation(Point location) {
        location.x += (int)(10.0 * PropsUi.getInstance().getZoomFactor());
        location.y += (int)(5.0 * PropsUi.getInstance().getZoomFactor());
    }

    public void copySelected(PipelineMeta pipelineMeta, List<TransformMeta> transforms, List<NotePadMeta> notes) {
        if (transforms == null || transforms.size() + notes.size() == 0) {
            return;
        }
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        try {
            xml.append(XmlHandler.openTag((String)XML_TAG_PIPELINE_TRANSFORMS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)XML_TAG_TRANSFORMS)).append(Const.CR);
            for (TransformMeta transform : transforms) {
                xml.append(transform.getXml());
            }
            xml.append(XmlHandler.closeTag((String)XML_TAG_TRANSFORMS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"order")).append(Const.CR);
            for (TransformMeta transform1 : transforms) {
                for (TransformMeta transform2 : transforms) {
                    PipelineHopMeta hop;
                    if (transform1 == transform2 || (hop = pipelineMeta.findPipelineHop(transform1, transform2, true)) == null) continue;
                    xml.append(hop.getXml()).append(Const.CR);
                }
            }
            xml.append(XmlHandler.closeTag((String)"order")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"notepads")).append(Const.CR);
            if (notes != null) {
                for (NotePadMeta note : notes) {
                    xml.append(note.getXml());
                }
            }
            xml.append(XmlHandler.closeTag((String)"notepads")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"transform_error_handling")).append(Const.CR);
            for (TransformMeta transform : transforms) {
                if (transform.getTransformErrorMeta() == null) continue;
                xml.append(transform.getTransformErrorMeta().getXml()).append(Const.CR);
            }
            xml.append(XmlHandler.closeTag((String)"transform_error_handling")).append(Const.CR);
            xml.append(XmlHandler.closeTag((String)XML_TAG_PIPELINE_TRANSFORMS)).append(Const.CR);
            this.toClipboard(xml.toString());
        }
        catch (Exception ex) {
            new ErrorDialog(this.hopGui.getActiveShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }
}

