/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.console;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class Exporter {
    private static final String DEFAULT_CSV_DELIMITER = ";";
    private static final byte[] UTF8_BYTE_ORDER_MARK = new byte[]{-17, -69, -65};
    private final String delimiter;
    private final boolean includeBom;
    private final boolean preserveNewlines;

    private Exporter(String _delimter, boolean _includeBom, boolean _preserveNewlines) {
        this.delimiter = _delimter;
        this.includeBom = _includeBom;
        this.preserveNewlines = _preserveNewlines;
    }

    public void dumpCsv(ResultSet rs, PrintStream out) throws SQLException, IOException {
        if (this.includeBom) {
            out.write(UTF8_BYTE_ORDER_MARK);
        }
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        String comma = "";
        for (int i = 1; i <= cols; ++i) {
            String lb = meta.getColumnLabel(i);
            out.print(comma);
            out.print(Exporter.toCsv(lb, this.delimiter, false));
            comma = this.delimiter;
        }
        out.println();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DecimalFormat decimalFormat = new DecimalFormat("0.0########");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(dfs);
        decimalFormat.setGroupingUsed(false);
        while (rs.next()) {
            comma = "";
            for (int i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                if (o == null) {
                    o = "";
                } else if (o.getClass().isArray()) {
                    o = Arrays.toString((Object[])o);
                } else if (o instanceof Date) {
                    o = dateFormat.format((Date)o);
                } else if (o instanceof BigDecimal) {
                    o = decimalFormat.format(o);
                }
                out.print(comma);
                out.print(Exporter.toCsv(o.toString(), this.delimiter, this.preserveNewlines));
                comma = this.delimiter;
            }
            out.println();
        }
    }

    public void dumpSchema(ResultSet rs, PrintStream out) throws SQLException, IOException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        out.println("[");
        for (int i = 1; i <= cols; ++i) {
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            int nullable = meta.isNullable(i);
            out.print(Exporter.toSchemaRow(name, sqlType, nullable));
            out.printf(i != cols ? ",%n" : "%n", new Object[0]);
        }
        out.println("]");
    }

    static String toCsv(String s, String delimiter, boolean preserveNewlines) {
        boolean needsTextQualifier = false;
        if (s.contains("\"")) {
            s = s.replace("\"", "\"\"");
            needsTextQualifier = true;
        }
        if (s.contains(delimiter)) {
            needsTextQualifier = true;
        }
        if (preserveNewlines) {
            needsTextQualifier = true;
        } else {
            s = s.replace("\n", " ").replace("\r", " ");
        }
        if (needsTextQualifier) {
            return "\"" + s + "\"";
        }
        return s;
    }

    static String toSchemaRow(String name, int sqlType, int nullable) {
        return String.format("{\"name\": \"%s\", \"type\": \"%s\", \"mode\": \"%s\"}", name, Exporter.toBigQueryType(sqlType), Exporter.toBigQueryNullable(nullable));
    }

    static String toBigQueryType(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "int64";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "float64";
            }
            case 93: {
                return "timestamp";
            }
            case 16: {
                return "bool";
            }
        }
        return "string";
    }

    static String toBigQueryNullable(int nullable) {
        switch (nullable) {
            case 0: {
                return "required";
            }
            case 1: 
            case 2: {
                return "nullable";
            }
        }
        return "nullable";
    }

    public static class Builder {
        private String delimiter = ";";
        private boolean includeBom = false;
        private boolean preserveNewlines = false;

        public Builder setDelimiter(String _delimiter) {
            this.delimiter = _delimiter;
            return this;
        }

        public Builder includeBom(boolean _includeBom) {
            this.includeBom = _includeBom;
            return this;
        }

        public Builder preserveNewlines(boolean preverseNewlines) {
            this.preserveNewlines = preverseNewlines;
            return this;
        }

        public Exporter build() {
            return new Exporter(this.delimiter, this.includeBom, this.preserveNewlines);
        }
    }
}

