/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.UUID;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineRunner;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.JobInvoker;
import org.apache.beam.runners.jobsubmission.PortablePipelineJarCreator;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkJobInvoker
extends JobInvoker {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkJobInvoker.class);
    private final  @UnknownKeyFor @NonNull @Initialized FlinkJobServerDriver.FlinkServerConfiguration serverConfig;

    public static @UnknownKeyFor @NonNull @Initialized FlinkJobInvoker create( @UnknownKeyFor @NonNull @Initialized FlinkJobServerDriver.FlinkServerConfiguration serverConfig) {
        return new FlinkJobInvoker(serverConfig);
    }

    protected FlinkJobInvoker( @UnknownKeyFor @NonNull @Initialized FlinkJobServerDriver.FlinkServerConfiguration serverConfig) {
        super("flink-runner-job-invoker-%d");
        this.serverConfig = serverConfig;
    }

    protected @UnknownKeyFor @NonNull @Initialized JobInvocation invokeWithExecutor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized Struct options, @Nullable @UnknownKeyFor @Initialized String retrievalToken, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService) {
        PortablePipelineOptions portableOptions;
        LOG.trace("Parsing pipeline options");
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)PipelineOptionsTranslation.fromProto((Struct)options).as(FlinkPipelineOptions.class);
        String invocationId = String.format("%s_%s", flinkOptions.getJobName(), UUID.randomUUID().toString());
        if ("[auto]".equals(flinkOptions.getFlinkMaster())) {
            flinkOptions.setFlinkMaster(this.serverConfig.getFlinkMaster());
        }
        Object pipelineRunner = Strings.isNullOrEmpty((String)(portableOptions = (PortablePipelineOptions)flinkOptions.as(PortablePipelineOptions.class)).getOutputExecutablePath()) ? new FlinkPipelineRunner(flinkOptions, this.serverConfig.getFlinkConfDir(), PipelineResources.detectClassPathResourcesToStage((ClassLoader)FlinkJobInvoker.class.getClassLoader(), (PipelineOptions)flinkOptions)) : new PortablePipelineJarCreator(FlinkPipelineRunner.class);
        flinkOptions.setRunner(null);
        LOG.info("Invoking job {} with pipeline runner {}", (Object)invocationId, pipelineRunner);
        return this.createJobInvocation(invocationId, retrievalToken, executorService, pipeline, flinkOptions, (PortablePipelineRunner)pipelineRunner);
    }

    protected @UnknownKeyFor @NonNull @Initialized JobInvocation createJobInvocation(@UnknownKeyFor @NonNull @Initialized String invocationId, @UnknownKeyFor @NonNull @Initialized String retrievalToken, @UnknownKeyFor @NonNull @Initialized ListeningExecutorService executorService, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions flinkOptions, @UnknownKeyFor @NonNull @Initialized PortablePipelineRunner pipelineRunner) {
        JobInfo jobInfo = JobInfo.create((String)invocationId, (String)flinkOptions.getJobName(), (String)retrievalToken, (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)flinkOptions));
        return new JobInvocation(jobInfo, executorService, pipeline, pipelineRunner);
    }
}

