/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.construction.graph.ProjectionPushdownOptimizer;
import org.apache.beam.runners.flink.FlinkPipelineExecutionEnvironment;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkRunner
extends PipelineRunner<PipelineResult> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> ptransformViewsWithNonDeterministicKeyCoders;

    public static @UnknownKeyFor @NonNull @Initialized FlinkRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)PipelineOptionsValidator.validate(FlinkPipelineOptions.class, (PipelineOptions)options);
        return new FlinkRunner(flinkOptions);
    }

    protected FlinkRunner(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        this.options = options;
        this.ptransformViewsWithNonDeterministicKeyCoders = new HashSet();
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"beam_fn_api")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary((Pipeline)pipeline);
        }
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)this.options, (String)"disable_projection_pushdown")) {
            ProjectionPushdownOptimizer.optimize((Pipeline)pipeline);
        }
        this.logWarningIfPCollectionViewHasNonDeterministicKeyCoder(pipeline);
        MetricsEnvironment.setMetricsSupported((boolean)true);
        LOG.info("Executing pipeline using FlinkRunner.");
        if (!this.options.getFasterCopy().booleanValue()) {
            LOG.warn("For maximum performance you should set the 'fasterCopy' option. See more at https://issues.apache.org/jira/browse/BEAM-11146");
        }
        FlinkPipelineExecutionEnvironment env = new FlinkPipelineExecutionEnvironment(this.options);
        LOG.info("Translating pipeline to Flink program.");
        env.translate(pipeline);
        try {
            LOG.info("Starting execution of Flink program.");
            return env.executePipeline();
        }
        catch (Exception e) {
            LOG.error("Pipeline execution failed", (Throwable)e);
            throw new RuntimeException("Pipeline execution failed", e);
        }
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions getPipelineOptions() {
        return this.options;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FlinkRunner#" + ((Object)((Object)this)).hashCode();
    }

    void recordViewUsesNonDeterministicKeyCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> ptransform) {
        this.ptransformViewsWithNonDeterministicKeyCoders.add(ptransform);
    }

    private void logWarningIfPCollectionViewHasNonDeterministicKeyCoder(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        if (!this.ptransformViewsWithNonDeterministicKeyCoders.isEmpty()) {
            final TreeSet ptransformViewNamesWithNonDeterministicKeyCoders = new TreeSet();
            pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

                public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (FlinkRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                    if (FlinkRunner.this.ptransformViewsWithNonDeterministicKeyCoders.contains(node.getTransform())) {
                        ptransformViewNamesWithNonDeterministicKeyCoders.add(node.getFullName());
                    }
                    return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }
            });
            LOG.warn("Unable to use indexed implementation for View.AsMap and View.AsMultimap for {} because the key coder is not deterministic. Falling back to singleton implementation which may cause memory and/or performance problems. Future major versions of the Flink runner will require deterministic key coders.", ptransformViewNamesWithNonDeterministicKeyCoders);
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized JobGraph getJobGraph(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        FlinkPipelineExecutionEnvironment env = new FlinkPipelineExecutionEnvironment(this.options);
        return env.getJobGraph(p);
    }
}

