/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingElementsHandler;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.state.ListState;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NonKeyedBufferingElementsHandler<@UnknownKeyFor T>
implements BufferingElementsHandler {
    private final @UnknownKeyFor @NonNull @Initialized ListState<@UnknownKeyFor @NonNull @Initialized BufferedElement> elementState;

    static <T> @UnknownKeyFor @NonNull @Initialized NonKeyedBufferingElementsHandler<T> create(@UnknownKeyFor @NonNull @Initialized ListState<@UnknownKeyFor @NonNull @Initialized BufferedElement> elementState) {
        return new NonKeyedBufferingElementsHandler<T>(elementState);
    }

    private NonKeyedBufferingElementsHandler(@UnknownKeyFor @NonNull @Initialized ListState<@UnknownKeyFor @NonNull @Initialized BufferedElement> elementState) {
        this.elementState = (ListState)Preconditions.checkNotNull(elementState);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Stream<@UnknownKeyFor @NonNull @Initialized BufferedElement> getElements() {
        try {
            return StreamSupport.stream(((Iterable)this.elementState.get()).spliterator(), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve buffered element from state backend.", e);
        }
    }

    @Override
    public void buffer(@UnknownKeyFor @NonNull @Initialized BufferedElement element) {
        try {
            this.elementState.add((Object)element);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to buffer element in state backend.", e);
        }
    }

    @Override
    public void clear() {
        this.elementState.clear();
    }
}

