/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.DelegatingCounter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Metrics {
    private Metrics() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter counter(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter counter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingCounter(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Distribution distribution(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Distribution distribution(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingDistribution(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge gauge(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge gauge(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return new DelegatingGauge(MetricName.named(namespace, name));
    }

    private static class DelegatingGauge
    implements Metric,
    Gauge,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private DelegatingGauge(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        @Override
        public void set(@UnknownKeyFor @NonNull @Initialized long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getGauge(this.name).set(value);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }

    private static class DelegatingDistribution
    implements Metric,
    Distribution,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private DelegatingDistribution(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized long value) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(value);
            }
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
            MetricsContainer container = MetricsEnvironment.getCurrentContainer();
            if (container != null) {
                container.getDistribution(this.name).update(sum, count, min, max);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }
}

