/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PartitioningWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class CalendarWindows {
    private static final @UnknownKeyFor @NonNull @Initialized DateTime DEFAULT_START_DATE = new DateTime(0L, DateTimeZone.UTC);

    public static @UnknownKeyFor @NonNull @Initialized DaysWindows days(@UnknownKeyFor @NonNull @Initialized int number) {
        return new DaysWindows(number, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static @UnknownKeyFor @NonNull @Initialized DaysWindows weeks(@UnknownKeyFor @NonNull @Initialized int number, @UnknownKeyFor @NonNull @Initialized int startDayOfWeek) {
        return new DaysWindows(7 * number, DEFAULT_START_DATE.withDayOfWeek(startDayOfWeek), DateTimeZone.UTC);
    }

    public static @UnknownKeyFor @NonNull @Initialized MonthsWindows months(@UnknownKeyFor @NonNull @Initialized int number) {
        return new MonthsWindows(number, 1, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static @UnknownKeyFor @NonNull @Initialized YearsWindows years(@UnknownKeyFor @NonNull @Initialized int number) {
        return new YearsWindows(number, 1, 1, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static class YearsWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private @UnknownKeyFor @NonNull @Initialized int number;
        private @UnknownKeyFor @NonNull @Initialized int monthOfYear;
        private @UnknownKeyFor @NonNull @Initialized int dayOfMonth;
        private @UnknownKeyFor @NonNull @Initialized DateTime startDate;
        private @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone;

        public @UnknownKeyFor @NonNull @Initialized YearsWindows beginningOnDay(@UnknownKeyFor @NonNull @Initialized int monthOfYear, @UnknownKeyFor @NonNull @Initialized int dayOfMonth) {
            return new YearsWindows(this.number, monthOfYear, dayOfMonth, this.startDate, this.timeZone);
        }

        public @UnknownKeyFor @NonNull @Initialized YearsWindows withStartingYear(@UnknownKeyFor @NonNull @Initialized int year) {
            return new YearsWindows(this.number, this.monthOfYear, this.dayOfMonth, new DateTime(year, 1, 1, 0, 0, this.timeZone), this.timeZone);
        }

        public @UnknownKeyFor @NonNull @Initialized YearsWindows withTimeZone(@UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            return new YearsWindows(this.number, this.monthOfYear, this.dayOfMonth, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private YearsWindows(@UnknownKeyFor @NonNull @Initialized int number, @UnknownKeyFor @NonNull @Initialized int monthOfYear, @UnknownKeyFor @NonNull @Initialized int dayOfMonth, @UnknownKeyFor @NonNull @Initialized DateTime startDate, @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            this.number = number;
            this.monthOfYear = monthOfYear;
            this.dayOfMonth = dayOfMonth;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IntervalWindow assignWindow(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            DateTime offsetStart = this.startDate.withMonthOfYear(this.monthOfYear).withDayOfMonth(this.dayOfMonth);
            int yearOffset = Years.yearsBetween((ReadableInstant)offsetStart, (ReadableInstant)datetime).getYears() / this.number * this.number;
            DateTime begin = offsetStart.plusYears(yearOffset);
            DateTime end = begin.plusYears(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
            if (!(other instanceof YearsWindows)) {
                return false;
            }
            YearsWindows that = (YearsWindows)other;
            return this.number == that.number && this.monthOfYear == that.monthOfYear && this.dayOfMonth == that.dayOfMonth && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of years, month of year, day of month, start date and time zone are compatible.", YearsWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numYears", this.number).withLabel("Window Years")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public @UnknownKeyFor @NonNull @Initialized DateTimeZone getTimeZone() {
            return this.timeZone;
        }

        public @UnknownKeyFor @NonNull @Initialized DateTime getStartDate() {
            return this.startDate;
        }

        public @UnknownKeyFor @NonNull @Initialized int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public @UnknownKeyFor @NonNull @Initialized int getMonthOfYear() {
            return this.monthOfYear;
        }

        public @UnknownKeyFor @NonNull @Initialized int getNumber() {
            return this.number;
        }
    }

    public static class MonthsWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private @UnknownKeyFor @NonNull @Initialized int number;
        private @UnknownKeyFor @NonNull @Initialized int dayOfMonth;
        private @UnknownKeyFor @NonNull @Initialized DateTime startDate;
        private @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone;

        public @UnknownKeyFor @NonNull @Initialized MonthsWindows beginningOnDay(@UnknownKeyFor @NonNull @Initialized int dayOfMonth) {
            return new MonthsWindows(this.number, dayOfMonth, this.startDate, this.timeZone);
        }

        public @UnknownKeyFor @NonNull @Initialized MonthsWindows withStartingMonth(@UnknownKeyFor @NonNull @Initialized int year, @UnknownKeyFor @NonNull @Initialized int month) {
            return new MonthsWindows(this.number, this.dayOfMonth, new DateTime(year, month, 1, 0, 0, this.timeZone), this.timeZone);
        }

        public @UnknownKeyFor @NonNull @Initialized MonthsWindows withTimeZone(@UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            return new MonthsWindows(this.number, this.dayOfMonth, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private MonthsWindows(@UnknownKeyFor @NonNull @Initialized int number, @UnknownKeyFor @NonNull @Initialized int dayOfMonth, @UnknownKeyFor @NonNull @Initialized DateTime startDate, @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            this.number = number;
            this.dayOfMonth = dayOfMonth;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IntervalWindow assignWindow(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            int monthOffset = Months.monthsBetween((ReadableInstant)this.startDate.withDayOfMonth(this.dayOfMonth), (ReadableInstant)datetime).getMonths() / this.number * this.number;
            DateTime begin = this.startDate.withDayOfMonth(this.dayOfMonth).plusMonths(monthOffset);
            DateTime end = begin.plusMonths(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
            if (!(other instanceof MonthsWindows)) {
                return false;
            }
            MonthsWindows that = (MonthsWindows)other;
            return this.number == that.number && this.dayOfMonth == that.dayOfMonth && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of months, day of month, start date and time zone are compatible.", MonthsWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numMonths", this.number).withLabel("Window Months")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public @UnknownKeyFor @NonNull @Initialized int getNumber() {
            return this.number;
        }

        public @UnknownKeyFor @NonNull @Initialized int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public @UnknownKeyFor @NonNull @Initialized DateTime getStartDate() {
            return this.startDate;
        }

        public @UnknownKeyFor @NonNull @Initialized DateTimeZone getTimeZone() {
            return this.timeZone;
        }
    }

    public static class DaysWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private @UnknownKeyFor @NonNull @Initialized int number;
        private @UnknownKeyFor @NonNull @Initialized DateTime startDate;
        private @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone;

        public @UnknownKeyFor @NonNull @Initialized DaysWindows withStartingDay(@UnknownKeyFor @NonNull @Initialized int year, @UnknownKeyFor @NonNull @Initialized int month, @UnknownKeyFor @NonNull @Initialized int day) {
            return new DaysWindows(this.number, new DateTime(year, month, day, 0, 0, this.timeZone), this.timeZone);
        }

        public @UnknownKeyFor @NonNull @Initialized DaysWindows withTimeZone(@UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            return new DaysWindows(this.number, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private DaysWindows(@UnknownKeyFor @NonNull @Initialized int number, @UnknownKeyFor @NonNull @Initialized DateTime startDate, @UnknownKeyFor @NonNull @Initialized DateTimeZone timeZone) {
            this.number = number;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IntervalWindow assignWindow(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            int dayOffset = Days.daysBetween((ReadableInstant)this.startDate, (ReadableInstant)datetime).getDays() / this.number * this.number;
            DateTime begin = this.startDate.plusDays(dayOffset);
            DateTime end = begin.plusDays(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) {
            if (!(other instanceof DaysWindows)) {
                return false;
            }
            DaysWindows that = (DaysWindows)other;
            return this.number == that.number && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of days, start date and time zone are compatible.", DaysWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numDays", this.number).withLabel("Windows Days")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public @UnknownKeyFor @NonNull @Initialized int getNumber() {
            return this.number;
        }

        public @UnknownKeyFor @NonNull @Initialized DateTime getStartDate() {
            return this.startDate;
        }

        public @UnknownKeyFor @NonNull @Initialized DateTimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

