/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.AggregateDefinition;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToCharViaLongToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToStringViaLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToVarCharViaLongToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastMillisecondsLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringGroupToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringGroupToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringGroupToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DynamicValueVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterConstantBooleanVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStructColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterTimestampColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDoubleInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ILongInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStructInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ITimestampInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StructColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TimestampColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncStringOutput;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorCoalesce;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorElt;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFAvgDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFAvgTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilterMerge;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCount;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCountMerge;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCountStar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFStdPopTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFStdSampTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFVarPopTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFVarSampTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFAvgDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFAvgLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMaxTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdPopLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFStdSampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarPopLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFVarSampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToBooleanViaLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToFloatViaLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDateColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCbrt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFactorial;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeast;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizationContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorizationContext.class.getName());
    private final String contextName;
    private final int level;
    VectorExpressionDescriptor vMap;
    private final List<String> initialColumnNames;
    private List<Integer> projectedColumns;
    private List<String> projectionColumnNames;
    private Map<String, Integer> projectionColumnMap;
    private int firstOutputColumnIndex;
    private HiveVectorAdaptorUsageMode hiveVectorAdaptorUsageMode;
    public static final Pattern decimalTypePattern = Pattern.compile("decimal.*", 2);
    public static final Pattern charTypePattern = Pattern.compile("char.*", 2);
    public static final Pattern varcharTypePattern = Pattern.compile("varchar.*", 2);
    public static final Pattern charVarcharTypePattern = Pattern.compile("char.*|varchar.*", 2);
    private OutputColumnManager ocm;
    private static Set<Class<?>> castExpressionUdfs = new HashSet();
    private static Set<Class<?>> udfsNeedingImplicitDecimalCast;
    private static final int STACK_LENGTH_LIMIT = 15;
    static ArrayList<AggregateDefinition> aggregatesDefinition;

    private void setHiveConfVars(HiveConf hiveConf) {
        this.hiveVectorAdaptorUsageMode = HiveVectorAdaptorUsageMode.getHiveConfValue(hiveConf);
    }

    private void copyHiveConfVars(VectorizationContext vContextEnvironment) {
        this.hiveVectorAdaptorUsageMode = vContextEnvironment.hiveVectorAdaptorUsageMode;
    }

    public VectorizationContext(String contextName, List<String> initialColumnNames, HiveConf hiveConf) {
        this.contextName = contextName;
        this.level = 0;
        this.initialColumnNames = initialColumnNames;
        this.projectionColumnNames = initialColumnNames;
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.projectionColumnNames.size(); ++i) {
            this.projectedColumns.add(i);
            this.projectionColumnMap.put(this.projectionColumnNames.get(i), i);
        }
        int firstOutputColumnIndex = this.projectedColumns.size();
        this.ocm = new OutputColumnManager(firstOutputColumnIndex);
        this.firstOutputColumnIndex = firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
        if (hiveConf != null) {
            this.setHiveConfVars(hiveConf);
        }
    }

    public VectorizationContext(String contextName, List<String> initialColumnNames, VectorizationContext vContextEnvironment) {
        this(contextName, initialColumnNames, (HiveConf)null);
        this.copyHiveConfVars(vContextEnvironment);
    }

    @VisibleForTesting
    public VectorizationContext(String contextName, List<String> initialColumnNames) {
        this(contextName, initialColumnNames, (HiveConf)null);
    }

    public VectorizationContext(String contextName, HiveConf hiveConf) {
        this.contextName = contextName;
        this.level = 0;
        this.initialColumnNames = new ArrayList<String>();
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        this.ocm = new OutputColumnManager(0);
        this.firstOutputColumnIndex = 0;
        this.vMap = new VectorExpressionDescriptor();
        if (hiveConf != null) {
            this.setHiveConfVars(hiveConf);
        }
    }

    @VisibleForTesting
    public VectorizationContext(String contextName) {
        this(contextName, (HiveConf)null);
    }

    public VectorizationContext(String contextName, VectorizationContext vContext) {
        this.contextName = contextName;
        this.level = vContext.level + 1;
        this.initialColumnNames = vContext.initialColumnNames;
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        this.ocm = vContext.ocm;
        this.firstOutputColumnIndex = vContext.firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
        this.copyHiveConfVars(vContext);
    }

    public void addInitialColumn(String columnName) {
        this.initialColumnNames.add(columnName);
        int index = this.projectedColumns.size();
        this.projectedColumns.add(index);
        this.projectionColumnNames.add(columnName);
        this.projectionColumnMap.put(columnName, index);
    }

    public void finishedAddingInitialColumns() {
        int firstOutputColumnIndex = this.projectedColumns.size();
        this.ocm = new OutputColumnManager(firstOutputColumnIndex);
        this.firstOutputColumnIndex = firstOutputColumnIndex;
    }

    public void resetProjectionColumns() {
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
    }

    public void addProjectionColumn(String columnName, int vectorBatchColIndex) {
        this.projectedColumns.add(vectorBatchColIndex);
        this.projectionColumnNames.add(columnName);
        this.projectionColumnMap.put(columnName, vectorBatchColIndex);
    }

    public List<String> getInitialColumnNames() {
        return this.initialColumnNames;
    }

    public List<Integer> getProjectedColumns() {
        return this.projectedColumns;
    }

    public List<String> getProjectionColumnNames() {
        return this.projectionColumnNames;
    }

    public Map<String, Integer> getProjectionColumnMap() {
        return this.projectionColumnMap;
    }

    protected boolean needsImplicitCastForDecimal(GenericUDF udf) {
        Class<Object> udfClass = udf.getClass();
        if (udf instanceof GenericUDFBridge) {
            udfClass = ((GenericUDFBridge)udf).getUdfClass();
        }
        return udfsNeedingImplicitDecimalCast.contains(udfClass);
    }

    protected int getInputColumnIndex(String name) throws HiveException {
        if (name == null) {
            throw new HiveException("Null column name");
        }
        if (!this.projectionColumnMap.containsKey(name)) {
            throw new HiveException(String.format("The column %s is not in the vectorization context column map %s.", name, this.projectionColumnMap.toString()));
        }
        return this.projectionColumnMap.get(name);
    }

    protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) throws HiveException {
        return this.getInputColumnIndex(colExpr.getColumn());
    }

    public int allocateScratchColumn(TypeInfo typeInfo) throws HiveException {
        return this.ocm.allocateOutputColumn(typeInfo);
    }

    public int[] currentScratchColumns() {
        return this.ocm.currentScratchColumns();
    }

    private VectorExpression getColumnVectorExpression(ExprNodeColumnDesc exprDesc, VectorExpressionDescriptor.Mode mode) throws HiveException {
        int columnNum = this.getInputColumnIndex(exprDesc.getColumn());
        VectorExpression expr = null;
        switch (mode) {
            case FILTER: {
                TypeInfo typeInfo = exprDesc.getTypeInfo();
                if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                    expr = new SelectColumnIsTrue(columnNum);
                    break;
                }
                ArrayList<ExprNodeDesc> exprAsList = new ArrayList<ExprNodeDesc>(1);
                exprAsList.add(exprDesc);
                VectorExpression castToBooleanExpr = this.getCastToBoolean(exprAsList);
                if (castToBooleanExpr == null && (castToBooleanExpr = this.getVectorExpressionForUdf(null, UDFToBoolean.class, exprAsList, VectorExpressionDescriptor.Mode.PROJECTION, null)) == null) {
                    throw new HiveException("Cannot vectorize converting expression " + exprDesc.getExprString() + " to boolean");
                }
                expr = new SelectColumnIsTrue(castToBooleanExpr.getOutputColumn());
                expr.setChildExpressions(new VectorExpression[]{castToBooleanExpr});
                break;
            }
            case PROJECTION: {
                expr = new IdentityExpression(columnNum, exprDesc.getTypeString());
            }
        }
        return expr;
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes) throws HiveException {
        return this.getVectorExpressions(exprNodes, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes, VectorExpressionDescriptor.Mode mode) throws HiveException {
        int i = 0;
        if (null == exprNodes) {
            return new VectorExpression[0];
        }
        VectorExpression[] ret = new VectorExpression[exprNodes.size()];
        for (ExprNodeDesc e : exprNodes) {
            ret[i++] = this.getVectorExpression(e, mode);
        }
        return ret;
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc) throws HiveException {
        return this.getVectorExpression(exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc, VectorExpressionDescriptor.Mode mode) throws HiveException {
        VectorExpression ve = null;
        if (exprDesc instanceof ExprNodeColumnDesc) {
            ve = this.getColumnVectorExpression((ExprNodeColumnDesc)exprDesc, mode);
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc childExpr;
            ExprNodeDesc child;
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)exprDesc;
            if ("not".equals(expr.getFuncText()) && expr.getChildren() != null && expr.getChildren().size() == 1 && (child = expr.getChildren().get(0)) instanceof ExprNodeGenericFuncDesc && "between".equals((childExpr = (ExprNodeGenericFuncDesc)child).getFuncText())) {
                ExprNodeConstantDesc flag = (ExprNodeConstantDesc)childExpr.getChildren().get(0);
                ArrayList<ExprNodeDesc> newChildren = new ArrayList<ExprNodeDesc>();
                if (Boolean.TRUE.equals(flag.getValue())) {
                    newChildren.add(new ExprNodeConstantDesc(Boolean.FALSE));
                } else {
                    newChildren.add(new ExprNodeConstantDesc(Boolean.TRUE));
                }
                newChildren.addAll(childExpr.getChildren().subList(1, childExpr.getChildren().size()));
                expr.setTypeInfo(childExpr.getTypeInfo());
                expr.setGenericUDF(childExpr.getGenericUDF());
                expr.setChildren(newChildren);
            }
            List<ExprNodeDesc> childExpressions = this.getChildExpressionsWithImplicitCast(expr.getGenericUDF(), exprDesc.getChildren(), exprDesc.getTypeInfo());
            ve = this.getGenericUdfVectorExpression(expr.getGenericUDF(), childExpressions, mode, exprDesc.getTypeInfo());
            if (ve == null && this.hiveVectorAdaptorUsageMode != null) {
                switch (this.hiveVectorAdaptorUsageMode) {
                    case NONE: {
                        throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=none");
                    }
                    case CHOSEN: {
                        if (VectorizationContext.isNonVectorizedPathUDF(expr, mode)) {
                            ve = this.getCustomUDFExpression(expr, mode);
                            break;
                        }
                        throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=chosen and the UDF wasn't one of the chosen ones");
                    }
                    case ALL: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("We will try to use the VectorUDFAdaptor for " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=all");
                        }
                        ve = this.getCustomUDFExpression(expr, mode);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown hive vector adaptor usage mode " + this.hiveVectorAdaptorUsageMode.name());
                    }
                }
                if (ve == null) {
                    throw new HiveException("Unable vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " even for the VectorUDFAdaptor");
                }
            }
        } else if (exprDesc instanceof ExprNodeConstantDesc) {
            ve = this.getConstantVectorExpression(((ExprNodeConstantDesc)exprDesc).getValue(), exprDesc.getTypeInfo(), mode);
        } else if (exprDesc instanceof ExprNodeDynamicValueDesc) {
            ve = this.getDynamicValueVectorExpression((ExprNodeDynamicValueDesc)exprDesc, mode);
        }
        if (ve == null) {
            throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input Expression = " + exprDesc.toString() + ", Vectorized Expression = " + ve.toString());
        }
        return ve;
    }

    private TypeInfo getCommonTypeForChildExpressions(GenericUDF genericUdf, List<ExprNodeDesc> children, TypeInfo returnType) throws HiveException {
        TypeInfo commonType;
        if (genericUdf instanceof GenericUDFBaseCompare) {
            TypeInfo tRight;
            TypeInfo tLeft = children.get(0).getTypeInfo();
            commonType = FunctionRegistry.getCommonClassForComparison(tLeft, tRight = children.get(1).getTypeInfo());
            if (commonType == null) {
                commonType = returnType;
            }
        } else {
            if (genericUdf instanceof GenericUDFIn) {
                TypeInfo colTi = children.get(0).getTypeInfo();
                if (colTi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    return colTi;
                }
                TypeInfo opTi = GenericUDFUtils.deriveInType(children);
                if (opTi == null || opTi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    throw new HiveException("Cannot vectorize IN() - common type is " + opTi);
                }
                if (((PrimitiveTypeInfo)colTi).getPrimitiveCategory() != ((PrimitiveTypeInfo)opTi).getPrimitiveCategory()) {
                    throw new HiveException("Cannot vectorize IN() - casting a column is not supported. Column type is " + colTi + " but the common type is " + opTi);
                }
                return colTi;
            }
            commonType = returnType;
        }
        return commonType;
    }

    private List<ExprNodeDesc> getChildExpressionsWithImplicitCast(GenericUDF genericUDF, List<ExprNodeDesc> children, TypeInfo returnType) throws HiveException {
        if (VectorizationContext.isCustomUDF(genericUDF.getUdfName())) {
            return children;
        }
        if (this.isExcludedFromCast(genericUDF)) {
            return children;
        }
        if (children == null) {
            return null;
        }
        TypeInfo commonType = this.getCommonTypeForChildExpressions(genericUDF, children, returnType);
        if (commonType == null) {
            return children;
        }
        ArrayList<ExprNodeDesc> childrenWithCasts = new ArrayList<ExprNodeDesc>();
        boolean atleastOneCastNeeded = false;
        if (genericUDF instanceof GenericUDFElt) {
            int i = 0;
            for (ExprNodeDesc child : children) {
                ExprNodeDesc castExpression;
                TypeInfo castType = commonType;
                if (i++ == 0) {
                    Object object = castType = VectorizationContext.isIntFamily(child.getTypeString()) ? child.getTypeInfo() : TypeInfoFactory.intTypeInfo;
                }
                if ((castExpression = this.getImplicitCastExpression(genericUDF, child, castType)) != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(child);
            }
        } else {
            for (ExprNodeDesc child : children) {
                ExprNodeDesc castExpression = this.getImplicitCastExpression(genericUDF, child, commonType);
                if (castExpression != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(child);
            }
        }
        if (atleastOneCastNeeded) {
            return childrenWithCasts;
        }
        return children;
    }

    private boolean isExcludedFromCast(GenericUDF genericUDF) {
        boolean ret;
        boolean bl = ret = castExpressionUdfs.contains(genericUDF.getClass()) || genericUDF instanceof GenericUDFRound || genericUDF instanceof GenericUDFBetween;
        if (ret) {
            return ret;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udfClass = ((GenericUDFBridge)genericUDF).getUdfClass();
            return castExpressionUdfs.contains(udfClass) || UDFSign.class.isAssignableFrom(udfClass);
        }
        return false;
    }

    private TypeInfo updatePrecision(TypeInfo inputTypeInfo, DecimalTypeInfo returnType) {
        if (!(inputTypeInfo instanceof PrimitiveTypeInfo)) {
            return returnType;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)inputTypeInfo;
        int precision = this.getPrecisionForType(ptinfo);
        int scale = HiveDecimalUtils.getScaleForType((PrimitiveTypeInfo)ptinfo);
        return new DecimalTypeInfo(precision, scale);
    }

    private ExprNodeDesc getImplicitCastExpression(GenericUDF udf, ExprNodeDesc child, TypeInfo castType) throws HiveException {
        String castTypeString;
        TypeInfo inputTypeInfo = child.getTypeInfo();
        String inputTypeString = inputTypeInfo.getTypeName();
        if (inputTypeString.equals(castTypeString = castType.getTypeName())) {
            return null;
        }
        boolean inputTypeDecimal = false;
        boolean castTypeDecimal = false;
        if (decimalTypePattern.matcher(inputTypeString).matches()) {
            inputTypeDecimal = true;
        }
        if (decimalTypePattern.matcher(castTypeString).matches()) {
            castTypeDecimal = true;
        }
        if (castTypeDecimal && !inputTypeDecimal) {
            if (this.needsImplicitCastForDecimal(udf)) {
                castType = this.updatePrecision(inputTypeInfo, (DecimalTypeInfo)castType);
                GenericUDFToDecimal castToDecimalUDF = new GenericUDFToDecimal();
                castToDecimalUDF.setTypeInfo(castType);
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                children.add(child);
                ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, (GenericUDF)castToDecimalUDF, children);
                return desc;
            }
        } else if (!castTypeDecimal && inputTypeDecimal) {
            if (this.needsImplicitCastForDecimal(udf)) {
                GenericUDF genericUdf = this.getGenericUDFForCast(castType);
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                children.add(child);
                ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, genericUdf, children);
                return desc;
            }
        } else if (udf instanceof GenericUDFCoalesce || udf instanceof GenericUDFNvl || udf instanceof GenericUDFElt) {
            GenericUDF genericUdf = this.getGenericUDFForCast(castType);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(child);
            ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc(castType, genericUdf, children);
            return desc;
        }
        return null;
    }

    private int getPrecisionForType(PrimitiveTypeInfo typeInfo) {
        if (VectorizationContext.isFloatFamily(typeInfo.getTypeName())) {
            return 38;
        }
        return HiveDecimalUtils.getPrecisionForType((PrimitiveTypeInfo)typeInfo);
    }

    private GenericUDF getGenericUDFForCast(TypeInfo castType) throws HiveException {
        UDF udfClass = null;
        GenericUDF genericUdf = null;
        switch (((PrimitiveTypeInfo)castType).getPrimitiveCategory()) {
            case BYTE: {
                udfClass = new UDFToByte();
                break;
            }
            case SHORT: {
                udfClass = new UDFToShort();
                break;
            }
            case INT: {
                udfClass = new UDFToInteger();
                break;
            }
            case LONG: {
                udfClass = new UDFToLong();
                break;
            }
            case FLOAT: {
                udfClass = new UDFToFloat();
                break;
            }
            case DOUBLE: {
                udfClass = new UDFToDouble();
                break;
            }
            case STRING: {
                udfClass = new UDFToString();
                break;
            }
            case CHAR: {
                genericUdf = new GenericUDFToChar();
                break;
            }
            case VARCHAR: {
                genericUdf = new GenericUDFToVarchar();
                break;
            }
            case BOOLEAN: {
                udfClass = new UDFToBoolean();
                break;
            }
            case DATE: {
                genericUdf = new GenericUDFToDate();
                break;
            }
            case TIMESTAMP: {
                genericUdf = new GenericUDFTimestamp();
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                genericUdf = new GenericUDFToIntervalYearMonth();
                break;
            }
            case INTERVAL_DAY_TIME: {
                genericUdf = new GenericUDFToIntervalDayTime();
                break;
            }
            case BINARY: {
                genericUdf = new GenericUDFToBinary();
                break;
            }
            case DECIMAL: {
                genericUdf = new GenericUDFToDecimal();
                break;
            }
        }
        if (genericUdf == null) {
            if (udfClass == null) {
                throw new HiveException("Could not add implicit cast for type " + castType.getTypeName());
            }
            genericUdf = new GenericUDFBridge();
            ((GenericUDFBridge)genericUdf).setUdfClassName(udfClass.getClass().getName());
        }
        if (genericUdf instanceof SettableUDF) {
            ((SettableUDF)((Object)genericUdf)).setTypeInfo(castType);
        }
        return genericUdf;
    }

    public static boolean isNonVectorizedPathUDF(ExprNodeGenericFuncDesc expr, VectorExpressionDescriptor.Mode mode) {
        GenericUDF gudf = expr.getGenericUDF();
        if (gudf instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)gudf;
            Class<? extends UDF> udfClass = bridge.getUdfClass();
            if (udfClass.equals(UDFHex.class) || udfClass.equals(UDFRegExpExtract.class) || udfClass.equals(UDFRegExpReplace.class) || udfClass.equals(UDFConv.class) || udfClass.equals(UDFFromUnixTime.class) && VectorizationContext.isIntFamily(VectorizationContext.arg0Type(expr)) || VectorizationContext.isCastToIntFamily(udfClass) && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr)) || VectorizationContext.isCastToFloatFamily(udfClass) && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr)) || udfClass.equals(UDFToString.class) && (VectorizationContext.arg0Type(expr).equals("timestamp") || VectorizationContext.arg0Type(expr).equals("double") || VectorizationContext.arg0Type(expr).equals("float"))) {
                return true;
            }
        } else {
            if (gudf instanceof GenericUDFTimestamp && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr)) || gudf instanceof GenericUDFCase || gudf instanceof GenericUDFWhen) {
                return true;
            }
            if (gudf instanceof GenericUDFToChar && (VectorizationContext.arg0Type(expr).equals("timestamp") || VectorizationContext.arg0Type(expr).equals("double") || VectorizationContext.arg0Type(expr).equals("float"))) {
                return true;
            }
            if (gudf instanceof GenericUDFToVarchar && (VectorizationContext.arg0Type(expr).equals("timestamp") || VectorizationContext.arg0Type(expr).equals("double") || VectorizationContext.arg0Type(expr).equals("float"))) {
                return true;
            }
            if (gudf instanceof GenericUDFBetween && mode == VectorExpressionDescriptor.Mode.PROJECTION) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCastToIntFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToByte.class) || udfClass.equals(UDFToShort.class) || udfClass.equals(UDFToInteger.class) || udfClass.equals(UDFToLong.class);
    }

    public static boolean isCastToFloatFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToDouble.class) || udfClass.equals(UDFToFloat.class);
    }

    public static String arg0Type(ExprNodeGenericFuncDesc expr) {
        String type = expr.getChildren().get(0).getTypeString();
        return type;
    }

    public static boolean isCustomUDF(ExprNodeGenericFuncDesc expr) {
        return VectorizationContext.isCustomUDF(expr.getFuncText());
    }

    private static boolean isCustomUDF(String udfName) {
        FunctionInfo funcInfo;
        if (udfName == null) {
            return false;
        }
        try {
            funcInfo = FunctionRegistry.getFunctionInfo(udfName);
        }
        catch (SemanticException e) {
            LOG.warn("Failed to load " + udfName, (Throwable)e);
            funcInfo = null;
        }
        if (funcInfo == null) {
            return false;
        }
        boolean isNativeFunc = funcInfo.isNative();
        return !isNativeFunc;
    }

    ExprNodeDesc evaluateCastOnConstants(ExprNodeDesc exprDesc) throws HiveException {
        if (!(exprDesc instanceof ExprNodeGenericFuncDesc)) {
            return exprDesc;
        }
        if (exprDesc.getChildren() == null || exprDesc.getChildren().size() != 1) {
            return exprDesc;
        }
        ExprNodeConstantDesc foldedChild = null;
        if (!(exprDesc.getChildren().get(0) instanceof ExprNodeConstantDesc)) {
            ExprNodeDesc expr = this.evaluateCastOnConstants(exprDesc.getChildren().get(0));
            if (expr instanceof ExprNodeConstantDesc) {
                foldedChild = (ExprNodeConstantDesc)expr;
            }
        } else {
            foldedChild = (ExprNodeConstantDesc)exprDesc.getChildren().get(0);
        }
        if (foldedChild == null) {
            return exprDesc;
        }
        ConstantObjectInspector childoi = foldedChild.getWritableObjectInspector();
        GenericUDF gudf = ((ExprNodeGenericFuncDesc)exprDesc).getGenericUDF();
        if (gudf instanceof GenericUDFOPNegative || gudf instanceof GenericUDFOPPositive || castExpressionUdfs.contains(gudf.getClass()) || gudf instanceof GenericUDFBridge && castExpressionUdfs.contains(((GenericUDFBridge)gudf).getUdfClass())) {
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(exprDesc);
            ObjectInspector output = evaluator.initialize((ObjectInspector)childoi);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
            return new ExprNodeConstantDesc(exprDesc.getTypeInfo(), java);
        }
        return exprDesc;
    }

    private List<ExprNodeDesc> evaluateCastOnConstants(List<ExprNodeDesc> childExpr) throws HiveException {
        ArrayList<ExprNodeDesc> evaluatedChildren = new ArrayList<ExprNodeDesc>();
        if (childExpr != null) {
            for (ExprNodeDesc expr : childExpr) {
                expr = this.evaluateCastOnConstants(expr);
                evaluatedChildren.add(expr);
            }
        }
        return evaluatedChildren;
    }

    private VectorExpression getConstantVectorExpression(Object constantValue, TypeInfo typeInfo, VectorExpressionDescriptor.Mode mode) throws HiveException {
        String typeName = typeInfo.getTypeName();
        VectorExpressionDescriptor.ArgumentType vectorArgType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(typeName);
        if (vectorArgType == VectorExpressionDescriptor.ArgumentType.NONE) {
            throw new HiveException("No vector argument type for type name " + typeName);
        }
        int outCol = -1;
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            outCol = this.ocm.allocateOutputColumn(typeInfo);
        }
        if (constantValue == null) {
            return new ConstantVectorExpression(outCol, typeName, true);
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            if (mode == VectorExpressionDescriptor.Mode.FILTER) {
                if (((Boolean)constantValue).booleanValue()) {
                    return new FilterConstantBooleanVectorExpression(1L);
                }
                return new FilterConstantBooleanVectorExpression(0L);
            }
            if (((Boolean)constantValue).booleanValue()) {
                return new ConstantVectorExpression(outCol, 1L);
            }
            return new ConstantVectorExpression(outCol, 0L);
        }
        switch (vectorArgType) {
            case INT_FAMILY: {
                return new ConstantVectorExpression(outCol, ((Number)constantValue).longValue());
            }
            case DATE: {
                return new ConstantVectorExpression(outCol, DateWritable.dateToDays((Date)((Date)constantValue)));
            }
            case TIMESTAMP: {
                return new ConstantVectorExpression(outCol, (Timestamp)constantValue);
            }
            case INTERVAL_YEAR_MONTH: {
                return new ConstantVectorExpression(outCol, ((HiveIntervalYearMonth)constantValue).getTotalMonths());
            }
            case INTERVAL_DAY_TIME: {
                return new ConstantVectorExpression(outCol, (HiveIntervalDayTime)constantValue);
            }
            case FLOAT_FAMILY: {
                return new ConstantVectorExpression(outCol, ((Number)constantValue).doubleValue());
            }
            case DECIMAL: {
                return new ConstantVectorExpression(outCol, (HiveDecimal)constantValue, typeName);
            }
            case STRING: {
                return new ConstantVectorExpression(outCol, ((String)constantValue).getBytes());
            }
            case CHAR: {
                return new ConstantVectorExpression(outCol, (HiveChar)constantValue, typeName);
            }
            case VARCHAR: {
                return new ConstantVectorExpression(outCol, (HiveVarchar)constantValue, typeName);
            }
        }
        throw new HiveException("Unsupported constant type: " + typeName + ", object class " + constantValue.getClass().getSimpleName());
    }

    private VectorExpression getDynamicValueVectorExpression(ExprNodeDynamicValueDesc dynamicValueExpr, VectorExpressionDescriptor.Mode mode) throws HiveException {
        String typeName = dynamicValueExpr.getTypeInfo().getTypeName();
        VectorExpressionDescriptor.ArgumentType vectorArgType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(typeName);
        if (vectorArgType == VectorExpressionDescriptor.ArgumentType.NONE) {
            throw new HiveException("No vector argument type for type name " + typeName);
        }
        int outCol = -1;
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            outCol = this.ocm.allocateOutputColumn(dynamicValueExpr.getTypeInfo());
        }
        return new DynamicValueVectorExpression(outCol, dynamicValueExpr.getTypeInfo(), dynamicValueExpr.getDynamicValue());
    }

    private VectorExpression getIdentityExpression(List<ExprNodeDesc> childExprList) throws HiveException {
        String colType;
        int inputCol;
        ExprNodeDesc childExpr = childExprList.get(0);
        VectorExpression v1 = null;
        if (childExpr instanceof ExprNodeGenericFuncDesc) {
            v1 = this.getVectorExpression(childExpr);
            inputCol = v1.getOutputColumn();
            colType = v1.getOutputType();
        } else if (childExpr instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)childExpr;
            inputCol = this.getInputColumnIndex(colDesc.getColumn());
            colType = colDesc.getTypeString();
        } else {
            throw new HiveException("Expression not supported: " + childExpr);
        }
        IdentityExpression expr = new IdentityExpression(inputCol, colType);
        if (v1 != null) {
            expr.setChildExpressions(new VectorExpression[]{v1});
        }
        return expr;
    }

    private VectorExpression getVectorExpressionForUdf(GenericUDF genericeUdf, Class<?> udfClass, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        int numChildren;
        int n = numChildren = childExpr == null ? 0 : childExpr.size();
        if (numChildren > 2 && genericeUdf != null && mode == VectorExpressionDescriptor.Mode.FILTER && (genericeUdf instanceof GenericUDFOPOr || genericeUdf instanceof GenericUDFOPAnd)) {
            Class vclass;
            for (int i = 0; i < numChildren; ++i) {
                ExprNodeDesc child = childExpr.get(i);
                String childTypeString = child.getTypeString();
                if (childTypeString == null) {
                    throw new HiveException("Null child type name string");
                }
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)childTypeString);
                ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
                if (columnVectorType != ColumnVector.Type.LONG) {
                    return null;
                }
                if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeColumnDesc) continue;
                return null;
            }
            if (genericeUdf instanceof GenericUDFOPOr) {
                vclass = FilterExprOrExpr.class;
            } else if (genericeUdf instanceof GenericUDFOPAnd) {
                vclass = FilterExprAndExpr.class;
            } else {
                throw new RuntimeException("Unexpected multi-child UDF");
            }
            VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udfClass);
            return this.createVectorExpression(vclass, childExpr, childrenMode, returnType);
        }
        if (numChildren > 3) {
            return null;
        }
        VectorExpressionDescriptor.Builder builder = new VectorExpressionDescriptor.Builder();
        builder.setNumArguments(numChildren);
        builder.setMode(mode);
        for (int i = 0; i < numChildren; ++i) {
            ExprNodeDesc child = childExpr.get(i);
            String childTypeString = child.getTypeString();
            if (childTypeString == null) {
                throw new HiveException("Null child type name string");
            }
            String undecoratedTypeName = VectorizationContext.getUndecoratedName(childTypeString);
            if (undecoratedTypeName == null) {
                throw new HiveException("No match for type string " + childTypeString + " from undecorated type name method");
            }
            builder.setArgumentType(i, undecoratedTypeName);
            if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeColumnDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.COLUMN);
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.SCALAR);
                continue;
            }
            if (child instanceof ExprNodeDynamicValueDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.DYNAMICVALUE);
                continue;
            }
            throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
        }
        VectorExpressionDescriptor.Descriptor descriptor = builder.build();
        Class<?> vclass = this.vMap.getVectorExpressionClass(udfClass, descriptor);
        if (vclass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No vector udf found for " + udfClass.getSimpleName() + ", descriptor: " + descriptor);
            }
            return null;
        }
        VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udfClass);
        return this.createVectorExpression(vclass, childExpr, childrenMode, returnType);
    }

    private VectorExpression createVectorExpression(Class<?> vectorClass, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode childrenMode, TypeInfo returnType) throws HiveException {
        int numChildren = childExpr == null ? 0 : childExpr.size();
        VectorExpression.Type[] inputTypes = new VectorExpression.Type[numChildren];
        ArrayList<VectorExpression> children = new ArrayList<VectorExpression>();
        Object[] arguments = new Object[numChildren];
        try {
            for (int i = 0; i < numChildren; ++i) {
                ExprNodeDesc child = childExpr.get(i);
                String undecoratedName = VectorizationContext.getUndecoratedName(child.getTypeInfo().getTypeName());
                inputTypes[i] = VectorExpression.Type.getValue(undecoratedName);
                if (inputTypes[i] == VectorExpression.Type.OTHER) {
                    throw new HiveException("No vector type for " + vectorClass.getSimpleName() + " argument #" + i + " type name " + undecoratedName);
                }
                if (child instanceof ExprNodeGenericFuncDesc) {
                    VectorExpression vChild = this.getVectorExpression(child, childrenMode);
                    children.add(vChild);
                    arguments[i] = vChild.getOutputColumn();
                    continue;
                }
                if (child instanceof ExprNodeColumnDesc) {
                    int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)child);
                    if (childrenMode == VectorExpressionDescriptor.Mode.FILTER) {
                        children.add(new SelectColumnIsTrue(colIndex));
                    }
                    arguments[i] = colIndex;
                    continue;
                }
                if (child instanceof ExprNodeConstantDesc) {
                    Object scalarValue = this.getVectorTypeScalarValue((ExprNodeConstantDesc)child);
                    arguments[i] = null == scalarValue ? this.getConstantVectorExpression(null, child.getTypeInfo(), childrenMode) : scalarValue;
                    continue;
                }
                if (child instanceof ExprNodeDynamicValueDesc) {
                    arguments[i] = ((ExprNodeDynamicValueDesc)child).getDynamicValue();
                    continue;
                }
                throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
            }
            VectorExpression vectorExpression = this.instantiateExpression(vectorClass, returnType, arguments);
            vectorExpression.setInputTypes(inputTypes);
            if (vectorExpression != null && !children.isEmpty()) {
                vectorExpression.setChildExpressions(children.toArray(new VectorExpression[0]));
            }
            VectorExpression vectorExpression2 = vectorExpression;
            return vectorExpression2;
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
        finally {
            for (VectorExpression ve : children) {
                this.ocm.freeOutputColumn(ve.getOutputColumn());
            }
        }
    }

    private VectorExpressionDescriptor.Mode getChildrenMode(VectorExpressionDescriptor.Mode mode, Class<?> udf) {
        if (mode.equals((Object)VectorExpressionDescriptor.Mode.FILTER) && (udf.equals(GenericUDFOPAnd.class) || udf.equals(GenericUDFOPOr.class))) {
            return VectorExpressionDescriptor.Mode.FILTER;
        }
        return VectorExpressionDescriptor.Mode.PROJECTION;
    }

    private String getNewInstanceArgumentString(Object[] args) {
        if (args == null) {
            return "arguments: NULL";
        }
        ArrayList<String> argClasses = new ArrayList<String>();
        for (Object obj : args) {
            argClasses.add(obj.getClass().getSimpleName());
        }
        return "arguments: " + Arrays.toString(args) + ", argument classes: " + argClasses.toString();
    }

    public static String getStackTraceAsSingleLine(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e);
        sb.append(" stack trace: ");
        StackTraceElement[] stackTrace = e.getStackTrace();
        int length = stackTrace.length;
        boolean isTruncated = false;
        if (length > 15) {
            length = 15;
            isTruncated = true;
        }
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(stackTrace[i]);
        }
        if (isTruncated) {
            sb.append(", ...");
        }
        String cleaned = sb.toString().replaceAll("GeneratedConstructorAccessor[0-9]*", "GeneratedConstructorAccessor<omitted>");
        return cleaned;
    }

    private VectorExpression instantiateExpression(Class<?> vclass, TypeInfo returnType, Object ... args) throws HiveException {
        int argsLength;
        VectorExpression ve = null;
        Constructor<?> ctor = this.getConstructor(vclass);
        int numParams = ctor.getParameterTypes().length;
        int n = argsLength = args == null ? 0 : args.length;
        if (numParams == 0) {
            try {
                ve = (VectorExpression)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with 0 arguments, exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (numParams == argsLength) {
            try {
                ve = (VectorExpression)ctor.newInstance(args);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with " + this.getNewInstanceArgumentString(args) + ", exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (numParams == argsLength + 1) {
            Object[] newArgs = null;
            try {
                String returnTypeName;
                if (returnType == null) {
                    returnTypeName = ((VectorExpression)vclass.newInstance()).getOutputType().toLowerCase();
                    if (returnTypeName.equals("long")) {
                        returnTypeName = "bigint";
                    }
                    returnType = TypeInfoUtils.getTypeInfoFromTypeString((String)returnTypeName);
                } else {
                    returnTypeName = returnType.getTypeName();
                }
                int outputCol = this.ocm.allocateOutputColumn(returnType);
                newArgs = Arrays.copyOf(args, numParams);
                newArgs[numParams - 1] = outputCol;
                ve = (VectorExpression)ctor.newInstance(newArgs);
                ve.setOutputType(returnTypeName);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with arguments " + this.getNewInstanceArgumentString(newArgs) + ", exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (ve instanceof TruncStringOutput) {
            TruncStringOutput truncStringOutput = (TruncStringOutput)((Object)ve);
            if (returnType instanceof BaseCharTypeInfo) {
                BaseCharTypeInfo baseCharTypeInfo = (BaseCharTypeInfo)returnType;
                truncStringOutput.setMaxLength(baseCharTypeInfo.getLength());
            }
        }
        return ve;
    }

    private VectorExpression getGenericUdfVectorExpression(GenericUDF udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        List<ExprNodeDesc> castedChildren = this.evaluateCastOnConstants(childExpr);
        childExpr = castedChildren;
        VectorExpression ve = null;
        if (udf instanceof GenericUDFBetween && mode == VectorExpressionDescriptor.Mode.FILTER) {
            ve = this.getBetweenFilterExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFIn) {
            ve = this.getInExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFWhen) {
            ve = this.getWhenExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFOPPositive) {
            ve = this.getIdentityExpression(childExpr);
        } else if (udf instanceof GenericUDFCoalesce || udf instanceof GenericUDFNvl) {
            ve = this.getCoalesceExpression(childExpr, returnType);
        } else if (udf instanceof GenericUDFElt) {
            ve = this.getEltExpression(childExpr, returnType);
        } else if (udf instanceof GenericUDFBridge) {
            ve = this.getGenericUDFBridgeVectorExpression((GenericUDFBridge)udf, childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFToDecimal) {
            ve = this.getCastToDecimal(childExpr, returnType);
        } else if (udf instanceof GenericUDFToChar) {
            ve = this.getCastToChar(childExpr, returnType);
        } else if (udf instanceof GenericUDFToVarchar) {
            ve = this.getCastToVarChar(childExpr, returnType);
        } else if (udf instanceof GenericUDFTimestamp) {
            ve = this.getCastToTimestamp((GenericUDFTimestamp)udf, childExpr, mode, returnType);
        }
        if (ve != null) {
            return ve;
        }
        Class<Object> udfClass = udf.getClass();
        boolean isSubstituted = false;
        if (udf instanceof GenericUDFBridge) {
            udfClass = ((GenericUDFBridge)udf).getUdfClass();
            isSubstituted = true;
        }
        ve = this.getVectorExpressionForUdf(!isSubstituted ? udf : null, udfClass, castedChildren, mode, returnType);
        return ve;
    }

    private VectorExpression getCastToTimestamp(GenericUDFTimestamp udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        VectorExpression ve = this.getVectorExpressionForUdf(udf, udf.getClass(), childExpr, mode, returnType);
        if (!udf.isIntToTimestampInSeconds() && ve instanceof CastLongToTimestamp) {
            ve = this.createVectorExpression(CastMillisecondsLongToTimestamp.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        return ve;
    }

    private void freeNonColumns(VectorExpression[] vectorChildren) {
        if (vectorChildren == null) {
            return;
        }
        for (VectorExpression v : vectorChildren) {
            if (v instanceof IdentityExpression) continue;
            this.ocm.freeOutputColumn(v.getOutputColumn());
        }
    }

    private VectorExpression getCoalesceExpression(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        int[] inputColumns = new int[childExpr.size()];
        VectorExpression[] vectorChildren = this.getVectorExpressions(childExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        int i = 0;
        for (VectorExpression ve : vectorChildren) {
            inputColumns[i++] = ve.getOutputColumn();
        }
        int outColumn = this.ocm.allocateOutputColumn(returnType);
        VectorCoalesce vectorCoalesce = new VectorCoalesce(inputColumns, outColumn);
        vectorCoalesce.setOutputType(returnType.getTypeName());
        vectorCoalesce.setChildExpressions(vectorChildren);
        this.freeNonColumns(vectorChildren);
        return vectorCoalesce;
    }

    private VectorExpression getEltExpression(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        int[] inputColumns = new int[childExpr.size()];
        VectorExpression[] vectorChildren = this.getVectorExpressions(childExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        int i = 0;
        for (VectorExpression ve : vectorChildren) {
            inputColumns[i++] = ve.getOutputColumn();
        }
        int outColumn = this.ocm.allocateOutputColumn(returnType);
        VectorElt vectorElt = new VectorElt(inputColumns, outColumn);
        vectorElt.setOutputType(returnType.getTypeName());
        vectorElt.setChildExpressions(vectorChildren);
        this.freeNonColumns(vectorChildren);
        return vectorElt;
    }

    public static InConstantType getInConstantTypeFromPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case BOOLEAN: {
                return InConstantType.INT_FAMILY;
            }
            case DATE: {
                return InConstantType.TIMESTAMP;
            }
            case TIMESTAMP: {
                return InConstantType.DATE;
            }
            case FLOAT: 
            case DOUBLE: {
                return InConstantType.FLOAT_FAMILY;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: {
                return InConstantType.STRING_FAMILY;
            }
            case DECIMAL: {
                return InConstantType.DECIMAL;
            }
        }
        throw new RuntimeException("Unexpected primitive type category " + primitiveCategory);
    }

    private VectorExpression getStructInExpression(List<ExprNodeDesc> childExpr, ExprNodeDesc colExpr, TypeInfo colTypeInfo, List<ExprNodeDesc> inChildren, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        VectorExpression expr = null;
        StructTypeInfo structTypeInfo = (StructTypeInfo)colTypeInfo;
        ArrayList fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        int fieldCount = fieldTypeInfos.size();
        ColumnVector.Type[] fieldVectorColumnTypes = new ColumnVector.Type[fieldCount];
        InConstantType[] fieldInConstantTypes = new InConstantType[fieldCount];
        for (int f = 0; f < fieldCount; ++f) {
            InConstantType inConstantType;
            ColumnVector.Type fieldVectorColumnType;
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(f);
            if (fieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                return null;
            }
            fieldVectorColumnTypes[f] = fieldVectorColumnType = VectorizationContext.getColumnVectorTypeFromTypeInfo(fieldTypeInfo);
            PrimitiveObjectInspector.PrimitiveCategory fieldPrimitiveCategory = ((PrimitiveTypeInfo)fieldTypeInfo).getPrimitiveCategory();
            fieldInConstantTypes[f] = inConstantType = VectorizationContext.getInConstantTypeFromPrimitiveCategory(fieldPrimitiveCategory);
        }
        ByteStream.Output buffer = new ByteStream.Output();
        BinarySortableSerializeWrite binarySortableSerializeWrite = new BinarySortableSerializeWrite(fieldCount);
        int inChildrenCount = inChildren.size();
        byte[][] serializedInChildren = new byte[inChildrenCount][];
        try {
            for (int i = 0; i < inChildrenCount; ++i) {
                Object[] constants;
                ExprNodeDesc node = inChildren.get(i);
                if (node instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc constNode = (ExprNodeConstantDesc)node;
                    ConstantObjectInspector output = constNode.getWritableObjectInspector();
                    constants = ((List)output.getWritableConstantValue()).toArray();
                } else {
                    ExprNodeGenericFuncDesc exprNode = (ExprNodeGenericFuncDesc)node;
                    ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(exprNode);
                    ObjectInspector output = evaluator.initialize(exprNode.getWritableObjectInspector());
                    constants = (Object[])evaluator.evaluate(null);
                }
                binarySortableSerializeWrite.set(buffer);
                block9: for (int f = 0; f < fieldCount; ++f) {
                    Object constant = constants[f];
                    if (constant == null) {
                        binarySortableSerializeWrite.writeNull();
                        continue;
                    }
                    InConstantType inConstantType = fieldInConstantTypes[f];
                    switch (inConstantType) {
                        case STRING_FAMILY: {
                            if (constant instanceof Text) {
                                Text text = (Text)constant;
                                byte[] bytes = text.getBytes();
                                binarySortableSerializeWrite.writeString(bytes, 0, text.getLength());
                                continue block9;
                            }
                            throw new HiveException("Unexpected constant String type " + constant.getClass().getSimpleName());
                        }
                        case INT_FAMILY: {
                            long value;
                            if (constant instanceof IntWritable) {
                                value = ((IntWritable)constant).get();
                            } else if (constant instanceof LongWritable) {
                                value = ((LongWritable)constant).get();
                            } else {
                                throw new HiveException("Unexpected constant Long type " + constant.getClass().getSimpleName());
                            }
                            binarySortableSerializeWrite.writeLong(value);
                            continue block9;
                        }
                        case FLOAT_FAMILY: {
                            if (!(constant instanceof DoubleWritable)) {
                                throw new HiveException("Unexpected constant Double type " + constant.getClass().getSimpleName());
                            }
                            double value = ((DoubleWritable)constant).get();
                            binarySortableSerializeWrite.writeDouble(value);
                            continue block9;
                        }
                        default: {
                            throw new RuntimeException("Unexpected IN constant type " + inConstantType.name());
                        }
                    }
                }
                serializedInChildren[i] = Arrays.copyOfRange(buffer.getData(), 0, buffer.getLength());
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        int scratchBytesCol = this.ocm.allocateOutputColumn((TypeInfo)TypeInfoFactory.stringTypeInfo);
        Class cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterStructColumnInList.class : StructColumnInList.class;
        expr = this.createVectorExpression(cl, null, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        ((IStringInExpr)((Object)expr)).setInListValues(serializedInChildren);
        ((IStructInExpr)((Object)expr)).setScratchBytesColumn(scratchBytesCol);
        ((IStructInExpr)((Object)expr)).setStructColumnExprs(this, colExpr.getChildren(), fieldVectorColumnTypes);
        return expr;
    }

    private VectorExpression getInExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        Object[] inValsD;
        Object inVals;
        ExprNodeDesc colExpr = childExpr.get(0);
        List<ExprNodeDesc> inChildren = childExpr.subList(1, childExpr.size());
        String colType = colExpr.getTypeString();
        TypeInfo colTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)(colType = VectorizationContext.mapTypeNameSynonyms(colType)));
        ObjectInspector.Category category = colTypeInfo.getCategory();
        if (category == ObjectInspector.Category.STRUCT) {
            return this.getStructInExpression(childExpr, colExpr, colTypeInfo, inChildren, mode, returnType);
        }
        if (category != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        List<ExprNodeDesc> childrenForInList = this.evaluateCastOnConstants(inChildren);
        VectorExpression expr = null;
        for (ExprNodeDesc inListChild : childrenForInList) {
            if (inListChild instanceof ExprNodeConstantDesc) continue;
            throw new HiveException("Vectorizing IN expression only supported for constant values");
        }
        Class cl = null;
        if (VectorizationContext.isIntFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            inVals = new long[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = this.getIntFamilyScalarAsLong((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ILongInExpr)((Object)expr)).setInListValues((long[])inVals);
        } else if (VectorizationContext.isTimestampFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterTimestampColumnInList.class : TimestampColumnInList.class;
            inVals = new Timestamp[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (long)this.getTimestampScalar(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ITimestampInExpr)((Object)expr)).setInListValues((Timestamp[])inVals);
        } else if (VectorizationContext.isStringFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterStringColumnInList.class : StringColumnInList.class;
            inVals = new byte[childrenForInList.size()][];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (long)this.getStringScalarAsByteArray((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IStringInExpr)((Object)expr)).setInListValues((byte[][])inVals);
        } else if (VectorizationContext.isFloatFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDoubleColumnInList.class : DoubleColumnInList.class;
            inValsD = new double[childrenForInList.size()];
            for (int i = 0; i != inValsD.length; ++i) {
                inValsD[i] = this.getNumericScalarAsDouble(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IDoubleInExpr)((Object)expr)).setInListValues((double[])inValsD);
        } else if (VectorizationContext.isDecimalFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDecimalColumnInList.class : DecimalColumnInList.class;
            inValsD = new HiveDecimal[childrenForInList.size()];
            for (int i = 0; i != inValsD.length; ++i) {
                inValsD[i] = (double)((HiveDecimal)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i)));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((IDecimalInExpr)((Object)expr)).setInListValues((HiveDecimal[])inValsD);
        } else if (VectorizationContext.isDateFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            inVals = new long[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (Long)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            ((ILongInExpr)((Object)expr)).setInListValues((long[])inVals);
        }
        return expr;
    }

    private byte[] getStringScalarAsByteArray(ExprNodeConstantDesc exprNodeConstantDesc) throws HiveException {
        Object o = this.getScalarValue(exprNodeConstantDesc);
        if (!(o instanceof byte[])) {
            throw new HiveException("Expected constant argument of type string");
        }
        return (byte[])o;
    }

    private PrimitiveObjectInspector.PrimitiveCategory getAnyIntegerPrimitiveCategoryFromUdfClass(Class<? extends UDF> udfClass) {
        if (udfClass.equals(UDFToByte.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.BYTE;
        }
        if (udfClass.equals(UDFToShort.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.SHORT;
        }
        if (udfClass.equals(UDFToInteger.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.INT;
        }
        if (udfClass.equals(UDFToLong.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.LONG;
        }
        throw new RuntimeException("Unexpected any integery UDF class " + udfClass.getName());
    }

    private VectorExpression getGenericUDFBridgeVectorExpression(GenericUDFBridge udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        Class<? extends UDF> cl = udf.getUdfClass();
        VectorExpression ve = null;
        if (VectorizationContext.isCastToIntFamily(cl)) {
            PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory = this.getAnyIntegerPrimitiveCategoryFromUdfClass(cl);
            ve = this.getCastToLongExpression(childExpr, integerPrimitiveCategory);
        } else if (cl.equals(UDFToBoolean.class)) {
            ve = this.getCastToBoolean(childExpr);
        } else if (VectorizationContext.isCastToFloatFamily(cl)) {
            ve = this.getCastToDoubleExpression(cl, childExpr, returnType);
        } else if (cl.equals(UDFToString.class)) {
            ve = this.getCastToString(childExpr, returnType);
        }
        if (ve == null && childExpr instanceof ExprNodeGenericFuncDesc) {
            ve = this.getCustomUDFExpression((ExprNodeGenericFuncDesc)((Object)childExpr), mode);
        }
        return ve;
    }

    private HiveDecimal castConstantToDecimal(Object scalar, TypeInfo type) throws HiveException {
        HiveDecimal rawDecimal;
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        String typename = type.getTypeName();
        switch (ptinfo.getPrimitiveCategory()) {
            case FLOAT: {
                rawDecimal = HiveDecimal.create((String)String.valueOf(scalar));
                break;
            }
            case DOUBLE: {
                rawDecimal = HiveDecimal.create((String)String.valueOf(scalar));
                break;
            }
            case BYTE: {
                rawDecimal = HiveDecimal.create((int)((Byte)scalar).byteValue());
                break;
            }
            case SHORT: {
                rawDecimal = HiveDecimal.create((int)((Short)scalar).shortValue());
                break;
            }
            case INT: {
                rawDecimal = HiveDecimal.create((int)((Integer)scalar));
                break;
            }
            case LONG: {
                rawDecimal = HiveDecimal.create((long)((Long)scalar));
                break;
            }
            case DECIMAL: {
                rawDecimal = (HiveDecimal)scalar;
                break;
            }
            default: {
                throw new HiveException("Unsupported type " + typename + " for cast to HiveDecimal");
            }
        }
        if (rawDecimal == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Casting constant scalar " + scalar + " to HiveDecimal resulted in null");
            }
            return null;
        }
        return rawDecimal;
    }

    private String castConstantToString(Object scalar, TypeInfo type) throws HiveException {
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        String typename = type.getTypeName();
        switch (ptinfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).toString();
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                return decimalVal.toString();
            }
        }
        throw new HiveException("Unsupported type " + typename + " for cast to String");
    }

    private Double castConstantToDouble(Object scalar, TypeInfo type) throws HiveException {
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        String typename = type.getTypeName();
        switch (ptinfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).doubleValue();
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                return decimalVal.doubleValue();
            }
        }
        throw new HiveException("Unsupported type " + typename + " for cast to Double");
    }

    private Long castConstantToLong(Object scalar, TypeInfo type, PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory) throws HiveException {
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        String typename = type.getTypeName();
        switch (ptinfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).longValue();
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                switch (integerPrimitiveCategory) {
                    case BYTE: {
                        if (decimalVal.isByte()) break;
                        return null;
                    }
                    case SHORT: {
                        if (decimalVal.isShort()) break;
                        return null;
                    }
                    case INT: {
                        if (decimalVal.isInt()) break;
                        return null;
                    }
                    case LONG: {
                        if (decimalVal.isLong()) break;
                        return null;
                    }
                    default: {
                        throw new RuntimeException("Unexpected integer primitive type " + integerPrimitiveCategory);
                    }
                }
                return decimalVal.longValue();
            }
        }
        throw new HiveException("Unsupported type " + typename + " for cast to Long");
    }

    private VectorExpression getCastToDecimal(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            HiveDecimal decimalValue = this.castConstantToDecimal(constantValue, child.getTypeInfo());
            return this.getConstantVectorExpression(decimalValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isFloatFamily(inputType)) {
            return this.createVectorExpression(CastDoubleToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (decimalTypePattern.matcher(inputType).matches()) {
            return this.createVectorExpression(CastDecimalToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (inputType.equals("timestamp")) {
            return this.createVectorExpression(CastTimestampToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        return null;
    }

    private VectorExpression getCastToString(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            String strValue = this.castConstantToString(constantValue, child.getTypeInfo());
            return this.getConstantVectorExpression(strValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToStringViaLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, null);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringGroupToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        return null;
    }

    private VectorExpression getCastToChar(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            return null;
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToCharViaLongToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringGroupToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        return null;
    }

    private VectorExpression getCastToVarChar(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            return null;
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToVarCharViaLongToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringGroupToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        return null;
    }

    private VectorExpression getCastToDoubleExpression(Class<?> udf, List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            Double doubleValue = this.castConstantToDouble(constantValue, child.getTypeInfo());
            return this.getConstantVectorExpression(doubleValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            if (udf.equals(UDFToFloat.class)) {
                return this.createVectorExpression(CastLongToFloatViaLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
            }
            return this.createVectorExpression(CastLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (inputType.equals("timestamp")) {
            return this.createVectorExpression(CastTimestampToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
        }
        if (VectorizationContext.isFloatFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getCastToBoolean(List<ExprNodeDesc> childExpr) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            if (null == ((ExprNodeConstantDesc)child).getValue()) {
                return this.getConstantVectorExpression(null, (TypeInfo)TypeInfoFactory.booleanTypeInfo, VectorExpressionDescriptor.Mode.PROJECTION);
            }
            return null;
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            VectorExpression lenExpr = this.createVectorExpression(StringLength.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, null);
            int outputCol = this.ocm.allocateOutputColumn((TypeInfo)TypeInfoFactory.longTypeInfo);
            CastLongToBooleanViaLongToLong lenToBoolExpr = new CastLongToBooleanViaLongToLong(lenExpr.getOutputColumn(), outputCol);
            lenToBoolExpr.setChildExpressions(new VectorExpression[]{lenExpr});
            this.ocm.freeOutputColumn(lenExpr.getOutputColumn());
            return lenToBoolExpr;
        }
        return null;
    }

    private VectorExpression getCastToLongExpression(List<ExprNodeDesc> childExpr, PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            Long longValue = this.castConstantToLong(constantValue, child.getTypeInfo(), integerPrimitiveCategory);
            return this.getConstantVectorExpression(longValue, (TypeInfo)TypeInfoFactory.longTypeInfo, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getBetweenFilterExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            return null;
        }
        boolean hasDynamicValues = false;
        if (childExpr.get(2) instanceof ExprNodeDynamicValueDesc && childExpr.get(3) instanceof ExprNodeDynamicValueDesc) {
            hasDynamicValues = true;
        } else if (!(childExpr.get(2) instanceof ExprNodeConstantDesc) || !(childExpr.get(3) instanceof ExprNodeConstantDesc)) {
            return null;
        }
        boolean notKeywordPresent = (Boolean)((ExprNodeConstantDesc)childExpr.get(0)).getValue();
        ExprNodeDesc colExpr = childExpr.get(1);
        TypeInfo commonType = FunctionRegistry.getCommonClassForComparison(childExpr.get(1).getTypeInfo(), childExpr.get(2).getTypeInfo());
        if (commonType == null) {
            return null;
        }
        if ((commonType = FunctionRegistry.getCommonClassForComparison(commonType, childExpr.get(3).getTypeInfo())) == null) {
            return null;
        }
        ArrayList<ExprNodeDesc> castChildren = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc desc : childExpr.subList(1, 4)) {
            if (commonType.equals((Object)desc.getTypeInfo())) {
                castChildren.add(desc);
                continue;
            }
            GenericUDF castUdf = this.getGenericUDFForCast(commonType);
            ExprNodeGenericFuncDesc engfd = new ExprNodeGenericFuncDesc(commonType, castUdf, Arrays.asList(desc));
            castChildren.add(engfd);
        }
        String colType = commonType.getTypeName();
        List<ExprNodeDesc> childrenAfterNot = this.evaluateCastOnConstants(castChildren);
        Class cl = null;
        if (VectorizationContext.isIntFamily(colType) && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterLongColumnBetweenDynamicValue.class : FilterLongColumnBetween.class;
        } else if (VectorizationContext.isIntFamily(colType) && notKeywordPresent) {
            cl = FilterLongColumnNotBetween.class;
        } else if (VectorizationContext.isFloatFamily(colType) && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterDoubleColumnBetweenDynamicValue.class : FilterDoubleColumnBetween.class;
        } else if (VectorizationContext.isFloatFamily(colType) && notKeywordPresent) {
            cl = FilterDoubleColumnNotBetween.class;
        } else if (colType.equals("string") && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterStringColumnBetweenDynamicValue.class : FilterStringColumnBetween.class;
        } else if (colType.equals("string") && notKeywordPresent) {
            cl = FilterStringColumnNotBetween.class;
        } else if (varcharTypePattern.matcher(colType).matches() && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterVarCharColumnBetweenDynamicValue.class : FilterVarCharColumnBetween.class;
        } else if (varcharTypePattern.matcher(colType).matches() && notKeywordPresent) {
            cl = FilterVarCharColumnNotBetween.class;
        } else if (charTypePattern.matcher(colType).matches() && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterCharColumnBetweenDynamicValue.class : FilterCharColumnBetween.class;
        } else if (charTypePattern.matcher(colType).matches() && notKeywordPresent) {
            cl = FilterCharColumnNotBetween.class;
        } else if (colType.equals("timestamp") && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterTimestampColumnBetweenDynamicValue.class : FilterTimestampColumnBetween.class;
        } else if (colType.equals("timestamp") && notKeywordPresent) {
            cl = FilterTimestampColumnNotBetween.class;
        } else if (VectorizationContext.isDecimalFamily(colType) && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterDecimalColumnBetweenDynamicValue.class : FilterDecimalColumnBetween.class;
        } else if (VectorizationContext.isDecimalFamily(colType) && notKeywordPresent) {
            cl = FilterDecimalColumnNotBetween.class;
        } else if (VectorizationContext.isDateFamily(colType) && !notKeywordPresent) {
            cl = hasDynamicValues ? FilterDateColumnBetweenDynamicValue.class : FilterLongColumnBetween.class;
        } else if (VectorizationContext.isDateFamily(colType) && notKeywordPresent) {
            cl = FilterLongColumnNotBetween.class;
        }
        return this.createVectorExpression(cl, childrenAfterNot, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
    }

    private boolean isColumnOrNonNullConst(ExprNodeDesc exprNodeDesc) {
        String typeString;
        if (exprNodeDesc instanceof ExprNodeColumnDesc) {
            return true;
        }
        return exprNodeDesc instanceof ExprNodeConstantDesc && !(typeString = exprNodeDesc.getTypeString()).equalsIgnoreCase("void");
    }

    private VectorExpression getWhenExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        if (mode != VectorExpressionDescriptor.Mode.PROJECTION) {
            return null;
        }
        if (childExpr.size() != 3) {
            return null;
        }
        ExprNodeDesc exprNodeDesc1 = childExpr.get(1);
        ExprNodeDesc exprNodeDesc2 = childExpr.get(2);
        if (this.isColumnOrNonNullConst(exprNodeDesc1) && this.isColumnOrNonNullConst(exprNodeDesc2)) {
            GenericUDFIf genericUDFIf = new GenericUDFIf();
            return this.getVectorExpressionForUdf(genericUDFIf, GenericUDFIf.class, childExpr, mode, returnType);
        }
        return null;
    }

    private VectorExpression getCustomUDFExpression(ExprNodeGenericFuncDesc expr, VectorExpressionDescriptor.Mode mode) throws HiveException {
        boolean isFilter = false;
        if (mode == VectorExpressionDescriptor.Mode.FILTER) {
            TypeInfo resultTypeInfo = expr.getTypeInfo();
            if (resultTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)resultTypeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                isFilter = true;
            } else {
                return null;
            }
        }
        List<ExprNodeDesc> childExprList = expr.getChildren();
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[expr.getChildren().size()];
        for (int i = 0; i < argDescs.length; ++i) {
            argDescs[i] = new VectorUDFArgDesc();
        }
        ArrayList<Integer> variableArgPositions = new ArrayList<Integer>();
        ArrayList<Integer> exprResultColumnNums = new ArrayList<Integer>();
        ArrayList<VectorExpression> vectorExprs = new ArrayList<VectorExpression>();
        for (int i = 0; i < childExprList.size(); ++i) {
            VectorExpression e;
            ExprNodeDesc child = childExprList.get(i);
            if (child instanceof ExprNodeGenericFuncDesc) {
                e = this.getVectorExpression(child, VectorExpressionDescriptor.Mode.PROJECTION);
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumn());
                argDescs[i].setVariable(e.getOutputColumn());
                continue;
            }
            if (child instanceof ExprNodeColumnDesc) {
                variableArgPositions.add(i);
                argDescs[i].setVariable(this.getInputColumnIndex(((ExprNodeColumnDesc)child).getColumn()));
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                argDescs[i].setConstant((ExprNodeConstantDesc)child);
                continue;
            }
            if (child instanceof ExprNodeDynamicValueDesc) {
                e = this.getVectorExpression(child, VectorExpressionDescriptor.Mode.PROJECTION);
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumn());
                argDescs[i].setVariable(e.getOutputColumn());
                continue;
            }
            throw new HiveException("Unable to vectorize custom UDF. Encountered unsupported expr desc : " + child);
        }
        int outputCol = -1;
        String resultTypeName = expr.getTypeInfo().getTypeName();
        outputCol = this.ocm.allocateOutputColumn(expr.getTypeInfo());
        VectorUDFAdaptor ve = new VectorUDFAdaptor(expr, outputCol, resultTypeName, argDescs);
        VectorExpression[] childVEs = null;
        if (exprResultColumnNums.size() != 0) {
            childVEs = new VectorExpression[exprResultColumnNums.size()];
            for (int i = 0; i < childVEs.length; ++i) {
                childVEs[i] = (VectorExpression)vectorExprs.get(i);
            }
        }
        ve.setChildExpressions(childVEs);
        for (Integer i : exprResultColumnNums) {
            this.ocm.freeOutputColumn(i);
        }
        if (isFilter) {
            SelectColumnIsTrue filterVectorExpr = new SelectColumnIsTrue(outputCol);
            filterVectorExpr.setChildExpressions(new VectorExpression[]{ve});
            return filterVectorExpr;
        }
        return ve;
    }

    public static boolean isStringFamily(String resultType) {
        return resultType.equalsIgnoreCase("string") || charVarcharTypePattern.matcher(resultType).matches() || resultType.equalsIgnoreCase("string_family");
    }

    public static boolean isDatetimeFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp") || resultType.equalsIgnoreCase("date");
    }

    public static boolean isTimestampFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp");
    }

    public static boolean isDateFamily(String resultType) {
        return resultType.equalsIgnoreCase("date");
    }

    public static boolean isIntervalYearMonthFamily(String resultType) {
        return resultType.equalsIgnoreCase("interval_year_month");
    }

    public static boolean isIntervalDayTimeFamily(String resultType) {
        return resultType.equalsIgnoreCase("interval_day_time");
    }

    public static boolean isFloatFamily(String resultType) {
        return resultType.equalsIgnoreCase("double") || resultType.equalsIgnoreCase("float");
    }

    public static boolean isIntFamily(String resultType) {
        return resultType.equalsIgnoreCase("tinyint") || resultType.equalsIgnoreCase("smallint") || resultType.equalsIgnoreCase("int") || resultType.equalsIgnoreCase("bigint") || resultType.equalsIgnoreCase("boolean") || resultType.equalsIgnoreCase("long");
    }

    public static boolean isDecimalFamily(String colType) {
        return decimalTypePattern.matcher(colType).matches();
    }

    private Object getScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        if (constDesc.getTypeString().equalsIgnoreCase("String")) {
            try {
                byte[] bytes = ((String)constDesc.getValue()).getBytes("UTF-8");
                return bytes;
            }
            catch (Exception ex) {
                throw new HiveException(ex);
            }
        }
        if (constDesc.getTypeString().equalsIgnoreCase("boolean")) {
            if (constDesc.getValue().equals(true)) {
                return 1;
            }
            return 0;
        }
        if (decimalTypePattern.matcher(constDesc.getTypeString()).matches()) {
            return constDesc.getValue();
        }
        return constDesc.getValue();
    }

    private long getIntFamilyScalarAsLong(ExprNodeConstantDesc constDesc) throws HiveException {
        Object o = this.getScalarValue(constDesc);
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new HiveException("Unexpected type when converting to long : " + o.getClass().getSimpleName());
    }

    private double getNumericScalarAsDouble(ExprNodeDesc constDesc) throws HiveException {
        Object o = this.getScalarValue((ExprNodeConstantDesc)constDesc);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        throw new HiveException("Unexpected type when converting to double");
    }

    private Object getVectorTypeScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        String t = constDesc.getTypeInfo().getTypeName();
        VectorExpression.Type type = VectorExpression.Type.getValue(t);
        Object scalarValue = this.getScalarValue(constDesc);
        switch (type) {
            case DATE: {
                return new Long(DateWritable.dateToDays((Date)((Date)scalarValue)));
            }
            case INTERVAL_YEAR_MONTH: {
                return ((HiveIntervalYearMonth)scalarValue).getTotalMonths();
            }
        }
        return scalarValue;
    }

    private Timestamp getTimestampScalar(ExprNodeDesc expr) throws HiveException {
        if (expr instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)expr).getGenericUDF() instanceof GenericUDFTimestamp) {
            return this.evaluateCastToTimestamp(expr);
        }
        if (!(expr instanceof ExprNodeConstantDesc)) {
            throw new HiveException("Constant timestamp value expected for expression argument. Non-constant argument not supported for vectorization.");
        }
        ExprNodeConstantDesc constExpr = (ExprNodeConstantDesc)expr;
        String constTypeString = constExpr.getTypeString();
        if (VectorizationContext.isStringFamily(constTypeString) || VectorizationContext.isDatetimeFamily(constTypeString)) {
            ExprNodeGenericFuncDesc expr2 = new ExprNodeGenericFuncDesc();
            GenericUDFTimestamp f = new GenericUDFTimestamp();
            expr2.setGenericUDF(f);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            expr2.setChildren(children);
            return this.evaluateCastToTimestamp(expr2);
        }
        throw new HiveException("Udf: unhandled constant type for scalar argument. Expecting string/date/timestamp.");
    }

    private Timestamp evaluateCastToTimestamp(ExprNodeDesc expr) throws HiveException {
        ExprNodeGenericFuncDesc expr2 = (ExprNodeGenericFuncDesc)expr;
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr2);
        ObjectInspector output = evaluator.initialize(null);
        Object constant = evaluator.evaluate(null);
        Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
        if (!(java instanceof Timestamp)) {
            throw new HiveException("Udf: failed to convert to timestamp");
        }
        Timestamp ts = (Timestamp)java;
        return ts;
    }

    private Constructor<?> getConstructor(Class<?> cl) throws HiveException {
        try {
            Constructor<?>[] ctors = cl.getDeclaredConstructors();
            if (ctors.length == 1) {
                return ctors[0];
            }
            Constructor<?> defaultCtor = cl.getConstructor(new Class[0]);
            for (Constructor<?> ctor : ctors) {
                if (ctor.equals(defaultCtor)) continue;
                return ctor;
            }
            throw new HiveException("Only default constructor found");
        }
        catch (Exception ex) {
            throw new HiveException(ex);
        }
    }

    static String getScratchName(TypeInfo typeInfo) throws HiveException {
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return typeInfo.getTypeName();
        }
        ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        return columnVectorType.name().toLowerCase();
    }

    static String getUndecoratedName(String hiveTypeName) throws HiveException {
        VectorExpressionDescriptor.ArgumentType argType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(hiveTypeName);
        switch (argType) {
            case INT_FAMILY: {
                return "Long";
            }
            case FLOAT_FAMILY: {
                return "Double";
            }
            case DECIMAL: {
                return "Decimal";
            }
            case STRING: {
                return "String";
            }
            case CHAR: {
                return "Char";
            }
            case VARCHAR: {
                return "VarChar";
            }
            case BINARY: {
                return "Binary";
            }
            case DATE: {
                return "Date";
            }
            case TIMESTAMP: {
                return "Timestamp";
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return hiveTypeName;
            }
        }
        throw new HiveException("Unexpected hive type name " + hiveTypeName);
    }

    public static String mapTypeNameSynonyms(String typeName) {
        if ((typeName = typeName.toLowerCase()).equals("long")) {
            return "bigint";
        }
        if (typeName.equals("string_family")) {
            return "string";
        }
        return typeName;
    }

    public static ColumnVector.Type getColumnVectorTypeFromTypeInfo(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case STRUCT: {
                return ColumnVector.Type.STRUCT;
            }
            case UNION: {
                return ColumnVector.Type.UNION;
            }
            case LIST: {
                return ColumnVector.Type.LIST;
            }
            case MAP: {
                return ColumnVector.Type.MAP;
            }
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case BOOLEAN: 
                    case DATE: 
                    case INTERVAL_YEAR_MONTH: {
                        return ColumnVector.Type.LONG;
                    }
                    case TIMESTAMP: {
                        return ColumnVector.Type.TIMESTAMP;
                    }
                    case INTERVAL_DAY_TIME: {
                        return ColumnVector.Type.INTERVAL_DAY_TIME;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return ColumnVector.Type.DOUBLE;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: {
                        return ColumnVector.Type.BYTES;
                    }
                    case DECIMAL: {
                        return ColumnVector.Type.DECIMAL;
                    }
                }
                throw new RuntimeException("Unexpected primitive type category " + primitiveCategory);
            }
        }
        throw new RuntimeException("Unexpected type category " + typeInfo.getCategory());
    }

    public VectorAggregateExpression getAggregatorExpression(AggregationDesc desc) throws HiveException {
        ExprNodeDesc inputExpr;
        ArrayList<ExprNodeDesc> paramDescList = desc.getParameters();
        VectorExpression[] vectorParams = new VectorExpression[paramDescList.size()];
        for (int i = 0; i < paramDescList.size(); ++i) {
            ExprNodeDesc exprDesc = paramDescList.get(i);
            vectorParams[i] = this.getVectorExpression(exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        String aggregateName = desc.getGenericUDAFName();
        VectorExpressionDescriptor.ArgumentType inputType = VectorExpressionDescriptor.ArgumentType.NONE;
        if (paramDescList.size() > 0 && (inputType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName((inputExpr = paramDescList.get(0)).getTypeString())) == VectorExpressionDescriptor.ArgumentType.NONE) {
            throw new HiveException("No vector argument type for Hive type name " + inputExpr.getTypeString());
        }
        GenericUDAFEvaluator.Mode udafEvaluatorMode = desc.getMode();
        for (AggregateDefinition aggDef : aggregatesDefinition) {
            GenericUDAFEvaluator.Mode aggDefUdafEvaluatorMode;
            if (!aggregateName.equalsIgnoreCase(aggDef.getName()) || (aggDef.getType() != VectorExpressionDescriptor.ArgumentType.NONE || inputType != VectorExpressionDescriptor.ArgumentType.NONE) && !aggDef.getType().isSameTypeOrFamily(inputType) || (aggDefUdafEvaluatorMode = aggDef.getUdafEvaluatorMode()) != null && aggDefUdafEvaluatorMode != udafEvaluatorMode) continue;
            Class<? extends VectorAggregateExpression> aggClass = aggDef.getAggClass();
            try {
                Constructor<? extends VectorAggregateExpression> ctor = aggClass.getConstructor(VectorExpression.class);
                VectorAggregateExpression aggExpr = ctor.newInstance(vectorParams.length > 0 ? vectorParams[0] : null);
                aggExpr.init(desc);
                return aggExpr;
            }
            catch (Exception e) {
                throw new HiveException("Internal exception for vector aggregate : \"" + aggregateName + "\" for type: \"" + (Object)((Object)inputType) + "", e);
            }
        }
        throw new HiveException("Vector aggregate not implemented: \"" + aggregateName + "\" for type: \"" + inputType.name() + " (UDAF evaluator mode = " + (udafEvaluatorMode == null ? "NULL" : udafEvaluatorMode.name()) + ")");
    }

    public int firstOutputColumnIndex() {
        return this.firstOutputColumnIndex;
    }

    public String[] getScratchColumnTypeNames() {
        String[] result = new String[this.ocm.outputColCount];
        for (int i = 0; i < this.ocm.outputColCount; ++i) {
            String vectorTypeName = this.ocm.scratchVectorTypeNames[i];
            String typeName = vectorTypeName.equalsIgnoreCase("bytes") ? "string" : (vectorTypeName.equalsIgnoreCase("long") ? "bigint" : vectorTypeName);
            result[i] = typeName;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Context name ").append(this.contextName).append(", level " + this.level + ", ");
        Comparator<Integer> comparerInteger = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
        TreeMap<Integer, String> sortedColumnMap = new TreeMap<Integer, String>(comparerInteger);
        for (Map.Entry<String, Integer> entry : this.projectionColumnMap.entrySet()) {
            sortedColumnMap.put(entry.getValue(), entry.getKey());
        }
        sb.append("sorted projectionColumnMap ").append(sortedColumnMap).append(", ");
        sb.append("scratchColumnTypeNames ").append(Arrays.toString(this.getScratchColumnTypeNames()));
        return sb.toString();
    }

    static {
        castExpressionUdfs.add(GenericUDFToDecimal.class);
        castExpressionUdfs.add(GenericUDFToBinary.class);
        castExpressionUdfs.add(GenericUDFToDate.class);
        castExpressionUdfs.add(GenericUDFToUnixTimeStamp.class);
        castExpressionUdfs.add(GenericUDFToUtcTimestamp.class);
        castExpressionUdfs.add(GenericUDFToChar.class);
        castExpressionUdfs.add(GenericUDFToVarchar.class);
        castExpressionUdfs.add(GenericUDFTimestamp.class);
        castExpressionUdfs.add(GenericUDFToIntervalYearMonth.class);
        castExpressionUdfs.add(GenericUDFToIntervalDayTime.class);
        castExpressionUdfs.add(UDFToByte.class);
        castExpressionUdfs.add(UDFToBoolean.class);
        castExpressionUdfs.add(UDFToDouble.class);
        castExpressionUdfs.add(UDFToFloat.class);
        castExpressionUdfs.add(UDFToString.class);
        castExpressionUdfs.add(UDFToInteger.class);
        castExpressionUdfs.add(UDFToLong.class);
        castExpressionUdfs.add(UDFToShort.class);
        udfsNeedingImplicitDecimalCast = new HashSet();
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPPlus.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMinus.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMultiply.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPDivide.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMod.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFRound.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFBRound.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFFloor.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCbrt.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCeil.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFAbs.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFPosMod.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFPower.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFFactorial.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPPositive.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPNegative.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCoalesce.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFElt.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFGreatest.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFLeast.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFIn.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqual.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualNS.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPNotEqual.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPLessThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualOrLessThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPGreaterThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualOrGreaterThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFBetween.class);
        udfsNeedingImplicitDecimalCast.add(UDFSqrt.class);
        udfsNeedingImplicitDecimalCast.add(UDFRand.class);
        udfsNeedingImplicitDecimalCast.add(UDFLn.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog2.class);
        udfsNeedingImplicitDecimalCast.add(UDFSin.class);
        udfsNeedingImplicitDecimalCast.add(UDFAsin.class);
        udfsNeedingImplicitDecimalCast.add(UDFCos.class);
        udfsNeedingImplicitDecimalCast.add(UDFAcos.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog10.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog.class);
        udfsNeedingImplicitDecimalCast.add(UDFExp.class);
        udfsNeedingImplicitDecimalCast.add(UDFDegrees.class);
        udfsNeedingImplicitDecimalCast.add(UDFRadians.class);
        udfsNeedingImplicitDecimalCast.add(UDFAtan.class);
        udfsNeedingImplicitDecimalCast.add(UDFTan.class);
        udfsNeedingImplicitDecimalCast.add(UDFOPLongDivide.class);
        aggregatesDefinition = new ArrayList<AggregateDefinition>(){
            {
                this.add(new AggregateDefinition("min", VectorExpressionDescriptor.ArgumentType.INT_DATE_INTERVAL_YEAR_MONTH, null, VectorUDAFMinLong.class));
                this.add(new AggregateDefinition("min", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, null, VectorUDAFMinDouble.class));
                this.add(new AggregateDefinition("min", VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, null, VectorUDAFMinString.class));
                this.add(new AggregateDefinition("min", VectorExpressionDescriptor.ArgumentType.DECIMAL, null, VectorUDAFMinDecimal.class));
                this.add(new AggregateDefinition("min", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, null, VectorUDAFMinTimestamp.class));
                this.add(new AggregateDefinition("max", VectorExpressionDescriptor.ArgumentType.INT_DATE_INTERVAL_YEAR_MONTH, null, VectorUDAFMaxLong.class));
                this.add(new AggregateDefinition("max", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, null, VectorUDAFMaxDouble.class));
                this.add(new AggregateDefinition("max", VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, null, VectorUDAFMaxString.class));
                this.add(new AggregateDefinition("max", VectorExpressionDescriptor.ArgumentType.DECIMAL, null, VectorUDAFMaxDecimal.class));
                this.add(new AggregateDefinition("max", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, null, VectorUDAFMaxTimestamp.class));
                this.add(new AggregateDefinition("sum", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, null, VectorUDAFSumLong.class));
                this.add(new AggregateDefinition("sum", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, null, VectorUDAFSumDouble.class));
                this.add(new AggregateDefinition("sum", VectorExpressionDescriptor.ArgumentType.DECIMAL, null, VectorUDAFSumDecimal.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFCount.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, GenericUDAFEvaluator.Mode.COMPLETE, VectorUDAFCount.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.NONE, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFCountStar.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.NONE, GenericUDAFEvaluator.Mode.COMPLETE, VectorUDAFCountStar.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL2, VectorUDAFCountMerge.class));
                this.add(new AggregateDefinition("count", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.FINAL, VectorUDAFCountMerge.class));
                this.add(new AggregateDefinition("avg", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFAvgLong.class));
                this.add(new AggregateDefinition("avg", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFAvgDouble.class));
                this.add(new AggregateDefinition("avg", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFAvgDecimal.class));
                this.add(new AggregateDefinition("avg", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFAvgTimestamp.class));
                this.add(new AggregateDefinition("variance", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopLong.class));
                this.add(new AggregateDefinition("var_pop", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopLong.class));
                this.add(new AggregateDefinition("variance", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopDouble.class));
                this.add(new AggregateDefinition("var_pop", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopDouble.class));
                this.add(new AggregateDefinition("variance", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopDecimal.class));
                this.add(new AggregateDefinition("var_pop", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopDecimal.class));
                this.add(new AggregateDefinition("variance", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopTimestamp.class));
                this.add(new AggregateDefinition("var_pop", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarPopTimestamp.class));
                this.add(new AggregateDefinition("var_samp", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarSampLong.class));
                this.add(new AggregateDefinition("var_samp", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarSampDouble.class));
                this.add(new AggregateDefinition("var_samp", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarSampDecimal.class));
                this.add(new AggregateDefinition("var_samp", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFVarSampTimestamp.class));
                this.add(new AggregateDefinition("std", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopLong.class));
                this.add(new AggregateDefinition("stddev", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopLong.class));
                this.add(new AggregateDefinition("stddev_pop", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopLong.class));
                this.add(new AggregateDefinition("std", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDouble.class));
                this.add(new AggregateDefinition("stddev", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDouble.class));
                this.add(new AggregateDefinition("stddev_pop", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDouble.class));
                this.add(new AggregateDefinition("std", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDecimal.class));
                this.add(new AggregateDefinition("stddev", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDecimal.class));
                this.add(new AggregateDefinition("stddev_pop", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopDecimal.class));
                this.add(new AggregateDefinition("std", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopTimestamp.class));
                this.add(new AggregateDefinition("stddev", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopTimestamp.class));
                this.add(new AggregateDefinition("stddev_pop", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdPopTimestamp.class));
                this.add(new AggregateDefinition("stddev_samp", VectorExpressionDescriptor.ArgumentType.INT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdSampLong.class));
                this.add(new AggregateDefinition("stddev_samp", VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdSampDouble.class));
                this.add(new AggregateDefinition("stddev_samp", VectorExpressionDescriptor.ArgumentType.DECIMAL, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdSampDecimal.class));
                this.add(new AggregateDefinition("stddev_samp", VectorExpressionDescriptor.ArgumentType.TIMESTAMP, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFStdSampTimestamp.class));
                this.add(new AggregateDefinition("bloom_filter", VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, GenericUDAFEvaluator.Mode.PARTIAL1, VectorUDAFBloomFilter.class));
                this.add(new AggregateDefinition("bloom_filter", VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, GenericUDAFEvaluator.Mode.COMPLETE, VectorUDAFBloomFilter.class));
                this.add(new AggregateDefinition("bloom_filter", VectorExpressionDescriptor.ArgumentType.BINARY, GenericUDAFEvaluator.Mode.PARTIAL2, VectorUDAFBloomFilterMerge.class));
                this.add(new AggregateDefinition("bloom_filter", VectorExpressionDescriptor.ArgumentType.BINARY, GenericUDAFEvaluator.Mode.FINAL, VectorUDAFBloomFilterMerge.class));
            }
        };
    }

    public static enum InConstantType {
        INT_FAMILY,
        TIMESTAMP,
        DATE,
        FLOAT_FAMILY,
        STRING_FAMILY,
        DECIMAL;

    }

    private static class OutputColumnManager {
        private final int initialOutputCol;
        private int outputColCount = 0;
        private String[] scratchVectorTypeNames = new String[100];
        private final Set<Integer> usedOutputColumns = new HashSet<Integer>();

        protected OutputColumnManager(int initialOutputCol) {
            this.initialOutputCol = initialOutputCol;
        }

        int allocateOutputColumn(TypeInfo typeInfo) throws HiveException {
            if (this.initialOutputCol < 0) {
                return 0;
            }
            String vectorTypeName = VectorizationContext.getScratchName(typeInfo);
            int relativeCol = this.allocateOutputColumnInternal(vectorTypeName);
            return this.initialOutputCol + relativeCol;
        }

        private int allocateOutputColumnInternal(String columnType) {
            int newIndex;
            for (int i = 0; i < this.outputColCount; ++i) {
                if (this.usedOutputColumns.contains(i) || !this.scratchVectorTypeNames[i].equalsIgnoreCase(columnType)) continue;
                this.usedOutputColumns.add(i);
                return i;
            }
            if (this.outputColCount < this.scratchVectorTypeNames.length) {
                newIndex = this.outputColCount;
                this.scratchVectorTypeNames[this.outputColCount++] = columnType;
                this.usedOutputColumns.add(newIndex);
                return newIndex;
            }
            this.scratchVectorTypeNames = Arrays.copyOf(this.scratchVectorTypeNames, 2 * this.outputColCount);
            newIndex = this.outputColCount;
            this.scratchVectorTypeNames[this.outputColCount++] = columnType;
            this.usedOutputColumns.add(newIndex);
            return newIndex;
        }

        void freeOutputColumn(int index) {
            if (this.initialOutputCol < 0) {
                return;
            }
            int colIndex = index - this.initialOutputCol;
            if (colIndex >= 0) {
                this.usedOutputColumns.remove(index - this.initialOutputCol);
            }
        }

        public int[] currentScratchColumns() {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (Integer col : this.usedOutputColumns) {
                treeSet.add(this.initialOutputCol + col);
            }
            return ArrayUtils.toPrimitive((Integer[])treeSet.toArray(new Integer[0]));
        }
    }

    public static enum HiveVectorAdaptorUsageMode {
        NONE,
        CHOSEN,
        ALL;


        public static HiveVectorAdaptorUsageMode getHiveConfValue(HiveConf hiveConf) {
            String string = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTOR_ADAPTOR_USAGE_MODE);
            return HiveVectorAdaptorUsageMode.valueOf(string.toUpperCase());
        }
    }
}

