/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IfExprIntervalDayTimeScalarScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private HiveIntervalDayTime arg2Scalar;
    private HiveIntervalDayTime arg3Scalar;
    private int outputColumn;

    public IfExprIntervalDayTimeScalarScalar(int arg1Column, HiveIntervalDayTime arg2Scalar, HiveIntervalDayTime arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprIntervalDayTimeScalarScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = false;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
        } else if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i;
                    outputColVector.set(i, vector1[i = sel[j]] == 1L ? this.arg2Scalar : this.arg3Scalar);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColVector.set(i, vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                outputColVector.set(i, !arg1ColVector.isNull[i = sel[j]] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
                outputIsNull[i] = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputColVector.set(i, !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar);
            }
            Arrays.fill(outputIsNull, 0, n, false);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", val " + this.arg2Scalar + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("int_family"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

