/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkfile;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="MYSQL_BULK_FILE", name="i18n::ActionMysqlBulkFile.Name", description="i18n::ActionMysqlBulkFile.Description", image="MysqlBulkFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMysqlBulkFile.keyword"}, documentationUrl="/workflow/actions/mysqlbulkfile.html")
public class ActionMysqlBulkFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMysqlBulkFile.class;
    private String tableName = null;
    private String schemaName = null;
    private String filename = null;
    private String separator = null;
    private String enclosed = null;
    private String lineTerminated = null;
    private String limitLines = "0";
    private String listColumn = null;
    private boolean highPriority = true;
    private boolean optionEnclosed = false;
    public int outDumpValue;
    public int ifFileExists = 2;
    private boolean addFileToResult = false;
    private DatabaseMeta connection = null;

    public ActionMysqlBulkFile(String n) {
        super(n, "");
    }

    public ActionMysqlBulkFile() {
        this("");
    }

    public Object clone() {
        ActionMysqlBulkFile je = (ActionMysqlBulkFile)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("      ").append(XmlHandler.addTagValue((String)"enclosed", (String)this.enclosed));
        retval.append("      ").append(XmlHandler.addTagValue((String)"optionenclosed", (boolean)this.optionEnclosed));
        retval.append("      ").append(XmlHandler.addTagValue((String)"lineterminated", (String)this.lineTerminated));
        retval.append("      ").append(XmlHandler.addTagValue((String)"limitlines", (String)this.limitLines));
        retval.append("      ").append(XmlHandler.addTagValue((String)"listcolumn", (String)this.listColumn));
        retval.append("      ").append(XmlHandler.addTagValue((String)"highpriority", (boolean)this.highPriority));
        retval.append("      ").append(XmlHandler.addTagValue((String)"outdumpvalue", (int)this.outDumpValue));
        retval.append("      ").append(XmlHandler.addTagValue((String)"iffileexists", (int)this.ifFileExists));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfiletoresult", (boolean)this.addFileToResult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.schemaName = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.separator = XmlHandler.getTagValue((Node)entrynode, (String)"separator");
            this.enclosed = XmlHandler.getTagValue((Node)entrynode, (String)"enclosed");
            this.lineTerminated = XmlHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.limitLines = XmlHandler.getTagValue((Node)entrynode, (String)"limitlines");
            this.listColumn = XmlHandler.getTagValue((Node)entrynode, (String)"listcolumn");
            this.highPriority = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"highpriority"));
            this.optionEnclosed = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"optionenclosed"));
            this.outDumpValue = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"outdumpvalue"), (int)-1);
            this.ifFileExists = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"iffileexists"), (int)-1);
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            this.addFileToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'table exists' from XML node", (Throwable)e);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public Result execute(Result previousResult, int nr) {
        Object limitNbrLignes = "";
        String listOfColumn = "*";
        String strHighPriority = "";
        String outDumpText = "";
        Object optionEnclosed = "";
        Object fieldSeparator = "";
        Object linesTerminated = "";
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            Object realFilename = this.getRealFilename();
            File file = new File((String)realFilename);
            if (file.exists() && this.ifFileExists == 2) {
                result.setResult(false);
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists1.Label", (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists2.Label", (String[])new String[0]));
            } else if (file.exists() && this.ifFileExists == 1) {
                result.setResult(true);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists1.Label", (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists2.Label", (String[])new String[0]));
                }
            } else {
                if (file.exists() && this.ifFileExists == 0) {
                    String wildcard = ((String)realFilename).substring(((String)realFilename).length() - 4, ((String)realFilename).length());
                    realFilename = wildcard.substring(0, 1).equals(".") ? ((String)realFilename).substring(0, ((String)realFilename).length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : (String)realFilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileNameChange1.Label", (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileNameChange1.Label", (String[])new String[0]));
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists1.Label", (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileExists2.Label", (String[])new String[0]));
                }
                if (this.connection != null) {
                    try (Database db = new Database((ILoggingObject)this, (IVariables)this, this.connection);){
                        db.connect();
                        String realSchemaname = this.resolve(this.schemaName);
                        Object realTablename = this.resolve(this.tableName);
                        if (db.checkTableExists(realSchemaname, (String)realTablename)) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableExists1.Label", (String[])new String[0]) + (String)realTablename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableExists2.Label", (String[])new String[0]));
                            }
                            if (this.schemaName != null) {
                                realTablename = realSchemaname + "." + (String)realTablename;
                            }
                            if (Const.toInt((String)this.getRealLimitlines(), (int)0) > 0) {
                                limitNbrLignes = "LIMIT " + this.getRealLimitlines();
                            }
                            if (this.getRealListColumn() != null) {
                                listOfColumn = this.MysqlString(this.getRealListColumn());
                            }
                            if (this.getRealSeparator() != null && this.outDumpValue == 0) {
                                fieldSeparator = "FIELDS TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                            }
                            if (this.getRealLineterminated() != null && this.outDumpValue == 0) {
                                linesTerminated = "LINES TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                            }
                            if (this.isHighPriority()) {
                                strHighPriority = "HIGH_PRIORITY";
                            }
                            if (this.getRealEnclosed() != null && this.outDumpValue == 0) {
                                if (this.isOptionEnclosed()) {
                                    optionEnclosed = "OPTIONALLY ";
                                }
                                optionEnclosed = (String)optionEnclosed + "ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                            }
                            outDumpText = this.outDumpValue == 0 ? "INTO OUTFILE" : "INTO DUMPFILE";
                            String fileBulkFile = "SELECT " + strHighPriority + " " + listOfColumn + " " + outDumpText + " '" + (String)realFilename + "' " + (String)fieldSeparator + " " + (String)optionEnclosed + " " + (String)linesTerminated + " FROM " + (String)realTablename + " " + (String)limitNbrLignes + " LOCK IN SHARE MODE";
                            try {
                                if (this.log.isDetailed()) {
                                    this.logDetailed(fileBulkFile);
                                }
                                PreparedStatement ps = db.prepareSql(fileBulkFile);
                                ps.execute();
                                if (this.isAddFileToResult()) {
                                    ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                }
                                result.setResult(true);
                            }
                            catch (SQLException je) {
                                result.setNrErrors(1L);
                                this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Error.Label", (String[])new String[0]) + " " + je.getMessage());
                            }
                            catch (HopFileException e) {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Error.Label", (String[])new String[0]) + e.getMessage());
                                result.setNrErrors(1L);
                            }
                        } else {
                            result.setNrErrors(1L);
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableNotExists1.Label", (String[])new String[0]) + (String)realTablename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableNotExists2.Label", (String[])new String[0]));
                            }
                        }
                    }
                    catch (HopDatabaseException dbe) {
                        result.setNrErrors(1L);
                        this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Error.Label", (String[])new String[0]) + " " + dbe.getMessage());
                    }
                } else {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.NoDatabase.Label", (String[])new String[0]));
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.NoFileName.Label", (String[])new String[0]));
        }
        return result;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public void setHighPriority(boolean highpriority) {
        this.highPriority = highpriority;
    }

    public void setOptionEnclosed(boolean optionenclosed) {
        this.optionEnclosed = optionenclosed;
    }

    public boolean isHighPriority() {
        return this.highPriority;
    }

    public boolean isOptionEnclosed() {
        return this.optionEnclosed;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        String realFile = this.resolve(this.getFilename());
        return realFile.replace('\\', '/');
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    public void setLineTerminated(String lineTerminated) {
        this.lineTerminated = lineTerminated;
    }

    public String getLineTerminated() {
        return this.lineTerminated;
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineTerminated());
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getEnclosed() {
        return this.enclosed;
    }

    public String getRealSeparator() {
        return this.resolve(this.getSeparator());
    }

    public String getRealEnclosed() {
        return this.resolve(this.getEnclosed());
    }

    public void setLimitLines(String limitLines) {
        this.limitLines = limitLines;
    }

    public String getLimitLines() {
        return this.limitLines;
    }

    public String getRealLimitlines() {
        return this.resolve(this.getLimitLines());
    }

    public void setListColumn(String listcolumn) {
        this.listColumn = listcolumn;
    }

    public String getListColumn() {
        return this.listColumn;
    }

    public String getRealListColumn() {
        return this.resolve(this.getListColumn());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addFileToResult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    private String MysqlString(String listcolumns) {
        Object returnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            returnString = ((String)returnString).equals("") ? "`" + Const.trim((String)split[i]) + "`" : (String)returnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return returnString;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

