/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.beam.runners.core.metrics.ExecutionStateSampler;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Intentional for performance.")
public class ExecutionStateTracker
implements Comparable<ExecutionStateTracker> {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker> CURRENT_TRACKERS = new ConcurrentHashMap<Long, ExecutionStateTracker>();
    private static final @UnknownKeyFor @NonNull @Initialized long LULL_REPORT_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final @UnknownKeyFor @NonNull @Initialized AtomicIntegerFieldUpdater<@UnknownKeyFor @NonNull @Initialized ExecutionStateTracker> SAMPLING_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExecutionStateTracker.class, "sampling");
    public static final @UnknownKeyFor @NonNull @Initialized String START_STATE_NAME = "start";
    public static final @UnknownKeyFor @NonNull @Initialized String PROCESS_STATE_NAME = "process";
    public static final @UnknownKeyFor @NonNull @Initialized String PROCESS_TIMERS_STATE_NAME = "process-timers";
    public static final @UnknownKeyFor @NonNull @Initialized String FINISH_STATE_NAME = "finish";
    public static final @UnknownKeyFor @NonNull @Initialized String ABORT_STATE_NAME = "abort";
    private final @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler sampler;
    private @Nullable @UnknownKeyFor @Initialized Thread trackedThread = null;
    private volatile @Nullable @UnknownKeyFor @Initialized ExecutionState currentState;
    private volatile @UnknownKeyFor @NonNull @Initialized int sampling = 0;
    private volatile @UnknownKeyFor @NonNull @Initialized long numTransitions = 0L;
    private volatile @UnknownKeyFor @NonNull @Initialized long millisSinceLastTransition = 0L;
    private @UnknownKeyFor @NonNull @Initialized long transitionsAtLastSample = 0L;
    private @UnknownKeyFor @NonNull @Initialized long nextLullReportMs = LULL_REPORT_MS;

    public ExecutionStateTracker(@UnknownKeyFor @NonNull @Initialized ExecutionStateSampler sampler) {
        this.sampler = sampler;
    }

    public synchronized void reset() {
        if (this.trackedThread != null) {
            CURRENT_TRACKERS.remove(this.trackedThread.getId());
            this.trackedThread = null;
        }
        this.currentState = null;
        this.numTransitions = 0L;
        this.millisSinceLastTransition = 0L;
        this.transitionsAtLastSample = 0L;
        this.nextLullReportMs = LULL_REPORT_MS;
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker newForTest() {
        return new ExecutionStateTracker(ExecutionStateSampler.newForTest());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    @Pure
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized ExecutionStateTracker o) {
        if (this.equals(o)) {
            return 0;
        }
        return System.identityHashCode(this) - System.identityHashCode(o);
    }

    public static @Nullable @UnknownKeyFor @Initialized ExecutionState getCurrentExecutionState() {
        ExecutionStateTracker tracker = CURRENT_TRACKERS.get(Thread.currentThread().getId());
        return tracker == null ? null : tracker.currentState;
    }

    public static @Nullable @UnknownKeyFor @Initialized ExecutionState getCurrentExecutionState(@UnknownKeyFor @NonNull @Initialized long threadId) {
        ExecutionStateTracker tracker = CURRENT_TRACKERS.get(threadId);
        return tracker == null ? null : tracker.currentState;
    }

    public @UnknownKeyFor @NonNull @Initialized Closeable activate() {
        return this.activate(Thread.currentThread());
    }

    @VisibleForTesting
    public synchronized @UnknownKeyFor @NonNull @Initialized Closeable activate(@UnknownKeyFor @NonNull @Initialized Thread thread) {
        Preconditions.checkState((this.trackedThread == null ? 1 : 0) != 0, (Object)"Cannot activate an ExecutionStateTracker that is already in use.");
        ExecutionStateTracker other = CURRENT_TRACKERS.put(thread.getId(), this);
        Preconditions.checkState((other == null ? 1 : 0) != 0, (String)"Execution state of thread %s was already being tracked by %s", (long)thread.getId(), (Object)other);
        this.trackedThread = thread;
        this.sampler.addTracker(this);
        return this::deactivate;
    }

    public @UnknownKeyFor @NonNull @Initialized Thread getTrackedThread() {
        return this.trackedThread;
    }

    private synchronized void deactivate() {
        this.sampler.removeTracker(this);
        Thread thread = this.trackedThread;
        if (thread != null) {
            CURRENT_TRACKERS.remove(thread.getId());
        }
        this.trackedThread = null;
    }

    public @UnknownKeyFor @NonNull @Initialized ExecutionState getCurrentState() {
        return this.currentState;
    }

    public @UnknownKeyFor @NonNull @Initialized Closeable enterState(@UnknownKeyFor @NonNull @Initialized ExecutionState newState) {
        ExecutionState previous = this.currentState;
        this.currentState = newState;
        newState.onActivate(true);
        this.incTransitions();
        return () -> {
            this.currentState = previous;
            this.incTransitions();
            if (previous != null) {
                previous.onActivate(false);
            }
        };
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Intentional for performance.")
    private void incTransitions() {
        ++this.numTransitions;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNumTransitions() {
        return this.numTransitions;
    }

    public @UnknownKeyFor @NonNull @Initialized long getMillisSinceLastTransition() {
        return this.millisSinceLastTransition;
    }

    public @UnknownKeyFor @NonNull @Initialized long getTransitionsAtLastSample() {
        return this.transitionsAtLastSample;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNextLullReportMs() {
        return this.nextLullReportMs;
    }

    void takeSample(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
        if (SAMPLING_UPDATER.compareAndSet(this, 0, 1)) {
            try {
                this.takeSampleOnce(millisSinceLastSample);
            }
            finally {
                SAMPLING_UPDATER.set(this, 0);
            }
        }
    }

    protected void takeSampleOnce(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
        ExecutionState state = this.currentState;
        long transitionsAtThisSample = this.numTransitions;
        if (transitionsAtThisSample != this.transitionsAtLastSample) {
            this.millisSinceLastTransition = 0L;
            this.nextLullReportMs = LULL_REPORT_MS;
            this.transitionsAtLastSample = transitionsAtThisSample;
        }
        this.updateMillisSinceLastTransition(millisSinceLastSample, state);
    }

    private void updateMillisSinceLastTransition(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample, @UnknownKeyFor @NonNull @Initialized ExecutionState state) {
        this.millisSinceLastTransition += millisSinceLastSample;
        if (state != null) {
            if (this.millisSinceLastTransition > this.nextLullReportMs) {
                state.reportLull(this.trackedThread, this.millisSinceLastTransition);
                this.nextLullReportMs += LULL_REPORT_MS;
            }
            state.takeSample(millisSinceLastSample);
        }
    }

    public static abstract class ExecutionState {
        private final @UnknownKeyFor @NonNull @Initialized String stateName;
        public final @UnknownKeyFor @NonNull @Initialized boolean isProcessElementState;

        public ExecutionState(@UnknownKeyFor @NonNull @Initialized String stateName) {
            this.stateName = stateName;
            this.isProcessElementState = Objects.equals(stateName, ExecutionStateTracker.PROCESS_STATE_NAME);
        }

        public abstract void takeSample(@UnknownKeyFor @NonNull @Initialized long var1);

        public @UnknownKeyFor @NonNull @Initialized String getStateName() {
            return this.stateName;
        }

        public void onActivate(@UnknownKeyFor @NonNull @Initialized boolean pushing) {
        }

        public abstract void reportLull(@UnknownKeyFor @NonNull @Initialized Thread var1, @UnknownKeyFor @NonNull @Initialized long var2);

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("stateName", (Object)this.stateName).toString();
        }

        public @UnknownKeyFor @NonNull @Initialized String getDescription() {
            return this.stateName;
        }
    }
}

