/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.TimeUUID;

public abstract class ConsistentSession {
    private volatile State state;
    public final TimeUUID sessionID;
    public final InetAddressAndPort coordinator;
    public final ImmutableSet<TableId> tableIds;
    public final long repairedAt;
    public final ImmutableSet<Range<Token>> ranges;
    public final ImmutableSet<InetAddressAndPort> participants;

    ConsistentSession(AbstractBuilder builder) {
        builder.validate();
        this.state = builder.state;
        this.sessionID = builder.sessionID;
        this.coordinator = builder.coordinator;
        this.tableIds = ImmutableSet.copyOf((Collection)builder.ids);
        this.repairedAt = builder.repairedAt;
        this.ranges = ImmutableSet.copyOf((Collection)builder.ranges);
        this.participants = ImmutableSet.copyOf((Collection)builder.participants);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean intersects(Iterable<Range<Token>> otherRanges) {
        return Iterables.any(this.ranges, r -> ((AbstractBounds)r).intersects(otherRanges));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistentSession that = (ConsistentSession)o;
        if (this.repairedAt != that.repairedAt) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.sessionID.equals(that.sessionID)) {
            return false;
        }
        if (!this.coordinator.equals(that.coordinator)) {
            return false;
        }
        if (!this.tableIds.equals(that.tableIds)) {
            return false;
        }
        if (!this.ranges.equals(that.ranges)) {
            return false;
        }
        return this.participants.equals(that.participants);
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + this.sessionID.hashCode();
        result = 31 * result + this.coordinator.hashCode();
        result = 31 * result + this.tableIds.hashCode();
        result = 31 * result + (int)(this.repairedAt ^ this.repairedAt >>> 32);
        result = 31 * result + this.ranges.hashCode();
        result = 31 * result + this.participants.hashCode();
        return result;
    }

    public String toString() {
        return "ConsistentSession{state=" + (Object)((Object)this.state) + ", sessionID=" + this.sessionID + ", coordinator=" + this.coordinator + ", tableIds=" + this.tableIds + ", repairedAt=" + this.repairedAt + ", ranges=" + this.ranges + ", participants=" + this.participants + '}';
    }

    static abstract class AbstractBuilder {
        private State state;
        private TimeUUID sessionID;
        private InetAddressAndPort coordinator;
        private Set<TableId> ids;
        private long repairedAt;
        private Collection<Range<Token>> ranges;
        private Set<InetAddressAndPort> participants;

        AbstractBuilder() {
        }

        void withState(State state) {
            this.state = state;
        }

        void withSessionID(TimeUUID sessionID) {
            this.sessionID = sessionID;
        }

        void withCoordinator(InetAddressAndPort coordinator) {
            this.coordinator = coordinator;
        }

        void withUUIDTableIds(Iterable<UUID> ids) {
            this.ids = ImmutableSet.copyOf((Iterable)Iterables.transform(ids, TableId::fromUUID));
        }

        void withTableIds(Set<TableId> ids) {
            this.ids = ids;
        }

        void withRepairedAt(long repairedAt) {
            this.repairedAt = repairedAt;
        }

        void withRanges(Collection<Range<Token>> ranges) {
            this.ranges = ranges;
        }

        void withParticipants(Set<InetAddressAndPort> peers) {
            this.participants = peers;
        }

        void validate() {
            Preconditions.checkArgument((this.state != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.sessionID != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.coordinator != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.ids != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.ids.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.repairedAt > 0L || this.repairedAt == 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((this.ranges != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.ranges.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.participants != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.participants.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)this.participants.contains(this.coordinator));
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State PREPARING = new State(0);
        public static final /* enum */ State PREPARED = new State(1);
        public static final /* enum */ State REPAIRING = new State(2);
        public static final /* enum */ State FINALIZE_PROMISED = new State(3);
        public static final /* enum */ State FINALIZED = new State(4);
        public static final /* enum */ State FAILED = new State(5);
        private static final Map<State, Set<State>> transitions;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(int expectedOrdinal) {
            assert (this.ordinal() == expectedOrdinal);
        }

        public boolean canTransitionTo(State state) {
            return state == this || transitions.get((Object)this).contains((Object)state);
        }

        public static State valueOf(int ordinal) {
            return State.values()[ordinal];
        }

        static {
            $VALUES = new State[]{PREPARING, PREPARED, REPAIRING, FINALIZE_PROMISED, FINALIZED, FAILED};
            transitions = new EnumMap<State, Set<State>>(State.class){
                {
                    this.put(PREPARING, ImmutableSet.of((Object)((Object)PREPARED), (Object)((Object)FAILED)));
                    this.put(PREPARED, ImmutableSet.of((Object)((Object)REPAIRING), (Object)((Object)FAILED)));
                    this.put(REPAIRING, ImmutableSet.of((Object)((Object)FINALIZE_PROMISED), (Object)((Object)FAILED)));
                    this.put(FINALIZE_PROMISED, ImmutableSet.of((Object)((Object)FINALIZED), (Object)((Object)FAILED)));
                    this.put(FINALIZED, ImmutableSet.of());
                    this.put(FAILED, ImmutableSet.of());
                }
            };
        }
    }
}

