/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.NoOpMetricsSink;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.metrics.MetricsSink;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MetricsPusher
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized MetricsSink metricsSink;
    private @UnknownKeyFor @NonNull @Initialized long period;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ScheduledFuture<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> scheduledFuture;
    private transient @UnknownKeyFor @NonNull @Initialized PipelineResult pipelineResult;
    private @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainerStepMap;

    public MetricsPusher(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainerStepMap, @UnknownKeyFor @NonNull @Initialized MetricsOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized PipelineResult pipelineResult) {
        this.metricsContainerStepMap = metricsContainerStepMap;
        this.pipelineResult = pipelineResult;
        this.period = pipelineOptions.getMetricsPushPeriod();
        this.metricsSink = (MetricsSink)InstanceBuilder.ofType(MetricsSink.class).fromClass(pipelineOptions.getMetricsSink()).withArg(MetricsOptions.class, (Object)pipelineOptions).build();
    }

    public void start() {
        if (!(this.metricsSink instanceof NoOpMetricsSink)) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MetricsPusher-thread").build());
            this.scheduledFuture = scheduler.scheduleAtFixedRate(this::run, 0L, this.period, TimeUnit.SECONDS);
        }
    }

    private void tearDown() {
        this.pushMetrics();
        if (!this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
    }

    private void run() {
        PipelineResult.State pipelineState;
        this.pushMetrics();
        if (this.pipelineResult != null && (pipelineState = this.pipelineResult.getState()).isTerminal()) {
            this.tearDown();
        }
    }

    private void pushMetrics() {
        if (!(this.metricsSink instanceof NoOpMetricsSink)) {
            try {
                MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults(this.metricsContainerStepMap);
                MetricQueryResults metricQueryResults = metricResults.allMetrics();
                if (Iterables.size((Iterable)metricQueryResults.getDistributions()) != 0 || Iterables.size((Iterable)metricQueryResults.getGauges()) != 0 || Iterables.size((Iterable)metricQueryResults.getCounters()) != 0) {
                    this.metricsSink.writeMetrics(metricQueryResults);
                }
            }
            catch (Exception e) {
                MetricsPushException metricsPushException = new MetricsPushException(e);
                metricsPushException.printStackTrace();
            }
        }
    }

    public static class MetricsPushException
    extends Exception {
        MetricsPushException(@UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super(cause);
        }
    }
}

