/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmAccessor;
import org.apache.tika.parser.microsoft.chm.ChmAssert;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;

public class ChmLzxcControlData
implements ChmAccessor<ChmLzxcControlData> {
    private static final long serialVersionUID = -7897854774939631565L;
    private long size;
    private byte[] signature = "LZXC".getBytes(StandardCharsets.UTF_8);
    private long version;
    private long resetInterval;
    private long windowSize;
    private long windowsPerReset;
    private long unknown_18;
    private int dataRemained;
    private int currentPlace = 0;

    public static void main(String[] args) {
    }

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int dataRemained) {
        this.dataRemained = dataRemained;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int currentPlace) {
        this.currentPlace = currentPlace;
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long size) {
        this.size = size;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public long getVersion() {
        return this.version;
    }

    protected void setVersion(long version) {
        this.version = version;
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    protected void setResetInterval(long resetInterval) {
        this.resetInterval = resetInterval;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    protected void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    public long getWindowsPerReset() {
        return this.windowsPerReset;
    }

    protected void setWindowsPerReset(long windowsPerReset) {
        this.windowsPerReset = windowsPerReset;
    }

    public long getUnknown_18() {
        return this.unknown_18;
    }

    protected void setUnknown_18(long unknown_18) {
        this.unknown_18 = unknown_18;
    }

    private long unmarshalUInt32(byte[] data, long dest) throws ChmParsingException {
        assert (data != null && data.length > 0);
        if (4 > this.getDataRemained()) {
            throw new ChmParsingException("4 > dataLenght");
        }
        dest = data[this.getCurrentPlace()] | data[this.getCurrentPlace() + 1] << 8 | data[this.getCurrentPlace() + 2] << 16 | data[this.getCurrentPlace() + 3] << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return dest;
    }

    private void unmarshalCharArray(byte[] data, ChmLzxcControlData chmLzxcControlData, int count) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        ChmAssert.assertChmAccessorNotNull(chmLzxcControlData);
        ChmAssert.assertPositiveInt(count);
        System.arraycopy(data, 4, chmLzxcControlData.getSignature(), 0, count);
        this.setCurrentPlace(this.getCurrentPlace() + count);
        this.setDataRemained(this.getDataRemained() - count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("size(unknown):=").append(this.getSize()).append(", ");
        sb.append("signature(Compression type identifier):=").append(new String(this.getSignature(), StandardCharsets.UTF_8)).append(", ");
        sb.append("version(Possibly numeric code for LZX):=").append(this.getVersion()).append(System.getProperty("line.separator"));
        sb.append("resetInterval(The Huffman reset interval):=").append(this.getResetInterval()).append(", ");
        sb.append("windowSize:=").append(this.getWindowSize()).append(", ");
        sb.append("windowsPerReset(unknown (sometimes 2, sometimes 1, sometimes 0):=").append(this.getWindowsPerReset()).append(", ");
        sb.append("unknown_18:=").append(this.getUnknown_18()).append(System.getProperty("line.separator"));
        return sb.toString();
    }

    @Override
    public void parse(byte[] data, ChmLzxcControlData chmLzxcControlData) throws TikaException {
        if (data == null || data.length < 24) {
            throw new ChmParsingException("we want at least 0x18 bytes");
        }
        chmLzxcControlData.setDataRemained(data.length);
        chmLzxcControlData.setSize(this.unmarshalUInt32(data, chmLzxcControlData.getSize()));
        chmLzxcControlData.unmarshalCharArray(data, chmLzxcControlData, 4);
        chmLzxcControlData.setVersion(this.unmarshalUInt32(data, chmLzxcControlData.getVersion()));
        chmLzxcControlData.setResetInterval(this.unmarshalUInt32(data, chmLzxcControlData.getResetInterval()));
        chmLzxcControlData.setWindowSize(this.unmarshalUInt32(data, chmLzxcControlData.getWindowSize()));
        chmLzxcControlData.setWindowsPerReset(this.unmarshalUInt32(data, chmLzxcControlData.getWindowsPerReset()));
        if (data.length >= 28) {
            chmLzxcControlData.setUnknown_18(this.unmarshalUInt32(data, chmLzxcControlData.getUnknown_18()));
        } else {
            chmLzxcControlData.setUnknown_18(0L);
        }
        if (chmLzxcControlData.getVersion() == 2L) {
            chmLzxcControlData.setWindowSize(this.getWindowSize() * 32768L);
        }
        if (chmLzxcControlData.getWindowSize() == 0L || chmLzxcControlData.getResetInterval() == 0L) {
            throw new ChmParsingException("window size / resetInterval should be more than zero");
        }
        if (chmLzxcControlData.getWindowSize() == 1L) {
            throw new ChmParsingException("window size / resetInterval should be more than 1");
        }
        if (!new String(chmLzxcControlData.getSignature(), StandardCharsets.UTF_8).equals("LZXC")) {
            throw new ChmParsingException("the signature does not seem to be correct");
        }
    }
}

