/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.options.DataflowProfilingOptions;
import org.apache.beam.runners.dataflow.options.DataflowWorkerLoggingOptions;
import org.apache.beam.runners.dataflow.options.DefaultGcpRegionFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Options that configure the Dataflow pipeline.")
public interface DataflowPipelineOptions
extends PipelineOptions,
GcpOptions,
ApplicationNameOptions,
DataflowPipelineDebugOptions,
DataflowPipelineWorkerPoolOptions,
BigQueryOptions,
GcsOptions,
StreamingOptions,
DataflowWorkerLoggingOptions,
DataflowProfilingOptions,
PubsubOptions {
    @Description(value="Project id. Required when running a Dataflow in the cloud. See https://cloud.google.com/storage/docs/projects for further details.")
    @Validation.Required
    @Default.InstanceFactory(value=GcpOptions.DefaultProjectFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getProject();

    public void setProject(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCS path for staging local files, e.g. \"gs://bucket/object\". Must be a valid Cloud Storage URL, beginning with the prefix \"gs://\". If stagingLocation is unset, defaults to gcpTempLocation with \"/staging\" suffix.")
    @Default.InstanceFactory(value=StagingLocationFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getStagingLocation();

    public void setStagingLocation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="If set, replace the existing pipeline with the name specified by --jobName with this pipeline, preserving state.")
    public @UnknownKeyFor @NonNull @Initialized boolean isUpdate();

    public void setUpdate(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="If set, the snapshot from which the job should be created.")
    public @UnknownKeyFor @NonNull @Initialized String getCreateFromSnapshot();

    public void setCreateFromSnapshot(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Where the runner should generate a template file. Must either be local or Cloud Storage.")
    public @UnknownKeyFor @NonNull @Initialized String getTemplateLocation();

    public void setTemplateLocation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Service options are set by the user and configure the service. This decouples service side feature availability from the Apache Beam release cycle.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDataflowServiceOptions();

    public void setDataflowServiceOptions(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="Run the job as a specific service account, instead of the default GCE robot.")
    public @UnknownKeyFor @NonNull @Initialized String getServiceAccount();

    public void setServiceAccount(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The Google Compute Engine region for creating Dataflow jobs. See https://cloud.google.com/compute/docs/regions-zones/regions-zones for a list of valid options.")
    @Default.InstanceFactory(value=DefaultGcpRegionFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getRegion();

    public void setRegion(@UnknownKeyFor @NonNull @Initialized String var1);

    @Override
    @Description(value="The URL for the Dataflow API. If the string contains \"://\", this will be treated as the entire URL, otherwise will be treated relative to apiRootUrl.")
    @Default.String(value="")
    public @UnknownKeyFor @NonNull @Initialized String getDataflowEndpoint();

    @Override
    public void setDataflowEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Labels that will be applied to the billing records for this job.")
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getLabels();

    public void setLabels(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="The URL of the staged portable pipeline")
    public @UnknownKeyFor @NonNull @Initialized String getPipelineUrl();

    public void setPipelineUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The customized dataflow worker jar")
    public @UnknownKeyFor @NonNull @Initialized String getDataflowWorkerJar();

    public void setDataflowWorkerJar(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Controls the Flexible Resource Scheduling mode.")
    @Default.Enum(value="UNSPECIFIED")
    public @UnknownKeyFor @NonNull @Initialized FlexResourceSchedulingGoal getFlexRSGoal();

    public void setFlexRSGoal(@UnknownKeyFor @NonNull @Initialized FlexResourceSchedulingGoal var1);

    @Description(value="If enabled then the literal key will be logged to Cloud Logging if a hot key is detected.")
    public @UnknownKeyFor @NonNull @Initialized boolean isHotKeyLoggingEnabled();

    public void setHotKeyLoggingEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Open modules needed for reflection with Java 17+.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getJdkAddOpenModules();

    public void setJdkAddOpenModules(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    public static class StagingLocationFactory
    implements DefaultValueFactory<String> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StagingLocationFactory.class);

        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String gcpTempLocation;
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            LOG.info("No stagingLocation provided, falling back to gcpTempLocation");
            try {
                gcpTempLocation = gcsOptions.getGcpTempLocation();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error constructing default value for stagingLocation: failed to retrieve gcpTempLocation. Either stagingLocation must be set explicitly or a valid value must be providedfor gcpTempLocation.", e);
            }
            try {
                gcsOptions.getPathValidator().validateOutputFilePrefixSupported(gcpTempLocation);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error constructing default value for stagingLocation: gcpTempLocation is not a valid GCS path, %s. ", gcpTempLocation), e);
            }
            return FileSystems.matchNewResource((String)gcpTempLocation, (boolean)true).resolve("staging", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).toString();
        }
    }

    public static enum FlexResourceSchedulingGoal {
        UNSPECIFIED,
        SPEED_OPTIMIZED,
        COST_OPTIMIZED;

    }
}

