/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\r4A!\u0004\b\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u001d\t\u0004A1A\u0005\n1BaA\r\u0001!\u0002\u0013i\u0003bB\u001a\u0001\u0005\u0004%I\u0001\u000e\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001b\t\u000b\t\u0003A\u0011I\"\t\r5\u0003A\u0011\t\tO\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015I\u0006\u0001\"\u0011[\u0005QQ6\u000b\u001e3D_6\u0004(/Z:tS>t7i\u001c3fG*\u0011q\u0002E\u0001\u0003S>T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\b\n\u0005\u0005r!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0011*S\"\u0001\t\n\u0005\u0019\u0002\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003?\u0001AQA\t\u0002A\u0002\r\n!BY;gM\u0016\u00148+\u001b>f+\u0005i\u0003CA\r/\u0013\ty#DA\u0002J]R\f1BY;gM\u0016\u00148+\u001b>fA\u0005)A.\u001a<fY\u00061A.\u001a<fY\u0002\n!BY;gM\u0016\u0014\bk\\8m+\u0005)\u0004C\u0001\u001c@\u001b\u00059$B\u0001\u001d:\u0003\u0011Q8\u000f\u001e3\u000b\u0005iZ\u0014!\u00027vE\u0016t'B\u0001\u001f>\u0003\u00199\u0017\u000e\u001e5vE*\ta(A\u0002d_6L!\u0001Q\u001c\u0003\u0015\t+hMZ3s!>|G.A\u0006ck\u001a4WM\u001d)p_2\u0004\u0013AF2p[B\u0014Xm]:fI>+H\u000f];u'R\u0014X-Y7\u0015\u0005\u0011[\u0005CA#J\u001b\u00051%BA\bH\u0015\u0005A\u0015\u0001\u00026bm\u0006L!A\u0013$\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000b1K\u0001\u0019\u0001#\u0002\u0003M\f\u0001eY8naJ,7o]3e\u0007>tG/\u001b8v_V\u001cx*\u001e;qkR\u001cFO]3b[R\u0011qJ\u0015\t\u0003\u000bBK!!\u0015$\u0003)\t+hMZ3sK\u0012|U\u000f\u001e9viN#(/Z1n\u0011\u0015a%\u00021\u0001E\u0003U\u0019w.\u001c9sKN\u001cX\rZ%oaV$8\u000b\u001e:fC6$\"!\u0016-\u0011\u0005\u00153\u0016BA,G\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b1[\u0001\u0019A+\u0002?\r|W\u000e\u001d:fgN,GmQ8oi&tWo\\;t\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002V7\")A\n\u0004a\u0001+\"\u0012\u0001!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003AB\t!\"\u00198o_R\fG/[8o\u0013\t\u0011wL\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class ZStdCompressionCodec
implements CompressionCodec {
    private final int bufferSize;
    private final int level;
    private final BufferPool bufferPool;

    private int bufferSize() {
        return this.bufferSize;
    }

    private int level() {
        return this.level;
    }

    private BufferPool bufferPool() {
        return this.bufferPool;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        ZstdOutputStreamNoFinalizer os = new ZstdOutputStreamNoFinalizer(s, this.bufferPool()).setLevel(this.level());
        return new BufferedOutputStream((OutputStream)os, this.bufferSize());
    }

    @Override
    public BufferedOutputStream compressedContinuousOutputStream(OutputStream s) {
        ZstdOutputStreamNoFinalizer os = new ZstdOutputStreamNoFinalizer(s, this.bufferPool()).setLevel(this.level()).setCloseFrameOnFlush(true);
        return new BufferedOutputStream((OutputStream)os, this.bufferSize());
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStreamNoFinalizer(s, this.bufferPool()), this.bufferSize());
    }

    @Override
    public InputStream compressedContinuousInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStreamNoFinalizer(s, this.bufferPool()).setContinuous(true), this.bufferSize());
    }

    public ZStdCompressionCodec(SparkConf conf) {
        CompressionCodec.$init$(this);
        this.bufferSize = (int)BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERSIZE()));
        this.level = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL()));
        this.bufferPool = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERPOOL_ENABLED())) ? RecyclingBufferPool.INSTANCE : NoPool.INSTANCE;
    }
}

