/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkload;

import java.io.File;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="MYSQL_BULK_LOAD", name="i18n::ActionMysqlBulkLoad.Name", description="i18n::ActionMysqlBulkLoad.Description", image="MysqlBulkLoad.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMysqlBulkLoad.keyword"}, documentationUrl="/workflow/actions/mysqlbulkload.html")
public class ActionMysqlBulkLoad
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMysqlBulkLoad.class;
    private String schemaname = null;
    private String tableName = null;
    private String filename = null;
    private String separator = null;
    private String enclosed = null;
    private String escaped = null;
    private String linestarted = null;
    private String lineterminated = null;
    private String ignorelines = "0";
    private boolean replacedata = true;
    private String listattribut = null;
    private boolean localinfile = true;
    public int prorityvalue;
    private boolean addfiletoresult = false;
    private DatabaseMeta connection = null;

    public ActionMysqlBulkLoad(String n) {
        super(n, "");
    }

    public ActionMysqlBulkLoad() {
        this("");
    }

    public Object clone() {
        ActionMysqlBulkLoad je = (ActionMysqlBulkLoad)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("      ").append(XmlHandler.addTagValue((String)"enclosed", (String)this.enclosed));
        retval.append("      ").append(XmlHandler.addTagValue((String)"escaped", (String)this.escaped));
        retval.append("      ").append(XmlHandler.addTagValue((String)"linestarted", (String)this.linestarted));
        retval.append("      ").append(XmlHandler.addTagValue((String)"lineterminated", (String)this.lineterminated));
        retval.append("      ").append(XmlHandler.addTagValue((String)"replacedata", (boolean)this.replacedata));
        retval.append("      ").append(XmlHandler.addTagValue((String)"ignorelines", (String)this.ignorelines));
        retval.append("      ").append(XmlHandler.addTagValue((String)"listattribut", (String)this.listattribut));
        retval.append("      ").append(XmlHandler.addTagValue((String)"localinfile", (boolean)this.localinfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"prorityvalue", (int)this.prorityvalue));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.schemaname = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.separator = XmlHandler.getTagValue((Node)entrynode, (String)"separator");
            this.enclosed = XmlHandler.getTagValue((Node)entrynode, (String)"enclosed");
            this.escaped = XmlHandler.getTagValue((Node)entrynode, (String)"escaped");
            this.linestarted = XmlHandler.getTagValue((Node)entrynode, (String)"linestarted");
            this.lineterminated = XmlHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.replacedata = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"replacedata"));
            this.ignorelines = XmlHandler.getTagValue((Node)entrynode, (String)"ignorelines");
            this.listattribut = XmlHandler.getTagValue((Node)entrynode, (String)"listattribut");
            this.localinfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"localinfile"));
            this.prorityvalue = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"prorityvalue"), (int)-1);
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.addfiletoresult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'Mysql bulk load' from XML node", (Throwable)e);
        }
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public String getTablename() {
        return this.tableName;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public Result execute(Result previousResult, int nr) {
        Result result;
        block37: {
            Object ignoreNbrLignes = "";
            Object listOfColumn = "";
            String localExec = "";
            String priorityText = "";
            Object lineTerminatedby = "";
            Object fieldTerminatedby = "";
            result = previousResult;
            result.setResult(false);
            String vfsFilename = this.resolve(this.filename);
            if (!Utils.isEmpty((CharSequence)vfsFilename)) {
                try {
                    FileObject fileObject = HopVfs.getFileObject((String)vfsFilename);
                    if (!(fileObject instanceof LocalFile)) {
                        throw new HopException("Only local files are supported at this time, file [" + vfsFilename + "] is not a local file.");
                    }
                    String realFilename = HopVfs.getFilename((FileObject)fileObject);
                    File file = new File(realFilename);
                    if (file.exists() && file.canRead() || !this.isLocalInfile()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed("File [" + realFilename + "] exists.");
                        }
                        if (this.connection != null) {
                            try (Database db = new Database((ILoggingObject)this, (IVariables)this, this.connection);){
                                db.connect();
                                String realSchemaname = this.resolve(this.schemaname);
                                Object realTablename = this.resolve(this.tableName);
                                if (db.checkTableExists(realSchemaname, (String)realTablename)) {
                                    if (this.log.isDetailed()) {
                                        this.logDetailed("Table [" + (String)realTablename + "] exists.");
                                    }
                                    if (this.schemaname != null) {
                                        realTablename = realSchemaname + "." + (String)realTablename;
                                    }
                                    String replaceIgnore = this.isReplacedata() ? "REPLACE" : "IGNORE";
                                    if (Const.toInt((String)this.getRealIgnorelines(), (int)0) > 0) {
                                        ignoreNbrLignes = "IGNORE " + this.getRealIgnorelines() + " LINES";
                                    }
                                    if (this.getRealListattribut() != null) {
                                        listOfColumn = "(" + this.MysqlString(this.getRealListattribut()) + ")";
                                    }
                                    if (this.isLocalInfile()) {
                                        localExec = "LOCAL";
                                    }
                                    if (this.prorityvalue == 1) {
                                        priorityText = "LOW_PRIORITY";
                                    } else if (this.prorityvalue == 2) {
                                        priorityText = "CONCURRENT";
                                    }
                                    if (this.getRealSeparator() != null || this.getRealEnclosed() != null || this.getRealEscaped() != null) {
                                        fieldTerminatedby = "FIELDS ";
                                        if (this.getRealSeparator() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + "TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEnclosed() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + " ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEscaped() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + " ESCAPED BY '" + Const.replace((String)this.getRealEscaped(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    if (this.getRealLinestarted() != null || this.getRealLineterminated() != null) {
                                        lineTerminatedby = "LINES ";
                                        if (this.getRealLinestarted() != null) {
                                            lineTerminatedby = (String)lineTerminatedby + "STARTING BY '" + Const.replace((String)this.getRealLinestarted(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealLineterminated() != null) {
                                            lineTerminatedby = (String)lineTerminatedby + " TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    String sqlBulkLoad = "LOAD DATA " + priorityText + " " + localExec + " INFILE '" + realFilename.replace('\\', '/') + "' " + replaceIgnore + " INTO TABLE " + (String)realTablename + " " + (String)fieldTerminatedby + " " + (String)lineTerminatedby + " " + (String)ignoreNbrLignes + " " + (String)listOfColumn + ";";
                                    try {
                                        db.execStatement(sqlBulkLoad);
                                        if (this.isAddFileToResult()) {
                                            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                        }
                                        result.setResult(true);
                                    }
                                    catch (HopDatabaseException je) {
                                        result.setNrErrors(1L);
                                        this.logError("An error occurred executing this action : " + je.getMessage());
                                    }
                                    catch (HopFileException e) {
                                        this.logError("An error occurred executing this action : " + e.getMessage());
                                        result.setNrErrors(1L);
                                    }
                                } else {
                                    result.setNrErrors(1L);
                                    if (this.log.isDetailed()) {
                                        this.logDetailed("Table [" + (String)realTablename + "] doesn't exist!");
                                    }
                                }
                                break block37;
                            }
                            catch (HopDatabaseException dbe) {
                                result.setNrErrors(1L);
                                this.logError("An error occurred executing this entry: " + dbe.getMessage());
                            }
                            break block37;
                        }
                        result.setNrErrors(1L);
                        this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Nodatabase.Label", (String[])new String[0]));
                        break block37;
                    }
                    result.setNrErrors(1L);
                    this.logError("File [" + realFilename + "] doesn't exist!");
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.UnexpectedError.Label", (String[])new String[0]), e);
                }
            } else {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Nofilename.Label", (String[])new String[0]));
            }
        }
        return result;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public boolean isReplacedata() {
        return this.replacedata;
    }

    public void setReplacedata(boolean replacedata) {
        this.replacedata = replacedata;
    }

    public void setLocalInfile(boolean localinfile) {
        this.localinfile = localinfile;
    }

    public boolean isLocalInfile() {
        return this.localinfile;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setLineterminated(String lineterminated) {
        this.lineterminated = lineterminated;
    }

    public void setLinestarted(String linestarted) {
        this.linestarted = linestarted;
    }

    public String getEnclosed() {
        return this.enclosed;
    }

    public String getRealEnclosed() {
        return this.resolve(this.getEnclosed());
    }

    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    public String getEscaped() {
        return this.escaped;
    }

    public String getRealEscaped() {
        return this.resolve(this.getEscaped());
    }

    public void setEscaped(String escaped) {
        this.escaped = escaped;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getLineterminated() {
        return this.lineterminated;
    }

    public String getLinestarted() {
        return this.linestarted;
    }

    public String getRealLinestarted() {
        return this.resolve(this.getLinestarted());
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineterminated());
    }

    public String getRealSeparator() {
        return this.resolve(this.getSeparator());
    }

    public void setIgnorelines(String ignorelines) {
        this.ignorelines = ignorelines;
    }

    public String getIgnorelines() {
        return this.ignorelines;
    }

    public String getRealIgnorelines() {
        return this.resolve(this.getIgnorelines());
    }

    public void setListattribut(String listattribut) {
        this.listattribut = listattribut;
    }

    public String getListattribut() {
        return this.listattribut;
    }

    public String getRealListattribut() {
        return this.resolve(this.getListattribut());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    private String MysqlString(String listcolumns) {
        Object returnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            returnString = ((String)returnString).equals("") ? "`" + Const.trim((String)split[i]) + "`" : (String)returnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return returnString;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        if (this.connection != null) {
            reference = new ResourceReference((IResourceHolder)this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

