/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.CalciteQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelRexNodeShuttle;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;

public class DynamicParamTypeExtractor {
    public static ParamsMetadata go(IgniteRel root) {
        DynamicParamsShuttle paramsShuttle = new DynamicParamsShuttle();
        new IgniteRelRexNodeShuttle(paramsShuttle).visit(root);
        return new ParamsMetadata(paramsShuttle.acc.values());
    }

    private static final class ParamsMetadata
    implements FieldsMetadata {
        private final Collection<RexDynamicParam> params;

        ParamsMetadata(Collection<RexDynamicParam> params) {
            this.params = params;
        }

        @Override
        public RelDataType rowType() {
            return null;
        }

        @Override
        public List<GridQueryFieldMetadata> queryFieldsMetadata(IgniteTypeFactory typeFactory) {
            return this.params.stream().map(param -> {
                RelDataType paramType = param.getType();
                Type fieldCls = typeFactory.getResultClass(paramType);
                return new CalciteQueryFieldMetadata(null, null, param.getName(), fieldCls == null ? Void.class.getName() : fieldCls.getTypeName(), paramType.getPrecision(), paramType.getScale(), paramType.isNullable());
            }).collect(Collectors.toList());
        }
    }

    private static final class DynamicParamsShuttle
    extends RexShuttle {
        private final SortedMap<Integer, RexDynamicParam> acc = new TreeMap<Integer, RexDynamicParam>();

        private DynamicParamsShuttle() {
        }

        public RexNode visitDynamicParam(RexDynamicParam param) {
            this.acc.put(param.getIndex(), param);
            return super.visitDynamicParam(param);
        }
    }
}

