/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheIndexesRebuildStatusCommandArg;
import org.apache.ignite.internal.management.cache.IndexRebuildStatusInfoContainer;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class IndexRebuildStatusTask
extends VisorMultiNodeTask<CacheIndexesRebuildStatusCommandArg, Map<UUID, Set<IndexRebuildStatusInfoContainer>>, Set<IndexRebuildStatusInfoContainer>> {
    private static final long serialVersionUID = 0L;

    protected IndexRebuildStatusJob job(CacheIndexesRebuildStatusCommandArg arg) {
        return new IndexRebuildStatusJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, Set<IndexRebuildStatusInfoContainer>> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<UUID, Set<IndexRebuildStatusInfoContainer>> reduceRes = new HashMap<UUID, Set<IndexRebuildStatusInfoContainer>>();
        for (ComputeJobResult jobResult : results) {
            if (((Set)jobResult.getData()).isEmpty()) continue;
            reduceRes.put(jobResult.getNode().id(), (Set)jobResult.getData());
        }
        return reduceRes;
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<CacheIndexesRebuildStatusCommandArg> arg) {
        UUID targetNodeId = arg.getArgument().nodeId();
        if (targetNodeId == null) {
            return this.ignite.cluster().forServers().nodes().stream().map(ClusterNode::id).collect(Collectors.toSet());
        }
        return Arrays.asList(targetNodeId);
    }

    private static class IndexRebuildStatusJob
    extends VisorJob<CacheIndexesRebuildStatusCommandArg, Set<IndexRebuildStatusInfoContainer>> {
        private static final long serialVersionUID = 0L;

        protected IndexRebuildStatusJob(@Nullable CacheIndexesRebuildStatusCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Set<IndexRebuildStatusInfoContainer> run(@Nullable CacheIndexesRebuildStatusCommandArg arg) throws IgniteException {
            Set rebuildIdxCaches = this.ignite.context().cache().publicCaches().stream().filter(c -> !c.indexReadyFuture().isDone()).collect(Collectors.toSet());
            HashSet<IndexRebuildStatusInfoContainer> res = new HashSet<IndexRebuildStatusInfoContainer>();
            for (IgniteCacheProxy cache : rebuildIdxCaches) {
                res.add(new IndexRebuildStatusInfoContainer(cache.context()));
            }
            return res;
        }
    }
}

