/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.roundrobin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiContext;

class RoundRobinGlobalLoadBalancer {
    private IgniteSpiContext ctx;
    private GridLocalEventListener lsnr;
    private final IgniteLogger log;
    private volatile GridNodeList nodeList = new GridNodeList(0, new ArrayList<UUID>(0));
    private final Object mux = new Object();
    private final CountDownLatch initLatch = new CountDownLatch(1);

    RoundRobinGlobalLoadBalancer(IgniteLogger log) {
        assert (log != null);
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onContextInitialized(IgniteSpiContext ctx) {
        this.ctx = ctx;
        this.lsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent);
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                Object object = RoundRobinGlobalLoadBalancer.this.mux;
                synchronized (object) {
                    if (evt.type() == 10) {
                        List<UUID> oldNodes = RoundRobinGlobalLoadBalancer.this.nodeList.getNodes();
                        if (!oldNodes.contains(nodeId)) {
                            ArrayList<UUID> newNodes = new ArrayList<UUID>(oldNodes.size() + 1);
                            newNodes.add(nodeId);
                            for (UUID node : oldNodes) {
                                newNodes.add(node);
                            }
                            RoundRobinGlobalLoadBalancer.this.nodeList = new GridNodeList(0, newNodes);
                        }
                    } else if (evt.type() == 17) {
                        Collection<ClusterNode> nodes = ((DiscoveryEvent)evt).topologyNodes();
                        ArrayList<UUID> newNodes = new ArrayList<UUID>(nodes.size());
                        for (ClusterNode node : nodes) {
                            newNodes.add(node.id());
                        }
                        RoundRobinGlobalLoadBalancer.this.nodeList = new GridNodeList(0, newNodes);
                    } else {
                        assert (evt.type() == 11 || evt.type() == 12);
                        List<UUID> oldNodes = RoundRobinGlobalLoadBalancer.this.nodeList.getNodes();
                        if (oldNodes.contains(nodeId)) {
                            ArrayList<UUID> newNodes = new ArrayList<UUID>(oldNodes.size() - 1);
                            for (UUID node : oldNodes) {
                                if (nodeId.equals(node)) continue;
                                newNodes.add(node);
                            }
                            RoundRobinGlobalLoadBalancer.this.nodeList = new GridNodeList(0, newNodes);
                        }
                    }
                }
            }
        };
        ctx.addLocalEventListener(this.lsnr, 12, 10, 11, 17);
        Object object = this.mux;
        synchronized (object) {
            List<UUID> oldNodes = this.nodeList.getNodes();
            HashSet<UUID> set = oldNodes == null ? new HashSet<UUID>() : new HashSet<UUID>(oldNodes);
            for (ClusterNode node : ctx.nodes()) {
                set.add(node.id());
            }
            this.nodeList = new GridNodeList(0, new ArrayList<UUID>(set));
        }
        this.initLatch.countDown();
    }

    void onContextDestroyed() {
        if (this.ctx != null) {
            this.ctx.removeLocalEventListener(this.lsnr);
        }
    }

    ClusterNode getBalancedNode(Collection<ClusterNode> top) throws IgniteException {
        ClusterNode found;
        assert (!F.isEmpty(top));
        this.awaitInitializationCompleted();
        HashMap<UUID, ClusterNode> topMap = null;
        int misses = 0;
        do {
            int nextIdx;
            int curIdx;
            AtomicInteger idx;
            GridNodeList nodeList;
            List<UUID> nodes;
            int cycleSize;
            if ((cycleSize = (nodes = (nodeList = this.nodeList).getNodes()).size()) == 0) {
                throw new IgniteException("Task topology does not have any alive nodes.");
            }
            while (!(idx = nodeList.getCurrentIdx()).compareAndSet(curIdx = idx.get(), nextIdx = (idx.get() + 1) % cycleSize)) {
            }
            found = RoundRobinGlobalLoadBalancer.findNodeById(top, nodes.get(nextIdx));
            if (found != null || ++misses < cycleSize) continue;
            if (topMap == null) {
                topMap = U.newHashMap(top.size());
                for (ClusterNode node : top) {
                    topMap.put(node.id(), node);
                }
            }
            RoundRobinGlobalLoadBalancer.checkBalancerNodes(top, topMap, nodes);
            misses = 0;
        } while (found == null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found round-robin node: " + found);
        }
        return found;
    }

    private static ClusterNode findNodeById(Iterable<ClusterNode> top, UUID foundNodeId) {
        for (ClusterNode node : top) {
            if (!foundNodeId.equals(node.id())) continue;
            return node;
        }
        return null;
    }

    private static void checkBalancerNodes(Collection<ClusterNode> top, Map<UUID, ClusterNode> topMap, Iterable<UUID> nodes) throws IgniteException {
        boolean contains = false;
        for (UUID nodeId : nodes) {
            if (topMap.get(nodeId) == null) continue;
            contains = true;
            break;
        }
        if (!contains) {
            throw new IgniteException("Task topology does not have alive nodes: " + top);
        }
    }

    private void awaitInitializationCompleted() throws IgniteException {
        try {
            if (this.initLatch.getCount() > 0L) {
                this.initLatch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException("Global balancer was interrupted.", e);
        }
    }

    List<UUID> getNodeIds() {
        List<UUID> nodes = this.nodeList.getNodes();
        return Collections.unmodifiableList(nodes);
    }

    public String toString() {
        return S.toString(RoundRobinGlobalLoadBalancer.class, this);
    }

    private static final class GridNodeList {
        private final AtomicInteger curIdx;
        private final List<UUID> nodes;

        private GridNodeList(int curIdx, List<UUID> nodes) {
            this.curIdx = new AtomicInteger(curIdx);
            this.nodes = nodes;
        }

        private AtomicInteger getCurrentIdx() {
            return this.curIdx;
        }

        private List<UUID> getNodes() {
            return this.nodes;
        }
    }
}

