/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheStripedExecutor {
    private final AtomicReference<IgniteCheckedException> error = new AtomicReference();
    private final StripedExecutor exec;
    private final Semaphore semaphore;

    public CacheStripedExecutor(StripedExecutor exec) {
        this.exec = exec;
        this.semaphore = new Semaphore(this.semaphorePermits(exec));
    }

    public void submit(Runnable task, int grpId, int partId) {
        int stripes = this.exec.stripesCount();
        int stripe = U.stripeIdx(stripes, grpId, partId);
        assert (stripe >= 0 && stripe <= stripes) : "idx=" + stripe + ", stripes=" + stripes;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        this.exec.execute(stripe, () -> {
            CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(1);
            try {
                task.run();
            }
            catch (Throwable err) {
                this.onError(new IgniteCheckedException("Failed to execute submitted task [grpId=" + grpId + ", partId=" + partId + "]", err));
            }
            finally {
                CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(0);
                this.semaphore.release();
            }
        });
    }

    public void awaitApplyComplete() throws IgniteCheckedException {
        try {
            this.exec.awaitComplete(new int[0]);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        IgniteCheckedException err = this.error.get();
        if (err != null) {
            throw err;
        }
    }

    public boolean error() {
        return this.error.get() != null;
    }

    public void onError(IgniteCheckedException e) {
        this.error.compareAndSet(null, e);
    }

    public StripedExecutor executor() {
        return this.exec;
    }

    private int semaphorePermits(StripedExecutor exec) {
        int permits = exec.stripesCount() * 4;
        long maxMemory = Runtime.getRuntime().maxMemory();
        int permits0 = (int)((double)maxMemory * 0.2 / 8192.0);
        if (permits0 < permits) {
            permits = permits0;
        }
        return IgniteSystemProperties.getInteger("IGNITE_RECOVERY_SEMAPHORE_PERMITS", permits);
    }
}

