/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDeploymentException;
import org.jetbrains.annotations.Nullable;

public class GridServiceDeploymentCompoundFuture<T extends Serializable>
extends GridCompoundFuture<Object, Object> {
    private Collection<T> svcsToRollback;
    private volatile ServiceDeploymentException err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processFailure(Throwable err, IgniteInternalFuture<Object> fut) {
        assert (fut instanceof GridServiceDeploymentFuture) : fut;
        GridServiceDeploymentFuture depFut = (GridServiceDeploymentFuture)fut;
        GridServiceDeploymentCompoundFuture gridServiceDeploymentCompoundFuture = this;
        synchronized (gridServiceDeploymentCompoundFuture) {
            if (this.err == null) {
                this.err = new ServiceDeploymentException("Failed to deploy some services.", new ArrayList<ServiceConfiguration>());
            }
            this.err.getFailedConfigurations().add(depFut.configuration());
            this.err.addSuppressed(err);
        }
        return true;
    }

    @Override
    protected boolean onDone(@Nullable Object res, @Nullable Throwable err, boolean cancel) {
        if (err == null && this.err != null) {
            err = new IgniteCheckedException(this.err);
        }
        return super.onDone(res, err, cancel);
    }

    public void add(GridServiceDeploymentFuture<T> fut, boolean own) {
        super.add(fut);
        if (own) {
            if (this.svcsToRollback == null) {
                this.svcsToRollback = new ArrayList<T>();
            }
            this.svcsToRollback.add(fut.serviceId());
        }
    }

    public Collection<T> servicesToRollback() {
        if (this.svcsToRollback != null) {
            return this.svcsToRollback;
        }
        return Collections.emptyList();
    }
}

