/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Apache.Ignite.Core.Binary
{
    /// <summary>
    /// Binary type name constants.
    /// </summary>
    public static class BinaryTypeNames
    {
        /// <summary> Type name: boolean. </summary>
        public const string TypeNameBool = "boolean";

        /// <summary> Type name: byte. </summary>
        public const string TypeNameByte = "byte";

        /// <summary> Type name: short. </summary>
        public const string TypeNameShort = "short";

        /// <summary> Type name: char. </summary>
        public const string TypeNameChar = "char";

        /// <summary> Type name: int. </summary>
        public const string TypeNameInt = "int";

        /// <summary> Type name: long. </summary>
        public const string TypeNameLong = "long";

        /// <summary> Type name: float. </summary>
        public const string TypeNameFloat = "float";

        /// <summary> Type name: double. </summary>
        public const string TypeNameDouble = "double";

        /// <summary> Type name: decimal. </summary>
        public const string TypeNameDecimal = "decimal";

        /// <summary> Type name: String. </summary>
        public const string TypeNameString = "String";

        /// <summary> Type name: UUID. </summary>
        public const string TypeNameGuid = "UUID";

        /// <summary> Type name: date. </summary>
        public const string TypeNameDate = "Date";

        /// <summary> Type name: timestamp. </summary>
        public const string TypeNameTimestamp = "Timestamp";

        /// <summary> Type name: Enum. </summary>
        public const string TypeNameEnum = "Enum";

        /// <summary> Type name: Object. </summary>
        public const string TypeNameObject = "Object";

        /// <summary> Type name: boolean array. </summary>
        public const string TypeNameArrayBool = "boolean[]";

        /// <summary> Type name: byte array. </summary>
        public const string TypeNameArrayByte = "byte[]";

        /// <summary> Type name: short array. </summary>
        public const string TypeNameArrayShort = "short[]";

        /// <summary> Type name: char array. </summary>
        public const string TypeNameArrayChar = "char[]";

        /// <summary> Type name: int array. </summary>
        public const string TypeNameArrayInt = "int[]";

        /// <summary> Type name: long array. </summary>
        public const string TypeNameArrayLong = "long[]";

        /// <summary> Type name: float array. </summary>
        public const string TypeNameArrayFloat = "float[]";

        /// <summary> Type name: double array. </summary>
        public const string TypeNameArrayDouble = "double[]";

        /// <summary> Type name: decimal array. </summary>
        public const string TypeNameArrayDecimal = "decimal[]";

        /// <summary> Type name: String array. </summary>
        public const string TypeNameArrayString = "String[]";

        /// <summary> Type name: UUID array. </summary>
        public const string TypeNameArrayGuid = "UUID[]";

        /// <summary> Type name: timestamp array. </summary>
        public const string TypeNameArrayDate = "Date[]";

        /// <summary> Type name: timestamp array. </summary>
        public const string TypeNameArrayTimestamp = "Timestamp[]";

        /// <summary> Type name: Enum array. </summary>
        public const string TypeNameArrayEnum = "Enum[]";

        /// <summary> Type name: Object array. </summary>
        public const string TypeNameArrayObject = "Object[]";

        /// <summary> Type name: Collection. </summary>
        public const string TypeNameCollection = "Collection";

        /// <summary> Type name: Map. </summary>
        public const string TypeNameMap = "Map";
    }
}
