/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.Lock;
import org.apache.ignite.internal.tx.LockException;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.tx.Waiter;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteSystemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapLockManager
implements LockManager {
    private ConcurrentHashMap<LockKey, LockState> locks = new ConcurrentHashMap();
    private final boolean allLockTypesAreUsed = IgniteSystemProperties.getBoolean((String)"IGNITE_ALL_LOCK_TYPES_ARE_USED");

    @Override
    public CompletableFuture<Lock> acquire(UUID txId, LockKey lockKey, LockMode lockMode) {
        LockState state;
        IgniteBiTuple<CompletableFuture<Void>, LockMode> futureTuple;
        if (!(lockKey.key() instanceof ByteBuffer) && !this.allLockTypesAreUsed) {
            lockMode = LockMode.NL;
        }
        while ((futureTuple = (state = this.lockState(lockKey)).tryAcquire(txId, lockMode)).get1() == null) {
        }
        LockMode newLockMode = (LockMode)((Object)futureTuple.get2());
        return ((CompletableFuture)futureTuple.get1()).thenApply(res -> new Lock(lockKey, newLockMode, txId));
    }

    @Override
    public void release(Lock lock) {
        LockState state = this.lockState(lock.lockKey());
        if (state.tryRelease(lock.txId())) {
            this.locks.remove(lock.lockKey(), state);
        }
    }

    @Override
    public void downgrade(Lock lock, LockMode lockMode) throws LockException {
        LockState state = this.lockState(lock.lockKey());
        state.tryDowngrade(lock, lockMode);
    }

    @Override
    public Iterator<Lock> locks(UUID txId) {
        ArrayList<Lock> result = new ArrayList<Lock>();
        for (Map.Entry<LockKey, LockState> entry : this.locks.entrySet()) {
            Waiter waiter = entry.getValue().waiter(txId);
            if (waiter == null) continue;
            result.add(new Lock(entry.getKey(), waiter.lockMode(), txId));
        }
        return result.iterator();
    }

    @NotNull
    private LockState lockState(LockKey key) {
        return this.locks.computeIfAbsent(key, k -> new LockState());
    }

    @Override
    public Collection<UUID> queue(LockKey key) {
        return this.lockState(key).queue();
    }

    @Override
    public Waiter waiter(LockKey key, UUID txId) {
        return this.lockState(key).waiter(txId);
    }

    @Override
    public boolean isEmpty() {
        return this.locks.isEmpty();
    }

    private static class WaiterImpl
    implements Comparable<WaiterImpl>,
    Waiter {
        @IgniteToStringExclude
        private final CompletableFuture<Void> fut = new CompletableFuture();
        private final UUID txId;
        private boolean upgraded;
        private LockMode prevLockMode;
        private LockMode lockMode;
        private boolean locked = false;

        WaiterImpl(UUID txId, LockMode lockMode) {
            this.txId = txId;
            this.lockMode = lockMode;
        }

        @Override
        public int compareTo(@NotNull WaiterImpl o) {
            return this.txId.compareTo(o.txId);
        }

        private void notifyLocked() {
            assert (this.locked);
            this.fut.complete(null);
        }

        @Override
        public boolean locked() {
            return this.locked;
        }

        @Override
        public LockMode lockMode() {
            return this.lockMode;
        }

        private void lock() {
            this.locked = true;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WaiterImpl)) {
                return false;
            }
            return this.compareTo((WaiterImpl)o) == 0;
        }

        public int hashCode() {
            return this.txId.hashCode();
        }

        public String toString() {
            return S.toString(WaiterImpl.class, (Object)this, (String)"isDone", (Object)this.fut.isDone());
        }
    }

    private static class LockState {
        private final TreeMap<UUID, WaiterImpl> waiters = new TreeMap();
        private boolean markedForRemove = false;

        private LockState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public IgniteBiTuple<CompletableFuture<Void>, LockMode> tryAcquire(UUID txId, LockMode lockMode) {
            boolean locked;
            WaiterImpl waiter = new WaiterImpl(txId, lockMode);
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                Map.Entry<UUID, WaiterImpl> nextEntry;
                if (this.markedForRemove) {
                    return new IgniteBiTuple(null, (Object)lockMode);
                }
                WaiterImpl prev = this.waiters.putIfAbsent(txId, waiter);
                if (prev != null && prev.locked) {
                    if (prev.lockMode.allowReenter(lockMode)) {
                        return new IgniteBiTuple(CompletableFuture.completedFuture(null), (Object)lockMode);
                    }
                    waiter.upgraded = true;
                    lockMode = LockMode.supremum(prev.lockMode, lockMode);
                    waiter.prevLockMode = prev.lockMode;
                    waiter.lockMode = lockMode;
                    this.waiters.put(txId, waiter);
                }
                if ((nextEntry = this.waiters.higherEntry(txId)) != null && nextEntry.getValue().locked() && !lockMode.isCompatible(nextEntry.getValue().lockMode)) {
                    if (prev == null) {
                        this.waiters.remove(txId);
                    } else {
                        this.waiters.put(txId, prev);
                    }
                    return new IgniteBiTuple(CompletableFuture.failedFuture((Throwable)((Object)new LockException(ErrorGroups.Transactions.ACQUIRE_LOCK_ERR, "Failed to acquire a lock due to a conflict [txId=" + txId + ", waiter=" + nextEntry.getValue() + "]"))), (Object)lockMode);
                }
                locked = this.waiters.firstKey().equals(txId);
                if (!locked) {
                    Map.Entry<UUID, WaiterImpl> prevEntry = this.waiters.lowerEntry(txId);
                    boolean bl = locked = prevEntry == null || prevEntry.getValue().lockMode.isCompatible(lockMode) && prevEntry.getValue().locked();
                }
                if (locked) {
                    if (waiter.upgraded) {
                        waiter.upgraded = false;
                        waiter.prevLockMode = null;
                        waiter.locked = true;
                    } else {
                        waiter.lock();
                    }
                }
            }
            if (locked) {
                waiter.notifyLocked();
            }
            return new IgniteBiTuple(waiter.fut, (Object)lockMode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryRelease(UUID txId) {
            WaiterImpl removed;
            ArrayList<WaiterImpl> locked = new ArrayList<WaiterImpl>();
            ArrayList<WaiterImpl> toFail = new ArrayList<WaiterImpl>();
            Iterator iterator = this.waiters;
            synchronized (iterator) {
                removed = this.waiters.remove(txId);
                this.markedForRemove = this.waiters.isEmpty();
                if (this.markedForRemove) {
                    return true;
                }
                HashSet<LockMode> lockModes = new HashSet<LockMode>();
                for (Map.Entry<UUID, WaiterImpl> entry : this.waiters.entrySet()) {
                    WaiterImpl tmp = entry.getValue();
                    if (tmp.upgraded && !removed.lockMode.isCompatible(tmp.prevLockMode)) {
                        assert (!tmp.locked);
                        tmp.upgraded = false;
                        tmp.lockMode = tmp.prevLockMode;
                        tmp.prevLockMode = null;
                        tmp.locked = true;
                        toFail.add(tmp);
                        continue;
                    }
                    if (!lockModes.stream().allMatch(tmp.lockMode::isCompatible)) continue;
                    if (tmp.upgraded) {
                        assert (!tmp.locked);
                        tmp.upgraded = false;
                        tmp.prevLockMode = null;
                        tmp.locked = true;
                    } else {
                        tmp.lock();
                    }
                    lockModes.add(tmp.lockMode);
                    locked.add(tmp);
                }
            }
            for (WaiterImpl waiter : locked) {
                waiter.notifyLocked();
            }
            for (WaiterImpl waiter : toFail) {
                waiter.fut.completeExceptionally((Throwable)((Object)new LockException(ErrorGroups.Transactions.RELEASE_LOCK_ERR, "Failed to acquire a lock due to a conflict [txId=" + txId + ", waiter=" + removed + "]")));
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryDowngrade(Lock lock, LockMode lockMode) throws LockException {
            WaiterImpl waiter = new WaiterImpl(lock.txId(), lockMode);
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                WaiterImpl prev = this.waiters.remove(lock.txId());
                if (prev != null) {
                    if (prev.lockMode == LockMode.IX && lockMode == LockMode.S || prev.lockMode == LockMode.S && lockMode == LockMode.IX || prev.lockMode.compareTo(lockMode) < 0) {
                        this.waiters.put(lock.txId(), prev);
                        throw new LockException(ErrorGroups.Transactions.DOWNGRADE_LOCK_ERR, "Cannot change lock mode from " + prev.lockMode + " to " + lockMode);
                    }
                    for (Map.Entry<UUID, WaiterImpl> entry : this.waiters.entrySet()) {
                        WaiterImpl tmp = entry.getValue();
                        if (lockMode.isCompatible(tmp.lockMode)) continue;
                        this.waiters.put(lock.txId(), waiter);
                        throw new LockException(ErrorGroups.Transactions.DOWNGRADE_LOCK_ERR, "Cannot change lock mode from " + prev.lockMode + " to " + lockMode);
                    }
                    this.waiters.put(lock.txId(), waiter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<UUID> queue() {
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                return new ArrayList<UUID>(this.waiters.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Waiter waiter(UUID txId) {
            TreeMap<UUID, WaiterImpl> treeMap = this.waiters;
            synchronized (treeMap) {
                return this.waiters.get(txId);
            }
        }
    }
}

