/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.util.ArrayUtils;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;

class RocksDbMetaStorage {
    private static final byte[] PARTITION_ID_PREFIX = "part".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PARTITION_ID_PREFIX_END = RocksUtils.incrementArray((byte[])PARTITION_ID_PREFIX);
    private final ColumnFamily metaColumnFamily;

    RocksDbMetaStorage(ColumnFamily metaColumnFamily) {
        this.metaColumnFamily = metaColumnFamily;
    }

    ColumnFamily columnFamily() {
        return this.metaColumnFamily;
    }

    int[] getPartitionIds() {
        Stream.Builder data = Stream.builder();
        try (Slice upperBound = new Slice(PARTITION_ID_PREFIX_END);
             ReadOptions options = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBound);
             RocksIterator it = this.metaColumnFamily.newIterator(options);){
            it.seek(PARTITION_ID_PREFIX);
            RocksUtils.forEach((RocksIterator)it, (key, value) -> data.add(key));
        }
        catch (RocksDBException e) {
            throw new StorageException("Error when reading a list of partition IDs from the meta Column Family", (Throwable)e);
        }
        return data.build().mapToInt(bytes -> {
            int higherByte = bytes[PARTITION_ID_PREFIX.length] & 0xFF;
            int lowerByte = bytes[PARTITION_ID_PREFIX.length + 1] & 0xFF;
            return higherByte << 8 | lowerByte;
        }).toArray();
    }

    void putPartitionId(int partitionId) {
        try {
            this.metaColumnFamily.put(RocksDbMetaStorage.partitionIdKey(partitionId), ArrayUtils.BYTE_EMPTY_ARRAY);
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to save partition " + partitionId + " in the meta Column Family", (Throwable)e);
        }
    }

    static byte[] partitionIdKey(int partitionId) {
        assert (partitionId >= 0 && partitionId <= 65535) : partitionId;
        return ByteBuffer.allocate(PARTITION_ID_PREFIX.length + 2).order(ByteOrder.BIG_ENDIAN).put(PARTITION_ID_PREFIX).putShort((short)partitionId).array();
    }
}

