/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.NotNull;

public class StripedThreadPoolExecutor
implements ExecutorService {
    private final ExecutorService[] execs;

    public StripedThreadPoolExecutor(int concurrentLvl, String threadNamePrefix, Thread.UncaughtExceptionHandler exHnd, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        this.execs = new ExecutorService[concurrentLvl];
        NamedThreadFactory factory = new NamedThreadFactory(threadNamePrefix, true, exHnd);
        for (int i = 0; i < concurrentLvl; ++i) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
            executor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
            this.execs[i] = executor;
        }
    }

    public void execute(Runnable task, int idx) {
        this.execs[this.threadId(idx)].execute(task);
    }

    @Override
    public void execute(Runnable cmd) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> submit(Runnable task, int idx) {
        return CompletableFuture.runAsync(task, this.execs[this.threadId(idx)]);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Runnable task, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    public int threadId(int idx) {
        return idx < this.execs.length ? idx : idx % this.execs.length;
    }

    @Override
    public void shutdown() {
        for (ExecutorService exec : this.execs) {
            exec.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.execs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> res = new ArrayList<Runnable>(this.execs.length);
        for (ExecutorService exec : this.execs) {
            for (Runnable r : exec.shutdownNow()) {
                res.add(r);
            }
        }
        return res;
    }

    @Override
    public boolean isShutdown() {
        for (ExecutorService exec : this.execs) {
            if (exec.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (ExecutorService exec : this.execs) {
            if (exec.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean res = true;
        for (ExecutorService exec : this.execs) {
            res &= exec.awaitTermination(timeout, unit);
        }
        return res;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(StripedThreadPoolExecutor.class, this);
    }
}

