/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.jdbc.proto.JdbcStatementType;
import org.apache.ignite.internal.tostring.S;

public class JdbcQueryExecuteRequest
implements ClientMessage {
    private JdbcStatementType stmtType;
    private String schemaName;
    private int pageSize;
    private int maxRows;
    private String sqlQry;
    private Object[] args;

    public JdbcQueryExecuteRequest() {
    }

    public JdbcQueryExecuteRequest(JdbcStatementType stmtType, String schemaName, int pageSize, int maxRows, String sqlQry, Object[] args) {
        Objects.requireNonNull(stmtType);
        this.stmtType = stmtType;
        this.schemaName = schemaName == null || schemaName.isEmpty() ? null : schemaName;
        this.pageSize = pageSize;
        this.maxRows = maxRows;
        this.sqlQry = sqlQry;
        this.args = args;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxRows() {
        return this.maxRows;
    }

    public String sqlQuery() {
        return this.sqlQry;
    }

    public Object[] arguments() {
        return this.args;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public JdbcStatementType getStmtType() {
        return this.stmtType;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packByte(this.stmtType.getId());
        packer.packString(this.schemaName);
        packer.packInt(this.pageSize);
        packer.packInt(this.maxRows);
        packer.packString(this.sqlQry);
        packer.packObjectArrayAsBinaryTuple(this.args);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.stmtType = JdbcStatementType.getStatement(unpacker.unpackByte());
        this.schemaName = unpacker.unpackString();
        this.pageSize = unpacker.unpackInt();
        this.maxRows = unpacker.unpackInt();
        this.sqlQry = unpacker.unpackString();
        this.args = unpacker.unpackObjectArrayFromBinaryTuple();
    }

    public String toString() {
        return S.toString(JdbcQueryExecuteRequest.class, (Object)this);
    }
}

