/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;

public class IgniteGateway
extends SingleRel
implements SourceAwareIgniteRel {
    private static final String EXTENSION_NAME_TERM = "name";
    private final String extensionName;
    private final long sourceId;

    public IgniteGateway(String extensionName, RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        this(extensionName, -1L, cluster, traits, input);
    }

    private IgniteGateway(String extensionName, long sourceId, RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, traits, input);
        this.sourceId = sourceId;
        this.extensionName = extensionName;
    }

    public IgniteGateway(RelInput input) {
        super(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getInput());
        this.extensionName = input.getString(EXTENSION_NAME_TERM);
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public String extensionName() {
        return this.extensionName;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item(EXTENSION_NAME_TERM, (Object)this.extensionName);
    }

    public boolean isEnforcer() {
        return true;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteGateway(this.extensionName, cluster, this.getTraitSet(), (RelNode)IgniteGateway.sole(inputs));
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteGateway(this.extensionName, sourceId, this.getCluster(), this.getTraitSet(), this.getInput());
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteGateway(this.extensionName, this.getCluster(), traitSet, (RelNode)IgniteGateway.sole(inputs));
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }
}

