/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite.raft.jraft.entity.RaftOutter;

class EntryMetaDeserializer
implements MessageDeserializer<RaftOutter.EntryMeta> {
    private final EntryMetaBuilder msg;

    EntryMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.entryMeta();
    }

    public Class<RaftOutter.EntryMeta> klass() {
        return RaftOutter.EntryMeta.class;
    }

    public RaftOutter.EntryMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.checksum(reader.readLong("checksum"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.dataLen(reader.readLong("dataLen"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.hasChecksum(reader.readBoolean("hasChecksum"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.learnersList(reader.readCollection("learnersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.msg.oldLearnersList(reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.msg.oldPeersList(reader.readCollection("oldPeersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.msg.peersList(reader.readCollection("peersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.msg.term(reader.readLong("term"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.msg.typeByteArray(reader.readByteArray("typeByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.EntryMeta.class);
    }
}

