/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.manager.IgniteTables;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientTableCommon {
    public static void writeSchema(ClientMessagePacker packer, int schemaVer, SchemaDescriptor schema) {
        packer.packInt(schemaVer);
        if (schema == null) {
            packer.packNil();
            return;
        }
        int colCnt = schema.columnNames().size();
        packer.packArrayHeader(colCnt);
        Set<Column> colocationCols = Set.of(schema.colocationColumns());
        for (int colIdx = 0; colIdx < colCnt; ++colIdx) {
            Column col = schema.column(colIdx);
            packer.packArrayHeader(6);
            packer.packString(col.name());
            packer.packInt(ClientTableCommon.getClientDataType(col.type().spec()));
            packer.packBoolean(schema.isKeyColumn(colIdx));
            packer.packBoolean(col.nullable());
            packer.packBoolean(colocationCols.contains(col));
            packer.packInt(ClientTableCommon.getDecimalScale(col.type()));
        }
    }

    public static void writeTupleOrNil(ClientMessagePacker packer, Tuple tuple, TuplePart part) {
        if (tuple == null) {
            packer.packNil();
            return;
        }
        SchemaDescriptor schema = ((SchemaAware)tuple).schema();
        ClientTableCommon.writeTuple(packer, tuple, schema, false, part);
    }

    public static void writeTuple(ClientMessagePacker packer, Tuple tuple, SchemaDescriptor schema, boolean skipHeader, TuplePart part) {
        assert (tuple != null);
        if (!skipHeader) {
            packer.packInt(schema.version());
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(ClientTableCommon.columnCount(schema, part), true);
        if (part != TuplePart.VAL) {
            for (Column col : schema.keyColumns().columns()) {
                ClientTableCommon.writeColumnValue(builder, tuple, col);
            }
        }
        if (part != TuplePart.KEY) {
            for (Column col : schema.valueColumns().columns()) {
                ClientTableCommon.writeColumnValue(builder, tuple, col);
            }
        }
        packer.packBinaryTuple(builder);
    }

    public static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, SchemaRegistry schemaRegistry, boolean skipHeader) {
        ClientTableCommon.writeTuples(packer, tuples, TuplePart.KEY_AND_VAL, schemaRegistry, skipHeader);
    }

    public static void writeTuples(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry, boolean skipHeader) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packNil();
            return;
        }
        SchemaDescriptor schema = schemaRegistry.schema();
        packer.packInt(schema.version());
        packer.packInt(tuples.size());
        for (Tuple tuple : tuples) {
            assert (tuple != null);
            assert (schema.version() == ((SchemaAware)tuple).schema().version());
            ClientTableCommon.writeTuple(packer, tuple, schema, skipHeader, part);
        }
    }

    public static void writeTuplesNullable(ClientMessagePacker packer, Collection<Tuple> tuples, TuplePart part, SchemaRegistry schemaRegistry, boolean skipHeader) {
        if (tuples == null || tuples.isEmpty()) {
            packer.packNil();
            return;
        }
        SchemaDescriptor schema = schemaRegistry.schema();
        packer.packInt(schema.version());
        packer.packInt(tuples.size());
        for (Tuple tuple : tuples) {
            if (tuple == null) {
                packer.packBoolean(false);
                continue;
            }
            assert (schema.version() == ((SchemaAware)tuple).schema().version());
            packer.packBoolean(true);
            ClientTableCommon.writeTuple(packer, tuple, schema, skipHeader, part);
        }
    }

    public static Tuple readTuple(ClientMessageUnpacker unpacker, TableImpl table, boolean keyOnly) {
        SchemaDescriptor schema = ClientTableCommon.readSchema(unpacker, table);
        return ClientTableCommon.readTuple(unpacker, keyOnly, schema);
    }

    public static Tuple readTuple(ClientMessageUnpacker unpacker, boolean keyOnly, SchemaDescriptor schema) {
        int cnt = keyOnly ? schema.keyColumns().length() : schema.length();
        BitSet noValueSet = unpacker.unpackBitSet();
        BinaryTupleReader binaryTupleReader = new BinaryTupleReader(cnt, unpacker.readBinaryUnsafe());
        Tuple tuple = Tuple.create((int)cnt);
        for (int i = 0; i < cnt; ++i) {
            if (noValueSet.get(i)) continue;
            Column column = schema.column(i);
            ClientBinaryTupleUtils.readAndSetColumnValue((BinaryTupleReader)binaryTupleReader, (int)i, (Tuple)tuple, (String)column.name(), (int)ClientTableCommon.getClientDataType(column.type().spec()), (int)ClientTableCommon.getDecimalScale(column.type()));
        }
        return tuple;
    }

    public static ArrayList<Tuple> readTuples(ClientMessageUnpacker unpacker, TableImpl table, boolean keyOnly) {
        SchemaDescriptor schema = ClientTableCommon.readSchema(unpacker, table);
        int rowCnt = unpacker.unpackInt();
        ArrayList<Tuple> res = new ArrayList<Tuple>(rowCnt);
        for (int i = 0; i < rowCnt; ++i) {
            res.add(ClientTableCommon.readTuple(unpacker, keyOnly, schema));
        }
        return res;
    }

    @NotNull
    public static SchemaDescriptor readSchema(ClientMessageUnpacker unpacker, TableImpl table) {
        int schemaId = unpacker.unpackInt();
        return table.schemaView().schema(schemaId);
    }

    public static TableImpl readTable(ClientMessageUnpacker unpacker, IgniteTables tables) {
        UUID tableId = unpacker.unpackUuid();
        try {
            TableImpl table = ((IgniteTablesInternal)tables).table(tableId);
            if (table == null) {
                throw new IgniteException(ErrorGroups.Client.TABLE_ID_NOT_FOUND_ERR, "Table does not exist: " + tableId);
            }
            return table;
        }
        catch (NodeStoppingException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public static Transaction readTx(ClientMessageUnpacker in, ClientResourceRegistry resources) {
        if (in.tryUnpackNil()) {
            return null;
        }
        try {
            return resources.get(in.unpackLong()).get(Transaction.class);
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteException(e.traceId(), e.code(), e.getMessage(), (Throwable)e);
        }
    }

    private static int getClientDataType(NativeTypeSpec spec) {
        switch (spec) {
            case INT8: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: {
                return 3;
            }
            case INT64: {
                return 4;
            }
            case FLOAT: {
                return 5;
            }
            case DOUBLE: {
                return 6;
            }
            case DECIMAL: {
                return 7;
            }
            case NUMBER: {
                return 16;
            }
            case UUID: {
                return 8;
            }
            case STRING: {
                return 9;
            }
            case BYTES: {
                return 10;
            }
            case BITMASK: {
                return 11;
            }
            case DATE: {
                return 12;
            }
            case TIME: {
                return 13;
            }
            case DATETIME: {
                return 14;
            }
            case TIMESTAMP: {
                return 15;
            }
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported native type: " + spec);
    }

    private static void writeColumnValue(BinaryTupleBuilder builder, Tuple tuple, Column col) {
        Object val = tuple.valueOrDefault(col.name(), null);
        if (val == null) {
            builder.appendNull();
            return;
        }
        switch (col.type().spec()) {
            case INT8: {
                builder.appendByte(((Byte)val).byteValue());
                break;
            }
            case INT16: {
                builder.appendShort(((Short)val).shortValue());
                break;
            }
            case INT32: {
                builder.appendInt(((Integer)val).intValue());
                break;
            }
            case INT64: {
                builder.appendLong(((Long)val).longValue());
                break;
            }
            case FLOAT: {
                builder.appendFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                builder.appendDouble(((Double)val).doubleValue());
                break;
            }
            case DECIMAL: {
                builder.appendDecimalNotNull((BigDecimal)val, ClientTableCommon.getDecimalScale(col.type()));
                break;
            }
            case NUMBER: {
                builder.appendNumberNotNull((BigInteger)val);
                break;
            }
            case UUID: {
                builder.appendUuidNotNull((UUID)val);
                break;
            }
            case STRING: {
                builder.appendStringNotNull((String)val);
                break;
            }
            case BYTES: {
                builder.appendBytesNotNull((byte[])val);
                break;
            }
            case BITMASK: {
                builder.appendBitmaskNotNull((BitSet)val);
                break;
            }
            case DATE: {
                builder.appendDateNotNull((LocalDate)val);
                break;
            }
            case TIME: {
                builder.appendTimeNotNull((LocalTime)val);
                break;
            }
            case DATETIME: {
                builder.appendDateTimeNotNull((LocalDateTime)val);
                break;
            }
            case TIMESTAMP: {
                builder.appendTimestampNotNull((Instant)val);
                break;
            }
            default: {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Data type not supported: " + col.type());
            }
        }
    }

    private static int columnCount(SchemaDescriptor schema, TuplePart part) {
        switch (part) {
            case KEY: {
                return schema.keyColumns().length();
            }
            case VAL: {
                return schema.valueColumns().length();
            }
        }
        return schema.length();
    }

    private static int getDecimalScale(NativeType type) {
        return type instanceof DecimalNativeType ? ((DecimalNativeType)type).scale() : 0;
    }
}

