/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.command.CommandUtils;
import org.apache.ignite.internal.table.distributed.command.PartitionCommand;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class UpdateAllCommand
extends PartitionCommand {
    private final TablePartitionId commitReplicationGroupId;
    private transient HashMap<RowId, BinaryRow> rowsToUpdate;
    private byte[] rowsToUpdateBytes;

    public UpdateAllCommand(@NotNull TablePartitionId commitReplicationGroupId, Collection<RowId> removeRows, @NotNull UUID txId) {
        this(commitReplicationGroupId, removeRows, null, txId);
    }

    public UpdateAllCommand(@NotNull TablePartitionId commitReplicationGroupId, Map<RowId, BinaryRow> rowsToUpdate, @NotNull UUID txId) {
        this(commitReplicationGroupId, null, rowsToUpdate, txId);
    }

    private UpdateAllCommand(@NotNull TablePartitionId commitReplicationGroupId, Collection<RowId> removeRows, Map<RowId, BinaryRow> rowsToUpdate, @NotNull UUID txId) {
        super(txId);
        this.commitReplicationGroupId = commitReplicationGroupId;
        int size = (removeRows == null ? 0 : removeRows.size()) + (rowsToUpdate == null ? 0 : rowsToUpdate.size());
        HashMap<RowId, BinaryRow> rows = new HashMap<RowId, BinaryRow>(size);
        if (!CollectionUtils.nullOrEmpty(removeRows)) {
            removeRows.forEach(rowId -> rows.put((RowId)rowId, (BinaryRow)null));
        }
        if (!CollectionUtils.nullOrEmpty(rowsToUpdate)) {
            rows.putAll(rowsToUpdate);
        }
        this.rowsToUpdate = rows;
        this.rowsToUpdateBytes = CommandUtils.rowMapToBytes(rows);
    }

    public TablePartitionId getReplicationGroupId() {
        return this.commitReplicationGroupId;
    }

    public HashMap<RowId, BinaryRow> getRowsToUpdate() {
        if (this.rowsToUpdate == null) {
            this.rowsToUpdate = new HashMap();
            CommandUtils.readRowMap(this.rowsToUpdateBytes, this.rowsToUpdate::put);
        }
        return this.rowsToUpdate;
    }
}

