/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.storage.index.BinaryTupleComparator;
import org.apache.ignite.internal.storage.index.IndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeInnerIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeLeafIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeMetaIo;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class SortedIndexTree
extends BplusTree<SortedIndexRowKey, SortedIndexRow> {
    private final DataPageReader dataPageReader;
    private final BinaryTupleComparator binaryTupleComparator;
    private final int inlineSize;

    public SortedIndexTree(int grpId, @Nullable String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, SortedIndexDescriptor indexDescriptor, boolean initNew) throws IgniteInternalCheckedException {
        super("SortedIndexTree_" + grpId, grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
        this.inlineSize = initNew ? InlineUtils.binaryTupleInlineSize(this.pageSize(), 38, (IndexDescriptor)indexDescriptor) : this.readInlineSizeFromMetaIo();
        this.setIos(SortedIndexTreeInnerIo.VERSIONS.get(this.inlineSize), SortedIndexTreeLeafIo.VERSIONS.get(this.inlineSize), SortedIndexTreeMetaIo.VERSIONS);
        this.dataPageReader = new DataPageReader(pageMem, grpId, this.statisticsHolder());
        this.binaryTupleComparator = new BinaryTupleComparator(indexDescriptor);
        this.initTree(initNew);
        if (initNew) {
            this.writeInlineSizeToMetaIo(this.inlineSize);
        }
    }

    public int partitionId() {
        return this.partId;
    }

    public DataPageReader dataPageReader() {
        return this.dataPageReader;
    }

    protected int compare(BplusIo<SortedIndexRowKey> io, long pageAddr, int idx, SortedIndexRowKey row) throws IgniteInternalCheckedException {
        SortedIndexTreeIo sortedIndexTreeIo = (SortedIndexTreeIo)io;
        return sortedIndexTreeIo.compare(this.dataPageReader, this.binaryTupleComparator, this.partId, pageAddr, idx, row);
    }

    public SortedIndexRow getRow(BplusIo<SortedIndexRowKey> io, long pageAddr, int idx, Object x) throws IgniteInternalCheckedException {
        SortedIndexTreeIo sortedIndexTreeIo = (SortedIndexTreeIo)io;
        return sortedIndexTreeIo.getRow(this.dataPageReader, this.partId, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    private int readInlineSizeFromMetaIo() throws IgniteInternalCheckedException {
        Integer inlineSize = (Integer)this.read(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> ((SortedIndexTreeMetaIo)io).getInlineSize(pageAddr), null, 0, -1);
        assert (inlineSize != -1);
        return inlineSize;
    }

    private void writeInlineSizeToMetaIo(int inlineSize) throws IgniteInternalCheckedException {
        Boolean result = (Boolean)this.write(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> {
            ((SortedIndexTreeMetaIo)io).setInlineSize(pageAddr, inlineSize);
            return Boolean.TRUE;
        }, 0, Boolean.FALSE, this.statisticsHolder());
        assert (result == Boolean.TRUE) : result;
    }
}

