/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.ClientAsyncResultSet;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.sql.StatementBuilderImpl;
import org.apache.ignite.internal.sql.StatementImpl;
import org.apache.ignite.internal.sql.SyncResultSetAdapter;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;

public class ClientSql
implements IgniteSql {
    private static final Mapper<SqlRow> sqlRowMapper = () -> SqlRow.class;
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;

    public ClientSql(ReliableChannel ch, MarshallersProvider marshallers) {
        this.ch = ch;
        this.marshallers = marshallers;
    }

    @Override
    public Statement createStatement(String query) {
        return new StatementImpl(query);
    }

    @Override
    public Statement.StatementBuilder statementBuilder() {
        return new StatementBuilderImpl();
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            return new SyncResultSetAdapter<SqlRow>(this.executeAsync(transaction, cancellationToken, query, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        try {
            return new SyncResultSetAdapter<SqlRow>(this.executeAsync(transaction, cancellationToken, statement, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            return new SyncResultSetAdapter<T>(this.executeAsync(transaction, mapper, cancellationToken, query, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        try {
            return new SyncResultSetAdapter<T>(this.executeAsync(transaction, mapper, cancellationToken, statement, arguments).join());
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, String dmlQuery, BatchedArguments batch) {
        return this.executeBatch(transaction, new StatementImpl(dmlQuery), batch);
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, Statement dmlStatement, BatchedArguments batch) {
        try {
            return this.executeBatchAsync(transaction, dmlStatement, batch).join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public void executeScript(String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            this.executeScriptAsync(query, arguments).join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
        }
    }

    @Override
    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        StatementImpl statement = new StatementImpl(query);
        return this.executeAsync(transaction, cancellationToken, (Statement)statement, arguments);
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.executeAsync(transaction, sqlRowMapper, cancellationToken, statement, arguments);
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        StatementImpl statement = new StatementImpl(query);
        return this.executeAsync(transaction, mapper, cancellationToken, statement, arguments);
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        PayloadWriter payloadWriter = w -> {
            ClientTable.writeTx(transaction, w);
            w.out().packString(statement.defaultSchema());
            w.out().packInt(statement.pageSize());
            w.out().packLong(statement.queryTimeout(TimeUnit.MILLISECONDS));
            w.out().packLongNullable(0L);
            w.out().packString(statement.timeZoneId().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(statement.query());
            w.out().packObjectArrayAsBinaryTuple(arguments);
            w.out().packLong(this.ch.observableTimestamp());
        };
        PayloadReader<AsyncResultSet> payloadReader = r -> new ClientAsyncResultSet(r.clientChannel(), this.marshallers, r.in(), mapper);
        if (transaction != null) {
            try {
                return ((CompletableFuture)ClientLazyTransaction.ensureStarted(transaction, this.ch, null).thenCompose(tx -> tx.channel().serviceAsync(50, payloadWriter, payloadReader))).exceptionally(ClientSql::handleException);
            }
            catch (TransactionException e) {
                return CompletableFuture.failedFuture(new SqlException(e.traceId(), e.code(), e.getMessage(), e));
            }
        }
        return this.ch.serviceAsync(50, payloadWriter, payloadReader);
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, String query, BatchedArguments batch) {
        return this.executeBatchAsync(transaction, new StatementImpl(query), batch);
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, Statement statement, BatchedArguments batch) {
        PayloadWriter payloadWriter = w -> {
            ClientTable.writeTx(transaction, w);
            w.out().packString(statement.defaultSchema());
            w.out().packInt(statement.pageSize());
            w.out().packLong(statement.queryTimeout(TimeUnit.MILLISECONDS));
            w.out().packNil();
            w.out().packString(statement.timeZoneId().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(statement.query());
            w.out().packBatchedArgumentsAsBinaryTupleArray(batch);
            w.out().packLong(this.ch.observableTimestamp());
        };
        PayloadReader<long[]> payloadReader = r -> {
            ClientMessageUnpacker unpacker = r.in();
            unpacker.skipValues(4);
            return unpacker.unpackLongArray();
        };
        return this.ch.serviceAsync(63, payloadWriter, payloadReader);
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        Objects.requireNonNull(query);
        PayloadWriter payloadWriter = w -> {
            w.out().packNil();
            w.out().packNil();
            w.out().packNil();
            w.out().packNil();
            w.out().packString(ZoneId.systemDefault().getId());
            ClientSql.packProperties(w, null);
            w.out().packString(query);
            w.out().packObjectArrayAsBinaryTuple(arguments);
            w.out().packLong(this.ch.observableTimestamp());
        };
        return this.ch.serviceAsync(56, payloadWriter, null);
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    private static void packProperties(PayloadOutputChannel w, @Nullable Map<String, Object> statementProps) {
        int size = 0;
        if (statementProps != null) {
            size += statementProps.size();
        }
        w.out().packInt(size);
        BinaryTupleBuilder builder = new BinaryTupleBuilder(size * 4);
        if (statementProps != null) {
            for (Map.Entry<String, Object> entry : statementProps.entrySet()) {
                builder.appendString(entry.getKey());
                ClientBinaryTupleUtils.appendObject(builder, entry.getValue());
            }
        }
        w.out().packBinaryTuple(builder);
    }

    private static <T> T handleException(Throwable e) {
        Throwable ex = ExceptionUtils.unwrapCause(e);
        if (ex instanceof TransactionException) {
            TransactionException te = (TransactionException)ex;
            throw new SqlException(te.traceId(), te.code(), te.getMessage(), te);
        }
        throw (RuntimeException)ExceptionUtils.sneakyThrow(ex);
    }
}

