/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.event;

import java.util.Objects;

public final class EventUser {
    private final String username;
    private final String authenticationProvider;

    private EventUser(String username, String authenticationProvider) {
        this.username = username;
        this.authenticationProvider = authenticationProvider;
    }

    public static EventUser of(String username, String authenticationProvider) {
        return new EventUser(username, authenticationProvider);
    }

    public static EventUser system() {
        return EventUser.of("SYSTEM", "SYSTEM");
    }

    public String authenticationProvider() {
        return this.authenticationProvider;
    }

    public String username() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventUser eventUser = (EventUser)o;
        return Objects.equals(this.username, eventUser.username) && Objects.equals(this.authenticationProvider, eventUser.authenticationProvider);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.authenticationProvider);
    }

    public String toString() {
        return "EventUser{username='" + this.username + "', authenticationProvider='" + this.authenticationProvider + "'}";
    }
}

