/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FilePageStoreHeader {
    private static final long SIGNATURE = -1037300167331204936L;
    private static final int COMMON_HEADER_SIZE = 16;
    private final int version;
    private final int pageSize;

    public FilePageStoreHeader(int version, int pageSize) {
        assert (pageSize >= 16) : pageSize;
        this.version = version;
        this.pageSize = pageSize;
    }

    public int version() {
        return this.version;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int headerSize() {
        return this.pageSize;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.allocate(this.headerSize()).order(ByteOrder.nativeOrder()).rewind().putLong(-1037300167331204936L).putInt(this.version).putInt(this.pageSize);
    }

    @Nullable
    public static FilePageStoreHeader readHeader(FileIo fileIo, ByteBuffer headerBuffer) throws IOException {
        assert (headerBuffer.remaining() >= 16) : headerBuffer.remaining();
        if (fileIo.size() < 16L) {
            return null;
        }
        fileIo.readFully(headerBuffer, 0L);
        long signature = headerBuffer.rewind().getLong();
        if (-1037300167331204936L != signature) {
            throw new IOException(String.format("Invalid file signature [expected=%s, actual=%s]", StringUtils.hexLong((long)-1037300167331204936L), StringUtils.hexLong((long)signature)));
        }
        return new FilePageStoreHeader(headerBuffer.getInt(), headerBuffer.getInt());
    }
}

