/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.type;

import java.util.Objects;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;

public class DecimalNativeType
extends NativeType {
    private final int precision;
    private final int scale;

    DecimalNativeType(int precision, int scale) {
        super(NativeTypeSpec.DECIMAL);
        this.precision = precision;
        this.scale = scale;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    @Override
    public String displayName() {
        return IgniteStringFormatter.format("{}({}, {})", super.displayName(), this.precision, this.scale);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecimalNativeType type = (DecimalNativeType)o;
        return this.precision == type.precision && this.scale == type.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.scale);
    }

    @Override
    public String toString() {
        return S.toString(DecimalNativeType.class.getSimpleName(), "name", (Object)this.spec(), "precision", (Object)this.precision, "scale", (Object)this.scale);
    }
}

