/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.OperationImpl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class OperationSerializer
implements MessageSerializer<Operation> {
    public static final OperationSerializer INSTANCE = new OperationSerializer();

    private OperationSerializer() {
    }

    public boolean writeMessage(Operation msg, MessageWriter writer) throws MessageMappingException {
        OperationImpl message = (OperationImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteBuffer("key", message.key());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                int ordinalShifted = message.type() == null ? 0 : message.type().ordinal() + 1;
                boolean written = writer.writeInt("type", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeByteBuffer("value", message.value());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

