/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore.accumulator;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.util.subscription.AccumulateException;
import org.apache.ignite.internal.util.subscription.Accumulator;

public class ClusterStatusAccumulator
implements Accumulator<Entry, List<UnitClusterStatus>> {
    private final List<UnitClusterStatus> result = new ArrayList<UnitClusterStatus>();
    private final Predicate<UnitClusterStatus> filter;

    public ClusterStatusAccumulator() {
        this(t -> true);
    }

    public ClusterStatusAccumulator(Predicate<UnitClusterStatus> filter) {
        this.filter = filter;
    }

    public void accumulate(Entry item) {
        byte[] value = item.value();
        if (value == null) {
            return;
        }
        UnitClusterStatus status = UnitClusterStatus.deserialize(value);
        if (this.filter.test(status)) {
            this.result.add(status);
        }
    }

    public List<UnitClusterStatus> get() throws AccumulateException {
        return this.result;
    }
}

