/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.future.timeout.TimeoutObject;
import org.apache.ignite.internal.future.timeout.TimeoutWorker;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.AbstractMessagingService;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.network.CriticalStripedExecutors;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.network.UnresolvableConsistentIdException;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.InvokeRequest;
import org.apache.ignite.internal.network.message.InvokeResponse;
import org.apache.ignite.internal.network.message.ScaleCubeMessage;
import org.apache.ignite.internal.network.netty.ConnectionManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.recovery.StaleIdDetector;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.thread.ExecutorChooser;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.internal.worker.CriticalSingleThreadExecutor;
import org.apache.ignite.internal.worker.CriticalWorker;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DefaultMessagingService
extends AbstractMessagingService {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultMessagingService.class);
    private final NetworkMessagesFactory factory;
    private final TopologyService topologyService;
    private final StaleIdDetector staleIdDetector;
    private final UserObjectMarshaller marshaller;
    private final ClassDescriptorRegistry classDescriptorRegistry;
    private final CriticalWorkerRegistry criticalWorkerRegistry;
    private volatile ConnectionManager connectionManager;
    private final ConcurrentMap<Long, TimeoutObjectImpl> requestsMap = new ConcurrentHashMap<Long, TimeoutObjectImpl>();
    private final AtomicLong correlationIdGenerator = new AtomicLong();
    private final CriticalSingleThreadExecutor outboundExecutor;
    private final CriticalStripedExecutors inboundExecutors;
    private final TimeoutWorker timeoutWorker;
    @Nullable
    private volatile BiPredicate<String, NetworkMessage> dropMessagesPredicate;
    private final Map<UUID, InetSocketAddress> recipientInetAddrByNodeId = new ConcurrentHashMap<UUID, InetSocketAddress>();

    public DefaultMessagingService(String nodeName, NetworkMessagesFactory factory, TopologyService topologyService, StaleIdDetector staleIdDetector, ClassDescriptorRegistry classDescriptorRegistry, UserObjectMarshaller marshaller, CriticalWorkerRegistry criticalWorkerRegistry, FailureManager failureManager, ChannelTypeRegistry channelTypeRegistry) {
        this.factory = factory;
        this.topologyService = topologyService;
        this.staleIdDetector = staleIdDetector;
        this.classDescriptorRegistry = classDescriptorRegistry;
        this.marshaller = marshaller;
        this.criticalWorkerRegistry = criticalWorkerRegistry;
        this.outboundExecutor = new CriticalSingleThreadExecutor(IgniteThreadFactory.create((String)nodeName, (String)"MessagingService-outbound", (IgniteLogger)LOG, (ThreadOperation[])ThreadOperation.NOTHING_ALLOWED));
        this.inboundExecutors = new CriticalStripedExecutors(nodeName, "MessagingService-inbound", criticalWorkerRegistry, channelTypeRegistry, LOG);
        this.timeoutWorker = new TimeoutWorker(LOG, nodeName, "MessagingService-timeout-worker", this.requestsMap, (FailureProcessor)failureManager);
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.addListener(this::handleMessageFromNetwork);
    }

    public void weakSend(ClusterNode recipient, NetworkMessage msg) {
        this.send(recipient, msg);
    }

    public CompletableFuture<Void> send(ClusterNode recipient, ChannelType channelType, NetworkMessage msg) {
        return this.send0(recipient, channelType, msg, null);
    }

    public CompletableFuture<Void> send(String recipientConsistentId, ChannelType channelType, NetworkMessage msg) {
        ClusterNode recipient = this.topologyService.getByConsistentId(recipientConsistentId);
        if (recipient == null) {
            return CompletableFuture.failedFuture((Throwable)new UnresolvableConsistentIdException("Recipient consistent ID cannot be resolved: " + recipientConsistentId));
        }
        return this.send0(recipient, channelType, msg, null);
    }

    public CompletableFuture<Void> respond(ClusterNode recipient, ChannelType type, NetworkMessage msg, long correlationId) {
        return this.send0(recipient, type, msg, correlationId);
    }

    public CompletableFuture<Void> respond(String recipientConsistentId, ChannelType type, NetworkMessage msg, long correlationId) {
        ClusterNode recipient = this.topologyService.getByConsistentId(recipientConsistentId);
        if (recipient == null) {
            return CompletableFuture.failedFuture((Throwable)new UnresolvableConsistentIdException("Recipient consistent ID cannot be resolved: " + recipientConsistentId));
        }
        return this.respond(recipient, type, msg, correlationId);
    }

    public CompletableFuture<NetworkMessage> invoke(ClusterNode recipient, ChannelType type, NetworkMessage msg, long timeout) {
        return this.invoke0(recipient, type, msg, timeout);
    }

    public CompletableFuture<NetworkMessage> invoke(String recipientConsistentId, ChannelType type, NetworkMessage msg, long timeout) {
        ClusterNode recipient = this.topologyService.getByConsistentId(recipientConsistentId);
        if (recipient == null) {
            return CompletableFuture.failedFuture((Throwable)new UnresolvableConsistentIdException("Recipient consistent ID cannot be resolved: " + recipientConsistentId));
        }
        return this.invoke0(recipient, type, msg, timeout);
    }

    private CompletableFuture<Void> send0(ClusterNode recipient, ChannelType type, NetworkMessage msg, @Nullable Long correlationId) {
        if (this.connectionManager.isStopped()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        if (this.shouldDropMessage(recipient, msg)) {
            return CompletableFutures.nullCompletedFuture();
        }
        InetSocketAddress recipientAddress = this.resolveRecipientAddress(recipient);
        if (recipientAddress == null) {
            if (correlationId != null) {
                this.onInvokeResponse(msg, correlationId);
            } else {
                this.sendToSelf(msg, null);
            }
            return CompletableFutures.nullCompletedFuture();
        }
        NetworkMessage message = correlationId != null ? this.responseFromMessage(msg, correlationId) : msg;
        return this.sendViaNetwork(recipient.name(), type, recipientAddress, message);
    }

    private boolean shouldDropMessage(ClusterNode recipient, NetworkMessage msg) {
        BiPredicate<String, NetworkMessage> predicate = this.dropMessagesPredicate;
        return predicate != null && predicate.test(recipient.name(), msg);
    }

    private CompletableFuture<NetworkMessage> invoke0(ClusterNode recipient, ChannelType type, NetworkMessage msg, long timeout) {
        if (this.connectionManager.isStopped()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        if (this.shouldDropMessage(recipient, msg)) {
            return new CompletableFuture().orTimeout(10L, TimeUnit.MILLISECONDS);
        }
        long correlationId = this.createCorrelationId();
        CompletableFuture<NetworkMessage> responseFuture = new CompletableFuture<NetworkMessage>();
        this.requestsMap.put(correlationId, new TimeoutObjectImpl(timeout > 0L ? FastTimestamps.coarseCurrentTimeMillis() + timeout : 0L, responseFuture));
        InetSocketAddress recipientAddress = this.resolveRecipientAddress(recipient);
        if (recipientAddress == null) {
            this.sendToSelf(msg, correlationId);
            return responseFuture;
        }
        InvokeRequest message = this.requestFromMessage(msg, correlationId);
        return this.sendViaNetwork(recipient.name(), type, recipientAddress, message).thenCompose(unused -> responseFuture);
    }

    private CompletableFuture<Void> sendViaNetwork(@Nullable String consistentId, ChannelType type, InetSocketAddress addr, NetworkMessage message) {
        List<ClassDescriptorMessage> descriptors;
        if (NettyBootstrapFactory.isInNetworkThread()) {
            return CompletableFuture.supplyAsync(() -> this.sendViaNetwork(consistentId, type, addr, message), (Executor)this.outboundExecutor).thenCompose(Function.identity());
        }
        try {
            descriptors = this.prepareMarshal(message);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to marshal message: " + e.getMessage(), (Throwable)e));
        }
        return this.connectionManager.channel(consistentId, type, addr).thenComposeToCompletable(sender -> sender.send(new OutNetworkObject(message, descriptors), () -> this.triggerChannelCreation(consistentId, type, addr)));
    }

    private void triggerChannelCreation(@Nullable String consistentId, ChannelType type, InetSocketAddress addr) {
        this.connectionManager.channel(consistentId, type, addr);
    }

    private List<ClassDescriptorMessage> prepareMarshal(NetworkMessage msg) throws Exception {
        IntOpenHashSet ids = new IntOpenHashSet();
        msg.prepareMarshal((IntSet)ids, (Object)this.marshaller);
        return PerSessionSerializationService.createClassDescriptorsMessages((IntSet)ids, this.classDescriptorRegistry);
    }

    private void sendToSelf(NetworkMessage message, @Nullable Long correlationId) {
        List handlerContexts = this.getHandlerContexts(message.groupType());
        for (int i = 0; i < handlerContexts.size(); ++i) {
            AbstractMessagingService.HandlerContext handlerContext = (AbstractMessagingService.HandlerContext)handlerContexts.get(i);
            handlerContext.handler().onReceived(message, this.topologyService.localMember(), correlationId);
        }
    }

    private void handleMessageFromNetwork(InNetworkObject inNetworkObject) {
        NetworkMessage payload;
        assert (NettyBootstrapFactory.isInNetworkThread()) : Thread.currentThread().getName();
        if (this.senderIdIsStale(inNetworkObject)) {
            DefaultMessagingService.logMessageSkipDueToSenderLeft(inNetworkObject);
            return;
        }
        NetworkMessage message = inNetworkObject.message();
        if (message instanceof InvokeResponse) {
            Executor executor = this.chooseExecutorInInboundPool(inNetworkObject);
            executor.execute(() -> this.handleInvokeResponse(inNetworkObject));
            return;
        }
        Long correlationId = null;
        if (message instanceof InvokeRequest) {
            InvokeRequest invokeRequest = (InvokeRequest)message;
            payload = invokeRequest.message();
            correlationId = invokeRequest.correlationId();
        } else {
            payload = message;
        }
        Iterator handlerContexts = this.getHandlerContexts(payload.groupType()).iterator();
        if (!handlerContexts.hasNext()) {
            return;
        }
        AbstractMessagingService.HandlerContext firstHandlerContext = (AbstractMessagingService.HandlerContext)handlerContexts.next();
        Executor firstHandlerExecutor = this.chooseExecutorFor(payload, inNetworkObject, (ExecutorChooser<NetworkMessage>)firstHandlerContext.executorChooser());
        Long finalCorrelationId = correlationId;
        firstHandlerExecutor.execute(() -> {
            long tookMillis;
            long startedNanos = System.nanoTime();
            try {
                this.handleStartingWithFirstHandler(payload, finalCorrelationId, inNetworkObject, firstHandlerContext, handlerContexts);
                tookMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNanos);
                if (tookMillis <= 100L) return;
            }
            catch (Throwable e) {
                long tookMillis2;
                try {
                    DefaultMessagingService.logAndRethrowIfError(inNetworkObject, e);
                    tookMillis2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNanos);
                    if (tookMillis2 <= 100L) return;
                }
                catch (Throwable throwable) {
                    long tookMillis3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNanos);
                    if (tookMillis3 <= 100L) throw throwable;
                    LOG.warn("Processing of {} from {} took {} ms", new Object[]{LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging(), inNetworkObject.sender(), tookMillis3});
                    throw throwable;
                }
                LOG.warn("Processing of {} from {} took {} ms", new Object[]{LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging(), inNetworkObject.sender(), tookMillis2});
                return;
            }
            LOG.warn("Processing of {} from {} took {} ms", new Object[]{LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging(), inNetworkObject.sender(), tookMillis});
            return;
        });
    }

    private static void logMessageSkipDueToSenderLeft(InNetworkObject inNetworkObject) {
        if (LOG.isInfoEnabled()) {
            NetworkMessage message = inNetworkObject.message();
            LOG.info("Sender ID {} ({}) is stale, so skipping message handling: {}", new Object[]{inNetworkObject.launchId(), inNetworkObject.consistentId(), LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging()});
        }
    }

    private boolean senderIdIsStale(InNetworkObject obj) {
        return this.staleIdDetector.isIdStale(obj.launchId());
    }

    private void handleInvokeResponse(InNetworkObject inNetworkObject) {
        this.unmarshalMessage(inNetworkObject);
        InvokeResponse response = (InvokeResponse)inNetworkObject.message();
        this.onInvokeResponse(response.message(), response.correlationId());
    }

    private void unmarshalMessage(InNetworkObject obj) {
        try {
            obj.message().unmarshal((Object)this.marshaller, (Object)obj.registry());
        }
        catch (Exception e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Failed to unmarshal message: " + e.getMessage(), (Throwable)e);
        }
    }

    private Executor chooseExecutorFor(NetworkMessage payload, InNetworkObject obj, ExecutorChooser<NetworkMessage> chooser) {
        if (DefaultMessagingService.wantsInboundPool(chooser)) {
            return this.chooseExecutorInInboundPool(obj);
        }
        return chooser.choose((Object)payload);
    }

    private Executor chooseExecutorInInboundPool(InNetworkObject obj) {
        int stripeIndex = IgniteUtils.safeAbs((int)obj.sender().id().hashCode());
        return this.inboundExecutors.executorFor(obj.connectionIndex(), stripeIndex);
    }

    private void handleStartingWithFirstHandler(NetworkMessage payload, @Nullable Long correlationId, InNetworkObject obj, AbstractMessagingService.HandlerContext firstHandlerContext, Iterator<AbstractMessagingService.HandlerContext> remainingContexts) {
        if (this.senderIdIsStale(obj)) {
            DefaultMessagingService.logMessageSkipDueToSenderLeft(obj);
            return;
        }
        this.unmarshalMessage(obj);
        assert (payload instanceof ScaleCubeMessage || obj.consistentId() != null);
        List<NetworkMessageHandler> handlersWithSameChooserAsFirst = List.of();
        while (remainingContexts.hasNext()) {
            AbstractMessagingService.HandlerContext handlerContext = remainingContexts.next();
            if (firstHandlerContext.executorChooser() == handlerContext.executorChooser()) {
                if (handlersWithSameChooserAsFirst.isEmpty()) {
                    handlersWithSameChooserAsFirst = new ArrayList();
                }
                handlersWithSameChooserAsFirst.add(handlerContext.handler());
                continue;
            }
            Executor executor = this.chooseExecutorFor(payload, obj, (ExecutorChooser<NetworkMessage>)handlerContext.executorChooser());
            executor.execute(() -> handlerContext.handler().onReceived(payload, obj.sender(), correlationId));
        }
        firstHandlerContext.handler().onReceived(payload, obj.sender(), correlationId);
        for (NetworkMessageHandler handler : handlersWithSameChooserAsFirst) {
            handler.onReceived(payload, obj.sender(), correlationId);
        }
    }

    private static void logAndRethrowIfError(InNetworkObject obj, Throwable e) {
        NetworkMessage message = obj.message();
        if (e instanceof UnresolvableConsistentIdException && message instanceof InvokeRequest) {
            if (LOG.isInfoEnabled()) {
                LOG.info("onMessage() failed while processing {} from {} as the sender has left the topology", new Object[]{LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging(), obj.sender()});
            }
        } else {
            LOG.error("onMessage() failed while processing {} from {}", e, new Object[]{LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging(), obj.sender()});
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    private void onInvokeResponse(NetworkMessage response, Long correlationId) {
        TimeoutObjectImpl responseFuture = (TimeoutObjectImpl)this.requestsMap.remove(correlationId);
        if (responseFuture != null) {
            responseFuture.future().complete(response);
        }
    }

    private InvokeRequest requestFromMessage(NetworkMessage message, long correlationId) {
        return this.factory.invokeRequest().correlationId(correlationId).message(message).build();
    }

    private InvokeResponse responseFromMessage(NetworkMessage message, long correlationId) {
        return this.factory.invokeResponse().correlationId(correlationId).message(message).build();
    }

    private long createCorrelationId() {
        return this.correlationIdGenerator.getAndIncrement();
    }

    public void start() {
        new IgniteThread((IgniteWorker)this.timeoutWorker).start();
        this.criticalWorkerRegistry.register((CriticalWorker)this.outboundExecutor);
        this.topologyService.addEventHandler(new TopologyEventHandler(){

            public void onDisappeared(ClusterNode member) {
                DefaultMessagingService.this.recipientInetAddrByNodeId.remove(member.id());
            }
        });
    }

    public void stop() throws Exception {
        NodeStoppingException exception = new NodeStoppingException();
        this.requestsMap.values().forEach(fut -> fut.future().completeExceptionally((Throwable)exception));
        this.requestsMap.clear();
        this.criticalWorkerRegistry.unregister((CriticalWorker)this.outboundExecutor);
        this.recipientInetAddrByNodeId.clear();
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        autoCloseableArray[0] = this.inboundExecutors::close;
        autoCloseableArray[1] = () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.outboundExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        autoCloseableArray[2] = () -> IgniteUtils.awaitForWorkersStop(List.of(this.timeoutWorker), (boolean)true, (IgniteLogger)LOG);
        IgniteUtils.closeAll((AutoCloseable[])autoCloseableArray);
    }

    @TestOnly
    public void dropMessages(BiPredicate<@Nullable String, NetworkMessage> predicate) {
        this.dropMessagesPredicate = predicate;
    }

    @TestOnly
    @Nullable
    public BiPredicate<String, NetworkMessage> dropMessagesPredicate() {
        return this.dropMessagesPredicate;
    }

    @TestOnly
    public void stopDroppingMessages() {
        this.dropMessagesPredicate = null;
    }

    @TestOnly
    public ConnectionManager connectionManager() {
        return this.connectionManager;
    }

    @Nullable
    private InetSocketAddress resolveRecipientAddress(ClusterNode recipientNode) {
        if (recipientNode.name() != null) {
            return this.connectionManager.consistentId().equals(recipientNode.name()) ? null : this.getFromCacheOrCreateResolved(recipientNode);
        }
        InetSocketAddress localAddress = this.connectionManager.localAddress();
        NetworkAddress recipientAddress = recipientNode.address();
        if (localAddress.getPort() != recipientAddress.port()) {
            return DefaultMessagingService.createResolved(recipientAddress);
        }
        if (Objects.equals(localAddress.getHostName(), recipientAddress.host())) {
            return null;
        }
        InetSocketAddress resolvedRecipientAddress = DefaultMessagingService.createResolved(recipientAddress);
        InetAddress recipientInetAddress = resolvedRecipientAddress.getAddress();
        if (Objects.equals(localAddress.getAddress(), recipientInetAddress)) {
            return null;
        }
        return recipientInetAddress.isAnyLocalAddress() || recipientInetAddress.isLoopbackAddress() ? null : resolvedRecipientAddress;
    }

    private static InetSocketAddress createResolved(NetworkAddress address) {
        return new InetSocketAddress(address.host(), address.port());
    }

    private InetSocketAddress getFromCacheOrCreateResolved(ClusterNode recipientNode) {
        assert (recipientNode.name() != null) : "Node has not been added to the topology: " + String.valueOf(recipientNode.id());
        InetSocketAddress address = this.recipientInetAddrByNodeId.compute(recipientNode.id(), (nodeId, inetSocketAddress) -> {
            if (this.staleIdDetector.isIdStale((UUID)nodeId)) {
                return null;
            }
            return inetSocketAddress != null ? inetSocketAddress : DefaultMessagingService.createResolved(recipientNode.address());
        });
        return address != null ? address : DefaultMessagingService.createResolved(recipientNode.address());
    }

    private static class TimeoutObjectImpl
    implements TimeoutObject<CompletableFuture<NetworkMessage>> {
        private final long endTime;
        private final CompletableFuture<NetworkMessage> fut;

        public TimeoutObjectImpl(long endTime, CompletableFuture<NetworkMessage> fut) {
            this.endTime = endTime;
            this.fut = fut;
        }

        public long endTime() {
            return this.endTime;
        }

        public CompletableFuture<NetworkMessage> future() {
            return this.fut;
        }
    }
}

