/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.metastorage.dsl.ConditionType;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.SimpleConditionBuilder;
import org.apache.ignite.internal.metastorage.dsl.SimpleConditionSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SimpleConditionImpl
implements SimpleCondition,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private final ConditionType type;

    private SimpleConditionImpl(ByteBuffer key, ConditionType type) {
        this.key = key;
        this.type = type;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public ConditionType type() {
        return this.type;
    }

    public MessageSerializer serializer() {
        return SimpleConditionSerializer.INSTANCE;
    }

    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(SimpleConditionImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SimpleConditionImpl otherMessage = (SimpleConditionImpl)other;
        return Objects.equals(this.key, otherMessage.key) && Objects.equals((Object)this.type, (Object)otherMessage.type);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.key, this.type});
        return result;
    }

    public SimpleConditionImpl clone() {
        try {
            return (SimpleConditionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SimpleConditionBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SimpleConditionBuilder {
        private ByteBuffer key;
        private ConditionType type;

        private Builder() {
        }

        @Override
        public SimpleConditionBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public SimpleConditionBuilder type(ConditionType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public ConditionType type() {
            return this.type;
        }

        @Override
        public SimpleCondition build() {
            return new SimpleConditionImpl(Objects.requireNonNull(this.key, "key is not marked @Nullable"), Objects.requireNonNull(this.type, "type is not marked @Nullable"));
        }
    }
}

