/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.managers.discovery.IgniteClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaselineNode
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String consistentId;
    private Map<String, Object> attrs;
    @Nullable
    private Long order;
    @NotNull
    private Collection<ResolvedAddresses> addrs = Collections.emptyList();

    public BaselineNode() {
    }

    public BaselineNode(org.apache.ignite.cluster.BaselineNode node, @NotNull Collection<ResolvedAddresses> resolvedInetAddrs) {
        this.consistentId = String.valueOf(node.consistentId());
        this.attrs = node.attributes();
        if (node instanceof IgniteClusterNode) {
            this.order = ((IgniteClusterNode)node).order();
            this.addrs = resolvedInetAddrs;
        }
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    public String getConsistentId() {
        return this.consistentId;
    }

    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    @Nullable
    public Long getOrder() {
        return this.order;
    }

    @NotNull
    public Collection<ResolvedAddresses> getAddrs() {
        return this.addrs;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.consistentId);
        U.writeMap(out, this.attrs);
        out.writeObject(this.order);
        U.writeCollection(out, this.addrs);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        Collection inputAddrs;
        this.consistentId = U.readString(in);
        this.attrs = U.readMap(in);
        if (protoVer >= 2) {
            this.order = (Long)in.readObject();
        }
        if (protoVer >= 3 && (inputAddrs = U.readCollection(in)) != null) {
            this.addrs = inputAddrs;
        }
    }

    public String toString() {
        return S.toString(BaselineNode.class, this);
    }

    public static class ResolvedAddresses
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private String hostname;
        private String addr;

        ResolvedAddresses(InetAddress inetAddr) {
            this.hostname = inetAddr.getHostName();
            this.addr = inetAddr.getHostAddress();
        }

        public ResolvedAddresses() {
        }

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            U.writeString(out, this.hostname);
            U.writeString(out, this.addr);
        }

        @Override
        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.hostname = U.readString(in);
            this.addr = U.readString(in);
        }

        public String hostname() {
            return this.hostname;
        }

        public String address() {
            return this.addr;
        }
    }
}

