/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class TableSortedPrimaryKey
extends TablePrimaryKey {
    private final List<CatalogColumnCollation> collations;

    private TableSortedPrimaryKey(@Nullable String name, List<String> columns, List<CatalogColumnCollation> collations) {
        super(name, columns);
        this.collations = collations != null ? List.copyOf(collations) : List.of();
    }

    public List<CatalogColumnCollation> collations() {
        return this.collations;
    }

    @Override
    void validate(List<ColumnParams> allColumns) {
        super.validate(allColumns);
        if (this.columns().size() != this.collations.size()) {
            throw new CatalogValidationException("Number of collations does not match.");
        }
    }

    public String toString() {
        return S.toString(TableSortedPrimaryKey.class, this, "columns", this.columns(), "collations", this.collations);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends TablePrimaryKey.TablePrimaryKeyBuilder<Builder> {
        @Nullable
        private String name;
        private List<String> columns;
        private List<CatalogColumnCollation> collations;

        Builder() {
        }

        public Builder collations(List<CatalogColumnCollation> collations) {
            this.collations = collations;
            return this;
        }

        @Override
        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public TableSortedPrimaryKey build() {
            return new TableSortedPrimaryKey(this.name, this.columns, this.collations);
        }
    }
}

