/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.sources;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.IntGauge;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.metrics.Metric;
import org.jetbrains.annotations.Nullable;

public class ThreadPoolMetricSource
extends AbstractMetricSource<Holder> {
    public static final String THREAD_POOLS_GROUP_NAME = "thread.pools";
    public static final String THREAD_POOLS_METRICS_SOURCE_NAME = "thread.pools.";
    private final ThreadPoolExecutor exec;

    public ThreadPoolMetricSource(String name, @Nullable String description, ThreadPoolExecutor exec) {
        this(name, description, THREAD_POOLS_GROUP_NAME, exec);
    }

    public ThreadPoolMetricSource(String name, @Nullable String description, @Nullable String group, ThreadPoolExecutor exec) {
        super(name, description, group);
        this.exec = exec;
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge activeCount = new IntGauge("ActiveCount", "Approximate number of threads that are actively executing tasks.", ThreadPoolMetricSource.this.exec::getActiveCount);
        private final LongGauge completedTaskCount = new LongGauge("CompletedTaskCount", "Approximate total number of tasks that have completed execution.", ThreadPoolMetricSource.this.exec::getCompletedTaskCount);
        private final IntGauge corePoolSize = new IntGauge("CorePoolSize", "The core number of threads.", ThreadPoolMetricSource.this.exec::getCorePoolSize);
        private final IntGauge largestPoolSize = new IntGauge("LargestPoolSize", "Largest number of threads that have ever simultaneously been in the pool.", ThreadPoolMetricSource.this.exec::getLargestPoolSize);
        private final IntGauge maximumPoolSize = new IntGauge("MaximumPoolSize", "The maximum allowed number of threads.", ThreadPoolMetricSource.this.exec::getMaximumPoolSize);
        private final IntGauge poolSize = new IntGauge("PoolSize", "Current number of threads in the pool.", ThreadPoolMetricSource.this.exec::getPoolSize);
        private final LongGauge taskCount = new LongGauge("TaskCount", "Approximate total number of tasks that have been scheduled for execution.", ThreadPoolMetricSource.this.exec::getTaskCount);
        private final IntGauge queueSize = new IntGauge("QueueSize", "Current size of the execution queue.", () -> ThreadPoolMetricSource.this.exec.getQueue().size());
        private final LongGauge keepAliveTime = new LongGauge("KeepAliveTime", "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.", () -> ThreadPoolMetricSource.this.exec.getKeepAliveTime(TimeUnit.MILLISECONDS));

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return List.of(this.activeCount, this.completedTaskCount, this.corePoolSize, this.largestPoolSize, this.maximumPoolSize, this.poolSize, this.taskCount, this.queueSize, this.keepAliveTime);
        }
    }
}

