/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.hash.io;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusInnerIo;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite3.internal.storage.pagememory.index.hash.io.HashIndexTreeIo;

public class HashIndexTreeInnerIo
extends BplusInnerIo<HashIndexRowKey>
implements HashIndexTreeIo {
    public static final List<IoVersions<HashIndexTreeInnerIo>> VERSIONS = IntStream.rangeClosed(0, 2048).mapToObj(inlineSize -> new IoVersions((PageIo[])new HashIndexTreeInnerIo[]{new HashIndexTreeInnerIo(1, inlineSize)})).collect(Collectors.toUnmodifiableList());

    private HashIndexTreeInnerIo(int ver, int inlineSize) {
        super(10000 + inlineSize, ver, true, inlineSize + 28);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<HashIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        HashIndexTreeIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, HashIndexRowKey row) {
        HashIndexTreeIo.super.storeByOffset(pageAddr, off, row);
    }

    @Override
    public HashIndexRowKey getLookupRow(BplusTree<HashIndexRowKey, ?> tree, long pageAddr, int idx) throws IgniteInternalCheckedException {
        HashIndexTree hashIndexTree = (HashIndexTree)tree;
        return this.getRow(hashIndexTree.dataPageReader(), hashIndexTree.partitionId(), pageAddr, idx);
    }
}

