/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted.comparator;

import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public class JitComparatorOptions {
    private final List<CatalogColumnCollation> columnCollations;
    private final List<NativeType> columnTypes;
    private final List<Boolean> nullableFlags;
    @Nullable
    private final String className;
    private final boolean supportPrefixes;
    private final boolean supportPartialComparison;

    private JitComparatorOptions(List<CatalogColumnCollation> columnCollations, List<NativeType> columnTypes, List<Boolean> nullableFlags, String className, boolean supportPrefixes, boolean supportPartialComparison) {
        this.columnCollations = columnCollations;
        this.columnTypes = columnTypes;
        this.nullableFlags = nullableFlags;
        this.className = className;
        this.supportPrefixes = supportPrefixes;
        this.supportPartialComparison = supportPartialComparison;
    }

    public List<CatalogColumnCollation> columnCollations() {
        return this.columnCollations;
    }

    public List<NativeType> columnTypes() {
        return this.columnTypes;
    }

    public List<Boolean> nullableFlags() {
        return this.nullableFlags;
    }

    @Nullable
    public String className() {
        return this.className;
    }

    public boolean supportPrefixes() {
        return this.supportPrefixes;
    }

    public boolean supportPartialComparison() {
        return this.supportPartialComparison;
    }

    public static JitComparatorOptionsBuilder builder() {
        return new JitComparatorOptionsBuilder();
    }

    public static class JitComparatorOptionsBuilder {
        private List<CatalogColumnCollation> columnCollations;
        private List<NativeType> columnTypes;
        private List<Boolean> nullableFlags;
        private String className;
        private boolean supportPrefixes;
        private boolean supportPartialComparison;

        public JitComparatorOptionsBuilder columnCollations(List<CatalogColumnCollation> columnCollations) {
            this.columnCollations = columnCollations;
            return this;
        }

        public JitComparatorOptionsBuilder columnTypes(List<NativeType> columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public JitComparatorOptionsBuilder nullableFlags(List<Boolean> nullableFlags) {
            this.nullableFlags = nullableFlags;
            return this;
        }

        public JitComparatorOptionsBuilder className(String className) {
            this.className = className;
            return this;
        }

        public JitComparatorOptionsBuilder supportPrefixes(boolean supportPrefixes) {
            this.supportPrefixes = supportPrefixes;
            return this;
        }

        public JitComparatorOptionsBuilder supportPartialComparison(boolean supportPartialComparison) {
            this.supportPartialComparison = supportPartialComparison;
            return this;
        }

        public JitComparatorOptions build() {
            Objects.requireNonNull(this.columnCollations, "columnCollations is null");
            Objects.requireNonNull(this.columnTypes, "columnTypes is null");
            Objects.requireNonNull(this.nullableFlags, "nullableFlags is null");
            if (this.columnCollations.size() != this.columnTypes.size() || this.columnCollations.size() != this.nullableFlags.size()) {
                throw new IllegalArgumentException("Column collations, types, and nullable flags must have the same size");
            }
            return new JitComparatorOptions(this.columnCollations, this.columnTypes, this.nullableFlags, this.className, this.supportPrefixes, this.supportPartialComparison);
        }
    }
}

